/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.server.coordinator.BalancerSegmentHolder;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class DruidCoordinatorBalancerTester
extends DruidCoordinatorBalancer {
    public DruidCoordinatorBalancerTester(DruidCoordinator coordinator) {
        super(coordinator);
    }

    protected void moveSegment(BalancerSegmentHolder segment, ImmutableDruidServer toServer, DruidCoordinatorRuntimeParams params) {
        String toServerName = toServer.getName();
        LoadQueuePeon toPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(toServerName);
        String fromServerName = segment.getFromServer().getName();
        DataSegment segmentToMove = segment.getSegment();
        String segmentName = segmentToMove.getIdentifier();
        if (!toPeon.getSegmentsToLoad().contains(segmentToMove) && toServer.getSegment(segmentName) == null && new ServerHolder(toServer, toPeon).getAvailableSize() > segmentToMove.getSize()) {
            log.info("Moving [%s] from [%s] to [%s]", new Object[]{segmentName, fromServerName, toServerName});
            try {
                LoadQueuePeon loadPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(toServerName);
                loadPeon.loadSegment(segment.getSegment(), new LoadPeonCallback(){

                    public void execute() {
                    }
                });
                LoadQueuePeon dropPeon = (LoadQueuePeon)params.getLoadManagementPeons().get(fromServerName);
                dropPeon.markSegmentToDrop(segment.getSegment());
                ((ConcurrentHashMap)this.currentlyMovingSegments.get("normal")).put(segmentName, segment);
            }
            catch (Exception e) {
                log.info((Throwable)e, StringUtils.format((String)"[%s] : Moving exception", (Object[])new Object[]{segmentName}), new Object[0]);
            }
        }
    }
}

