/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hive.druid.com.google.common.base.Stopwatch;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.client.ImmutableDruidServer;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorBalancerTester;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.LoadPeonCallback;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeon;
import org.apache.hive.druid.io.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.hive.druid.io.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.io.druid.server.coordinator.SegmentReplicantLookup;
import org.apache.hive.druid.io.druid.server.coordinator.ServerHolder;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorBalancer;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorRuleRunner;
import org.apache.hive.druid.io.druid.server.coordinator.rules.PeriodLoadRule;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.junit.Before;

public class DruidCoordinatorBalancerProfiler {
    private static final int MAX_SEGMENTS_TO_MOVE = 5;
    private DruidCoordinator coordinator;
    private ImmutableDruidServer druidServer1;
    private ImmutableDruidServer druidServer2;
    Map<String, DataSegment> segments = Maps.newHashMap();
    ServiceEmitter emitter;
    MetadataRuleManager manager;
    PeriodLoadRule loadRule = new PeriodLoadRule(new Period((Object)"P5000Y"), (Map)ImmutableMap.of((Object)"normal", (Object)3));
    List<Rule> rules = ImmutableList.of((Object)this.loadRule);

    @Before
    public void setUp() throws Exception {
        this.coordinator = (DruidCoordinator)EasyMock.createMock(DruidCoordinator.class);
        this.druidServer1 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.druidServer2 = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
        this.emitter = (ServiceEmitter)EasyMock.createMock(ServiceEmitter.class);
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        this.manager = (MetadataRuleManager)EasyMock.createMock(MetadataRuleManager.class);
    }

    public void bigProfiler() {
        int i;
        Stopwatch watch = Stopwatch.createUnstarted();
        int numSegments = 55000;
        int numServers = 50;
        EasyMock.expect((Object)this.manager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)"test", this.rules)).anyTimes();
        EasyMock.expect((Object)this.manager.getRules((String)EasyMock.anyObject())).andReturn(this.rules).anyTimes();
        EasyMock.expect((Object)this.manager.getRulesWithDefault((String)EasyMock.anyObject())).andReturn(this.rules).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.manager});
        this.coordinator.moveSegment((ImmutableDruidServer)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        ArrayList serverList = Lists.newArrayList();
        HashMap peonMap = Maps.newHashMap();
        ArrayList serverHolderList = Lists.newArrayList();
        HashMap segmentMap = Maps.newHashMap();
        for (i = 0; i < numSegments; ++i) {
            segmentMap.put("segment" + i, new DataSegment("datasource" + i, new Interval((ReadableInstant)DateTimes.of((String)"2012-01-01"), (ReadableInstant)DateTimes.of((String)"2012-01-01").plusHours(1)), DateTimes.of((String)"2012-03-01").toString(), (Map)Maps.newHashMap(), (List)Lists.newArrayList(), (List)Lists.newArrayList(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 4L));
        }
        for (i = 0; i < numServers; ++i) {
            ImmutableDruidServer server = (ImmutableDruidServer)EasyMock.createMock(ImmutableDruidServer.class);
            EasyMock.expect((Object)server.getMetadata()).andReturn(null).anyTimes();
            EasyMock.expect((Object)server.getCurrSize()).andReturn((Object)30L).atLeastOnce();
            EasyMock.expect((Object)server.getMaxSize()).andReturn((Object)100L).atLeastOnce();
            EasyMock.expect((Object)server.getTier()).andReturn((Object)"normal").anyTimes();
            EasyMock.expect((Object)server.getName()).andReturn((Object)Integer.toString(i)).atLeastOnce();
            EasyMock.expect((Object)server.getHost()).andReturn((Object)Integer.toString(i)).anyTimes();
            if (i == 0) {
                EasyMock.expect((Object)server.getSegments()).andReturn((Object)segmentMap).anyTimes();
            } else {
                EasyMock.expect((Object)server.getSegments()).andReturn(new HashMap()).anyTimes();
            }
            EasyMock.expect((Object)server.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
            EasyMock.replay((Object[])new Object[]{server});
            LoadQueuePeonTester peon = new LoadQueuePeonTester();
            peonMap.put(Integer.toString(i), peon);
            serverHolderList.add(new ServerHolder(server, (LoadQueuePeon)peon));
        }
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)serverHolderList.stream().collect(Collectors.toCollection(() -> new TreeSet(DruidCoordinatorBalancer.percentUsedComparator)))))).withLoadManagementPeons((Map)peonMap).withAvailableSegments(segmentMap.values()).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(5).withReplicantLifetime(500).withReplicationThrottleLimit(5).build()).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).withEmitter(this.emitter).withDatabaseRuleManager(this.manager).withReplicationManager(new ReplicationThrottler(2, 500)).withSegmentReplicantLookup(SegmentReplicantLookup.make((DruidCluster)new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)serverHolderList.stream().collect(Collectors.toCollection(() -> new TreeSet(DruidCoordinatorBalancer.percentUsedComparator))))))).build();
        DruidCoordinatorBalancerTester tester = new DruidCoordinatorBalancerTester(this.coordinator);
        DruidCoordinatorRuleRunner runner = new DruidCoordinatorRuleRunner(this.coordinator);
        watch.start();
        DruidCoordinatorRuntimeParams balanceParams = tester.run(params);
        DruidCoordinatorRuntimeParams assignParams = runner.run(params);
        System.out.println(watch.stop());
    }

    public void profileRun() {
        Stopwatch watch = Stopwatch.createUnstarted();
        LoadQueuePeonTester fromPeon = new LoadQueuePeonTester();
        LoadQueuePeonTester toPeon = new LoadQueuePeonTester();
        EasyMock.expect((Object)this.druidServer1.getName()).andReturn((Object)"from").atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getCurrSize()).andReturn((Object)30L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer1.getSegments()).andReturn(this.segments).anyTimes();
        EasyMock.expect((Object)this.druidServer1.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer1});
        EasyMock.expect((Object)this.druidServer2.getName()).andReturn((Object)"to").atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getTier()).andReturn((Object)"normal").anyTimes();
        EasyMock.expect((Object)this.druidServer2.getCurrSize()).andReturn((Object)0L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getMaxSize()).andReturn((Object)100L).atLeastOnce();
        EasyMock.expect((Object)this.druidServer2.getSegments()).andReturn(new HashMap()).anyTimes();
        EasyMock.expect((Object)this.druidServer2.getSegment((String)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.druidServer2});
        this.coordinator.moveSegment((ImmutableDruidServer)EasyMock.anyObject(), (ImmutableDruidServer)EasyMock.anyObject(), (DataSegment)EasyMock.anyObject(), (LoadPeonCallback)EasyMock.anyObject());
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinator});
        DruidCoordinatorRuntimeParams params = DruidCoordinatorRuntimeParams.newBuilder().withDruidCluster(new DruidCluster(null, (Map)ImmutableMap.of((Object)"normal", (Object)Stream.of(new ServerHolder(this.druidServer1, (LoadQueuePeon)fromPeon), new ServerHolder(this.druidServer2, (LoadQueuePeon)toPeon)).collect(Collectors.toCollection(() -> new TreeSet(DruidCoordinatorBalancer.percentUsedComparator)))))).withLoadManagementPeons((Map)ImmutableMap.of((Object)"from", (Object)((Object)fromPeon), (Object)"to", (Object)((Object)toPeon))).withAvailableSegments(this.segments.values()).withDynamicConfigs(new CoordinatorDynamicConfig.Builder().withMaxSegmentsToMove(5).build()).withBalancerReferenceTimestamp(DateTimes.of((String)"2013-01-01")).build();
        DruidCoordinatorBalancerTester tester = new DruidCoordinatorBalancerTester(this.coordinator);
        watch.start();
        DruidCoordinatorRuntimeParams balanceParams = tester.run(params);
        System.out.println(watch.stop());
    }
}

