/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSupplier;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricExtractor;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class HyperUniquesSerdeForTest
extends ComplexMetricSerde {
    private static Ordering<HyperLogLogCollector> comparator = new Ordering<HyperLogLogCollector>(){

        public int compare(HyperLogLogCollector arg1, HyperLogLogCollector arg2) {
            return arg1.toByteBuffer().compareTo(arg2.toByteBuffer());
        }
    }.nullsFirst();
    private final HashFunction hashFn;

    public HyperUniquesSerdeForTest(HashFunction hashFn) {
        this.hashFn = hashFn;
    }

    public String getTypeName() {
        return "hyperUnique";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<HyperLogLogCollector> extractedClass() {
                return HyperLogLogCollector.class;
            }

            public HyperLogLogCollector extractValue(InputRow inputRow, String metricName) {
                Object rawValue = inputRow.getRaw(metricName);
                if (rawValue instanceof HyperLogLogCollector) {
                    return (HyperLogLogCollector)rawValue;
                }
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                List dimValues = inputRow.getDimension(metricName);
                if (dimValues == null) {
                    return collector;
                }
                for (String dimensionValue : dimValues) {
                    collector.add(HyperUniquesSerdeForTest.this.hashFn.hashBytes(StringUtils.toUtf8((String)dimensionValue)).asBytes());
                }
                return collector;
            }
        };
    }

    public void deserializeColumn(ByteBuffer byteBuffer, ColumnBuilder columnBuilder) {
        GenericIndexed column = columnBuilder.getFileMapper() == null ? GenericIndexed.read((ByteBuffer)byteBuffer, (ObjectStrategy)this.getObjectStrategy()) : GenericIndexed.read((ByteBuffer)byteBuffer, (ObjectStrategy)this.getObjectStrategy(), (SmooshedFileMapper)columnBuilder.getFileMapper());
        columnBuilder.setComplexColumn((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), column));
    }

    public ObjectStrategy getObjectStrategy() {
        return new ObjectStrategy<HyperLogLogCollector>(){

            public Class<? extends HyperLogLogCollector> getClazz() {
                return HyperLogLogCollector.class;
            }

            public HyperLogLogCollector fromByteBuffer(ByteBuffer buffer, int numBytes) {
                ByteBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
                readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
                return HyperLogLogCollector.makeCollector((ByteBuffer)readOnlyBuffer);
            }

            public byte[] toBytes(HyperLogLogCollector collector) {
                if (collector == null) {
                    return new byte[0];
                }
                ByteBuffer val = collector.toByteBuffer();
                byte[] retVal = new byte[val.remaining()];
                val.asReadOnlyBuffer().get(retVal);
                return retVal;
            }

            public int compare(HyperLogLogCollector o1, HyperLogLogCollector o2) {
                return comparator.compare((Object)o1, (Object)o2);
            }
        };
    }

    public GenericColumnSerializer getSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String metric) {
        return LargeColumnSupportedComplexColumnSerializer.createWithColumnSize((SegmentWriteOutMedium)segmentWriteOutMedium, (String)metric, (ObjectStrategy)this.getObjectStrategy(), (int)Integer.MAX_VALUE);
    }
}

