/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.firehose;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.CSVParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.io.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.io.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.LocalFirehoseFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalFirehoseFactoryTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private LocalFirehoseFactory factory;

    @Before
    public void setup() throws IOException {
        Throwable throwable;
        BufferedWriter writer;
        int i;
        for (i = 0; i < 5; ++i) {
            writer = Files.newBufferedWriter(this.temporaryFolder.newFile("test_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                writer.write(20171225 + i + "," + i + "th test file\n");
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        for (i = 0; i < 5; ++i) {
            writer = Files.newBufferedWriter(this.temporaryFolder.newFile("filtered_" + i).toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
            throwable = null;
            try {
                writer.write(20171225 + i + "," + i + "th filtered file\n");
                continue;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            ((Writer)writer).close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ((Writer)writer).close();
                    }
                }
            }
        }
        this.factory = new LocalFirehoseFactory(this.temporaryFolder.getRoot(), "test_*", null);
    }

    @Test
    public void testConnect() throws IOException {
        try (Firehose firehose = this.factory.connect(new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a")), (List)Lists.newArrayList(), (List)Lists.newArrayList()), ",", Arrays.asList("timestamp", "a"), false, 0), Charsets.UTF_8.name()), null);){
            ArrayList<Object> rows = new ArrayList<Object>();
            while (firehose.hasMore()) {
                rows.add(firehose.nextRow());
            }
            Assert.assertEquals((long)5L, (long)rows.size());
            rows.sort(Comparator.comparing(Row::getTimestamp));
            for (int i = 0; i < 5; ++i) {
                List dimVals = ((Row)rows.get(i)).getDimension("a");
                Assert.assertEquals((long)1L, (long)dimVals.size());
                Assert.assertEquals((Object)(i + "th test file"), dimVals.get(0));
            }
        }
    }
}

