/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.jsontype.NamedType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentFinder;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalDataSegmentFinderTest {
    private static final ObjectMapper mapper = TestHelper.makeJsonMapper();
    private static final String DESCRIPTOR_JSON = "descriptor.json";
    private static final String INDEX_ZIP = "index.zip";
    private static final DataSegment SEGMENT_1 = DataSegment.builder().dataSource("wikipedia").interval(Intervals.of((String)"2013-08-31T00:00:00.000Z/2013-09-01T00:00:00.000Z")).version("2015-10-21T22:07:57.074Z").loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"/tmp/somewhere/index.zip")).dimensions((List)ImmutableList.of((Object)"language", (Object)"page")).metrics((List)ImmutableList.of((Object)"count")).build();
    private static final DataSegment SEGMENT_2 = DataSegment.builder((DataSegment)SEGMENT_1).interval(Intervals.of((String)"2013-09-01T00:00:00.000Z/2013-09-02T00:00:00.000Z")).build();
    private static final DataSegment SEGMENT_3 = DataSegment.builder((DataSegment)SEGMENT_1).interval(Intervals.of((String)"2013-09-02T00:00:00.000Z/2013-09-03T00:00:00.000Z")).version("2015-10-22T22:07:57.074Z").build();
    private static final DataSegment SEGMENT_4_0 = DataSegment.builder((DataSegment)SEGMENT_1).interval(Intervals.of((String)"2013-09-02T00:00:00.000Z/2013-09-03T00:00:00.000Z")).shardSpec((ShardSpec)new NumberedShardSpec(0, 2)).build();
    private static final DataSegment SEGMENT_4_1 = DataSegment.builder((DataSegment)SEGMENT_1).interval(Intervals.of((String)"2013-09-02T00:00:00.000Z/2013-09-03T00:00:00.000Z")).shardSpec((ShardSpec)new NumberedShardSpec(1, 2)).build();
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File dataSourceDir;
    private File descriptor1;
    private File descriptor2;
    private File descriptor3;
    private File descriptor4_0;
    private File descriptor4_1;
    private File indexZip1;
    private File indexZip2;
    private File indexZip3;
    private File indexZip4_0;
    private File indexZip4_1;

    @BeforeClass
    public static void setUpStatic() {
        mapper.registerSubtypes(new NamedType[]{new NamedType(NumberedShardSpec.class, "numbered")});
    }

    @Before
    public void setUp() throws Exception {
        this.dataSourceDir = this.temporaryFolder.newFolder();
        this.descriptor1 = new File(this.dataSourceDir.getAbsolutePath() + "/interval1/v1/0", DESCRIPTOR_JSON);
        this.descriptor2 = new File(this.dataSourceDir.getAbsolutePath() + "/interval2/v1/0", DESCRIPTOR_JSON);
        this.descriptor3 = new File(this.dataSourceDir.getAbsolutePath() + "/interval3/v2/0", DESCRIPTOR_JSON);
        this.descriptor4_0 = new File(this.dataSourceDir.getAbsolutePath() + "/interval4/v1/0", DESCRIPTOR_JSON);
        this.descriptor4_1 = new File(this.dataSourceDir.getAbsolutePath() + "/interval4/v1/1", DESCRIPTOR_JSON);
        this.descriptor1.getParentFile().mkdirs();
        this.descriptor2.getParentFile().mkdirs();
        this.descriptor3.getParentFile().mkdirs();
        this.descriptor4_0.getParentFile().mkdirs();
        this.descriptor4_1.getParentFile().mkdirs();
        mapper.writeValue(this.descriptor1, (Object)SEGMENT_1);
        mapper.writeValue(this.descriptor2, (Object)SEGMENT_2);
        mapper.writeValue(this.descriptor3, (Object)SEGMENT_3);
        mapper.writeValue(this.descriptor4_0, (Object)SEGMENT_4_0);
        mapper.writeValue(this.descriptor4_1, (Object)SEGMENT_4_1);
        this.indexZip1 = new File(this.descriptor1.getParentFile(), INDEX_ZIP);
        this.indexZip2 = new File(this.descriptor2.getParentFile(), INDEX_ZIP);
        this.indexZip3 = new File(this.descriptor3.getParentFile(), INDEX_ZIP);
        this.indexZip4_0 = new File(this.descriptor4_0.getParentFile(), INDEX_ZIP);
        this.indexZip4_1 = new File(this.descriptor4_1.getParentFile(), INDEX_ZIP);
        this.indexZip1.createNewFile();
        this.indexZip2.createNewFile();
        this.indexZip3.createNewFile();
        this.indexZip4_0.createNewFile();
        this.indexZip4_1.createNewFile();
    }

    @Test
    public void testFindSegments() throws SegmentLoadingException, IOException {
        LocalDataSegmentFinder localDataSegmentFinder = new LocalDataSegmentFinder(mapper);
        Set segments = localDataSegmentFinder.findSegments(this.dataSourceDir.getAbsolutePath(), false);
        Assert.assertEquals((long)5L, (long)segments.size());
        DataSegment updatedSegment1 = null;
        DataSegment updatedSegment2 = null;
        DataSegment updatedSegment3 = null;
        DataSegment updatedSegment4_0 = null;
        DataSegment updatedSegment4_1 = null;
        for (DataSegment dataSegment : segments) {
            if (dataSegment.getIdentifier().equals(SEGMENT_1.getIdentifier())) {
                updatedSegment1 = dataSegment;
                continue;
            }
            if (dataSegment.getIdentifier().equals(SEGMENT_2.getIdentifier())) {
                updatedSegment2 = dataSegment;
                continue;
            }
            if (dataSegment.getIdentifier().equals(SEGMENT_3.getIdentifier())) {
                updatedSegment3 = dataSegment;
                continue;
            }
            if (dataSegment.getIdentifier().equals(SEGMENT_4_0.getIdentifier())) {
                updatedSegment4_0 = dataSegment;
                continue;
            }
            if (dataSegment.getIdentifier().equals(SEGMENT_4_1.getIdentifier())) {
                updatedSegment4_1 = dataSegment;
                continue;
            }
            Assert.fail((String)"Unexpected segment");
        }
        Assert.assertEquals((Object)this.descriptor1.getAbsolutePath(), (Object)this.getDescriptorPath(updatedSegment1));
        Assert.assertEquals((Object)this.descriptor2.getAbsolutePath(), (Object)this.getDescriptorPath(updatedSegment2));
        Assert.assertEquals((Object)this.descriptor3.getAbsolutePath(), (Object)this.getDescriptorPath(updatedSegment3));
        Assert.assertEquals((Object)this.descriptor4_0.getAbsolutePath(), (Object)this.getDescriptorPath(updatedSegment4_0));
        Assert.assertEquals((Object)this.descriptor4_1.getAbsolutePath(), (Object)this.getDescriptorPath(updatedSegment4_1));
        String serializedSegment1 = mapper.writeValueAsString((Object)updatedSegment1);
        String serializedSegment2 = mapper.writeValueAsString((Object)updatedSegment2);
        String serializedSegment3 = mapper.writeValueAsString((Object)updatedSegment3);
        String serializedSegment4_0 = mapper.writeValueAsString((Object)updatedSegment4_0);
        String serializedSegment4_1 = mapper.writeValueAsString((Object)updatedSegment4_1);
        Assert.assertNotEquals((Object)serializedSegment1, (Object)FileUtils.readFileToString((File)this.descriptor1));
        Assert.assertNotEquals((Object)serializedSegment2, (Object)FileUtils.readFileToString((File)this.descriptor2));
        Assert.assertNotEquals((Object)serializedSegment3, (Object)FileUtils.readFileToString((File)this.descriptor3));
        Assert.assertNotEquals((Object)serializedSegment4_0, (Object)FileUtils.readFileToString((File)this.descriptor4_0));
        Assert.assertNotEquals((Object)serializedSegment4_1, (Object)FileUtils.readFileToString((File)this.descriptor4_1));
        Set segments2 = localDataSegmentFinder.findSegments(this.dataSourceDir.getAbsolutePath(), true);
        Assert.assertEquals((Object)segments, (Object)segments2);
        Assert.assertEquals((Object)serializedSegment1, (Object)FileUtils.readFileToString((File)this.descriptor1));
        Assert.assertEquals((Object)serializedSegment2, (Object)FileUtils.readFileToString((File)this.descriptor2));
        Assert.assertEquals((Object)serializedSegment3, (Object)FileUtils.readFileToString((File)this.descriptor3));
        Assert.assertEquals((Object)serializedSegment4_0, (Object)FileUtils.readFileToString((File)this.descriptor4_0));
        Assert.assertEquals((Object)serializedSegment4_1, (Object)FileUtils.readFileToString((File)this.descriptor4_1));
    }

    private String getDescriptorPath(DataSegment segment) {
        File indexzip = new File(String.valueOf(segment.getLoadSpec().get("path")));
        return indexzip.getParent() + "/" + DESCRIPTOR_JSON;
    }

    @Test(expected=SegmentLoadingException.class)
    public void testFindSegmentsFail() throws SegmentLoadingException {
        this.indexZip4_1.delete();
        LocalDataSegmentFinder localDataSegmentFinder = new LocalDataSegmentFinder(mapper);
        localDataSegmentFinder.findSegments(this.dataSourceDir.getAbsolutePath(), false);
    }
}

