/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CompressionStrategyTest {
    protected final CompressionStrategy compressionStrategy;
    private static final int DATA_SIZER = 65535;
    private static byte[] originalData;
    private Closer closer;

    @Parameterized.Parameters
    public static Iterable<Object[]> compressionStrategies() {
        return Iterables.transform(Arrays.asList(CompressionStrategy.noNoneValues()), (Function)new Function<CompressionStrategy, Object[]>(){

            public Object[] apply(CompressionStrategy compressionStrategy) {
                return new Object[]{compressionStrategy};
            }
        });
    }

    public CompressionStrategyTest(CompressionStrategy compressionStrategy) {
        this.compressionStrategy = compressionStrategy;
    }

    @BeforeClass
    public static void setupClass() {
        originalData = new byte[65535];
        Random random = new Random(54671457L);
        random.nextBytes(originalData);
    }

    @Before
    public void createCloser() {
        this.closer = Closer.create();
    }

    @After
    public void closeCloser() throws IOException {
        this.closer.close();
    }

    @Test
    public void testBasicOperations() {
        ByteBuffer compressionOut = this.compressionStrategy.getCompressor().allocateOutBuffer(originalData.length, this.closer);
        ByteBuffer compressed = this.compressionStrategy.getCompressor().compress(ByteBuffer.wrap(originalData), compressionOut);
        ByteBuffer output = ByteBuffer.allocate(originalData.length);
        this.compressionStrategy.getDecompressor().decompress(compressed, compressed.remaining(), output);
        byte[] checkArray = new byte[65535];
        output.get(checkArray);
        Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
    }

    @Test
    public void testDirectMemoryOperations() {
        ByteBuffer compressionOut = this.compressionStrategy.getCompressor().allocateOutBuffer(originalData.length, this.closer);
        ByteBuffer compressed = this.compressionStrategy.getCompressor().compress(ByteBuffer.wrap(originalData), compressionOut);
        ByteBuffer output = ByteBuffer.allocateDirect(originalData.length);
        this.compressionStrategy.getDecompressor().decompress(compressed, compressed.remaining(), output);
        byte[] checkArray = new byte[65535];
        output.get(checkArray);
        Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
    }

    @Test(timeout=60000L)
    public void testConcurrency() throws Exception {
        int numThreads = 20;
        ArrayBlockingQueue<Runnable> queue = new ArrayBlockingQueue<Runnable>(20);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(20, 20, 100L, TimeUnit.MILLISECONDS, queue);
        ArrayList<Future<Boolean>> results = new ArrayList<Future<Boolean>>();
        for (int i = 0; i < 20; ++i) {
            results.add(threadPoolExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    ByteBuffer compressionOut = CompressionStrategyTest.this.compressionStrategy.getCompressor().allocateOutBuffer(originalData.length, CompressionStrategyTest.this.closer);
                    ByteBuffer compressed = CompressionStrategyTest.this.compressionStrategy.getCompressor().compress(ByteBuffer.wrap(originalData), compressionOut);
                    ByteBuffer output = ByteBuffer.allocate(originalData.length);
                    CompressionStrategyTest.this.compressionStrategy.getDecompressor().decompress(compressed, compressed.remaining(), output);
                    byte[] checkArray = new byte[65535];
                    output.get(checkArray);
                    Assert.assertArrayEquals((String)"Uncompressed data does not match", (byte[])originalData, (byte[])checkArray);
                    return true;
                }
            }));
        }
        threadPoolExecutor.shutdown();
        for (Future future : results) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
    }
}

