/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.hll.HyperLogLogHash;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularities;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.DoubleSumAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniquesSerde;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.RowboatFilteringIndexAdapter;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class SchemalessIndexTest {
    private static final Logger log = new Logger(SchemalessIndexTest.class);
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private static final String testFile = "druid.sample.json";
    private static final String TIMESTAMP = "timestamp";
    private static final List<String> METRICS = Arrays.asList("index");
    private static final AggregatorFactory[] METRIC_AGGS = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count"), new HyperUniquesAggregatorFactory("quality_uniques", "quality")};
    private static final AggregatorFactory[] METRIC_AGGS_NO_UNIQ = new AggregatorFactory[]{new DoubleSumAggregatorFactory("index", "index"), new CountAggregatorFactory("count")};
    private static final IndexSpec indexSpec = new IndexSpec();
    private static final List<Map<String, Object>> events = Lists.newArrayList();
    private static final Map<Integer, Map<Integer, QueryableIndex>> incrementalIndexes = Maps.newHashMap();
    private static final Map<Integer, Map<Integer, QueryableIndex>> mergedIndexes = Maps.newHashMap();
    private static final List<QueryableIndex> rowPersistedIndexes = Lists.newArrayList();
    private static IncrementalIndex index = null;
    private static QueryableIndex mergedIndex = null;
    private final IndexMerger indexMerger;
    private final IndexIO indexIO;

    public SchemalessIndexTest(SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) {
        this.indexMerger = TestHelper.getTestIndexMergerV9(segmentWriteOutMediumFactory);
        this.indexIO = TestHelper.getTestIndexIO(segmentWriteOutMediumFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IncrementalIndex getIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (index != null) {
                return index;
            }
            index = SchemalessIndexTest.makeIncrementalIndex(testFile, METRIC_AGGS);
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryableIndex getIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            HashMap entry;
            if (events.isEmpty()) {
                SchemalessIndexTest.makeEvents();
            }
            if ((entry = incrementalIndexes.get(index1)) != null) {
                QueryableIndex index = (QueryableIndex)entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = Maps.newHashMap();
                incrementalIndexes.put(index1, entry);
            }
            IncrementalIndex theIndex = null;
            int count = 0;
            for (Map<String, Object> event : events) {
                if (count != index1 && count != index2) {
                    ++count;
                    continue;
                }
                long timestamp = new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis();
                if (theIndex == null) {
                    theIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(timestamp).withQueryGranularity(Granularities.MINUTE).withMetrics(METRIC_AGGS).build()).setMaxRowCount(1000).buildOnheap();
                }
                ArrayList dims = Lists.newArrayList();
                for (Map.Entry<String, Object> val : event.entrySet()) {
                    if (val.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(val.getKey())) continue;
                    dims.add(val.getKey());
                }
                try {
                    theIndex.add((InputRow)new MapBasedInputRow(timestamp, (List)dims, event));
                }
                catch (IndexSizeExceededException e) {
                    Throwables.propagate((Throwable)e);
                }
                ++count;
            }
            QueryableIndex retVal = TestIndex.persistRealtimeAndLoadMMapped(theIndex);
            entry.put(index2, retVal);
            return retVal;
        }
    }

    public QueryableIndex getMergedIncrementalIndex() {
        Logger logger = log;
        synchronized (logger) {
            if (mergedIndex != null) {
                return mergedIndex;
            }
            try {
                IncrementalIndex top = SchemalessIndexTest.makeIncrementalIndex("druid.sample.json.top", METRIC_AGGS);
                IncrementalIndex bottom = SchemalessIndexTest.makeIncrementalIndex("druid.sample.json.bottom", METRIC_AGGS);
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File topFile = new File(tmpFile, "top");
                File bottomFile = new File(tmpFile, "bottom");
                File mergedFile = new File(tmpFile, "merged");
                topFile.mkdirs();
                topFile.deleteOnExit();
                bottomFile.mkdirs();
                bottomFile.deleteOnExit();
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                this.indexMerger.persist(top, topFile, indexSpec, null);
                this.indexMerger.persist(bottom, bottomFile, indexSpec, null);
                mergedIndex = this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(this.indexIO.loadIndex(topFile), this.indexIO.loadIndex(bottomFile)), true, METRIC_AGGS, mergedFile, indexSpec, null));
                return mergedIndex;
            }
            catch (IOException e) {
                mergedIndex = null;
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public QueryableIndex getMergedIncrementalIndex(int index1, int index2) {
        Logger logger = log;
        synchronized (logger) {
            HashMap entry;
            if (rowPersistedIndexes.isEmpty()) {
                this.makeRowPersistedIndexes();
            }
            if ((entry = mergedIndexes.get(index1)) != null) {
                QueryableIndex index = (QueryableIndex)entry.get(index2);
                if (index != null) {
                    return index;
                }
            } else {
                entry = Maps.newHashMap();
                mergedIndexes.put(index1, entry);
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                QueryableIndex index = this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex(Arrays.asList(rowPersistedIndexes.get(index1), rowPersistedIndexes.get(index2)), true, METRIC_AGGS, mergedFile, indexSpec, null));
                entry.put(index2, index);
                return index;
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public QueryableIndex getMergedIncrementalIndex(int[] indexes) {
        Logger logger = log;
        synchronized (logger) {
            if (rowPersistedIndexes.isEmpty()) {
                this.makeRowPersistedIndexes();
            }
            try {
                File tmpFile = File.createTempFile("yay", "who");
                tmpFile.delete();
                File mergedFile = new File(tmpFile, "merged");
                mergedFile.mkdirs();
                mergedFile.deleteOnExit();
                ArrayList indexesToMerge = Lists.newArrayList();
                for (int index : indexes) {
                    indexesToMerge.add(rowPersistedIndexes.get(index));
                }
                return this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex((List)indexesToMerge, true, METRIC_AGGS, mergedFile, indexSpec, null));
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public QueryableIndex getAppendedIncrementalIndex(Iterable<Pair<String, AggregatorFactory[]>> files, List<Interval> intervals) {
        return this.makeAppendedMMappedIndex(files, intervals);
    }

    public QueryableIndex getMergedIncrementalIndexDiffMetrics() {
        return this.getMergedIncrementalIndex(Arrays.asList(new Pair((Object)"druid.sample.json.top", (Object)METRIC_AGGS_NO_UNIQ), new Pair((Object)"druid.sample.json.bottom", (Object)METRIC_AGGS)));
    }

    public QueryableIndex getMergedIncrementalIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        return this.makeMergedMMappedIndex(files);
    }

    private static void makeEvents() {
        URL resource = TestIndex.class.getClassLoader().getResource(testFile);
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        try {
            for (Object obj : (List)jsonMapper.readValue(new File(filename), List.class)) {
                Map event = (Map)jsonMapper.convertValue(obj, Map.class);
                events.add(event);
            }
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRowPersistedIndexes() {
        Logger logger = log;
        synchronized (logger) {
            try {
                if (events.isEmpty()) {
                    SchemalessIndexTest.makeEvents();
                }
                for (Map<String, Object> event : events) {
                    long timestamp = new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis();
                    ArrayList dims = Lists.newArrayList();
                    for (Map.Entry<String, Object> entry : event.entrySet()) {
                        if (entry.getKey().equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                        dims.add(entry.getKey());
                    }
                    IncrementalIndex rowIndex = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(timestamp).withQueryGranularity(Granularities.MINUTE).withMetrics(METRIC_AGGS).build()).setMaxRowCount(1000).buildOnheap();
                    rowIndex.add((InputRow)new MapBasedInputRow(timestamp, (List)dims, event));
                    File tmpFile = File.createTempFile("billy", "yay");
                    tmpFile.delete();
                    tmpFile.mkdirs();
                    tmpFile.deleteOnExit();
                    this.indexMerger.persist(rowIndex, tmpFile, indexSpec, null);
                    rowPersistedIndexes.add(this.indexIO.loadIndex(tmpFile));
                }
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static IncrementalIndex makeIncrementalIndex(String resourceFilename, AggregatorFactory[] aggs) {
        URL resource = TestIndex.class.getClassLoader().getResource(resourceFilename);
        log.info("Realtime loading resource[%s]", new Object[]{resource});
        String filename = resource.getFile();
        log.info("Realtime loading index file[%s]", new Object[]{filename});
        IncrementalIndex retVal = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DateTimes.of((String)"2011-01-12T00:00:00.000Z").getMillis()).withQueryGranularity(Granularities.MINUTE).withMetrics(aggs).build()).setMaxRowCount(1000).buildOnheap();
        try {
            List events = (List)jsonMapper.readValue(new File(filename), List.class);
            for (Object obj : events) {
                Map event = (Map)jsonMapper.convertValue(obj, Map.class);
                ArrayList dims = Lists.newArrayList();
                for (Map.Entry entry : event.entrySet()) {
                    if (((String)entry.getKey()).equalsIgnoreCase(TIMESTAMP) || METRICS.contains(entry.getKey())) continue;
                    dims.add(entry.getKey());
                }
                retVal.add((InputRow)new MapBasedInputRow(new DateTime(event.get(TIMESTAMP), (Chronology)ISOChronology.getInstanceUTC()).getMillis(), (List)dims, event));
            }
        }
        catch (IOException e) {
            index = null;
            throw Throwables.propagate((Throwable)e);
        }
        return retVal;
    }

    private List<File> makeFilesToMap(File tmpFile, Iterable<Pair<String, AggregatorFactory[]>> files) throws IOException {
        ArrayList filesToMap = Lists.newArrayList();
        for (Pair<String, AggregatorFactory[]> file : files) {
            IncrementalIndex index = SchemalessIndexTest.makeIncrementalIndex((String)file.lhs, (AggregatorFactory[])file.rhs);
            File theFile = new File(tmpFile, (String)file.lhs);
            theFile.mkdirs();
            theFile.deleteOnExit();
            filesToMap.add(theFile);
            this.indexMerger.persist(index, theFile, indexSpec, null);
        }
        return filesToMap;
    }

    private QueryableIndex makeAppendedMMappedIndex(Iterable<Pair<String, AggregatorFactory[]>> files, List<Interval> intervals) {
        try {
            File tmpFile = File.createTempFile("yay", "boo");
            tmpFile.delete();
            File mergedFile = new File(tmpFile, "merged");
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            List<File> filesToMap = this.makeFilesToMap(tmpFile, files);
            VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Comparators.naturalNullsFirst());
            NoneShardSpec noneShardSpec = NoneShardSpec.instance();
            for (int i = 0; i < intervals.size(); ++i) {
                timeline.add(intervals.get(i), (Object)i, noneShardSpec.createChunk((Object)filesToMap.get(i)));
            }
            ArrayList adapters = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeline.lookup(Intervals.of((String)"1000-01-01/3000-01-01")), (Function)new Function<TimelineObjectHolder<Integer, File>, Iterable<IndexableAdapter>>(){

                public Iterable<IndexableAdapter> apply(final TimelineObjectHolder<Integer, File> timelineObjectHolder) {
                    return Iterables.transform((Iterable)timelineObjectHolder.getObject(), (Function)new Function<PartitionChunk<File>, IndexableAdapter>(){

                        public IndexableAdapter apply(PartitionChunk<File> chunk) {
                            try {
                                return new RowboatFilteringIndexAdapter((IndexableAdapter)new QueryableIndexIndexableAdapter(SchemalessIndexTest.this.indexIO.loadIndex((File)chunk.getObject())), (Predicate)new Predicate<Rowboat>(){

                                    public boolean apply(Rowboat input) {
                                        return timelineObjectHolder.getInterval().contains(input.getTimestamp());
                                    }
                                });
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            return this.indexIO.loadIndex(this.indexMerger.append((List)adapters, null, mergedFile, indexSpec, null));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private QueryableIndex makeMergedMMappedIndex(Iterable<Pair<String, AggregatorFactory[]>> files) {
        try {
            File tmpFile = File.createTempFile("yay", "who");
            tmpFile.delete();
            File mergedFile = new File(tmpFile, "merged");
            mergedFile.mkdirs();
            mergedFile.deleteOnExit();
            List<File> filesToMap = this.makeFilesToMap(tmpFile, files);
            return this.indexIO.loadIndex(this.indexMerger.mergeQueryableIndex((List)Lists.newArrayList((Iterable)Iterables.transform(filesToMap, (Function)new Function<File, QueryableIndex>(){

                public QueryableIndex apply(@Nullable File input) {
                    try {
                        return SchemalessIndexTest.this.indexIO.loadIndex(input);
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            })), true, METRIC_AGGS, mergedFile, indexSpec, null));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        if (ComplexMetrics.getSerdeForType((String)"hyperUnique") == null) {
            ComplexMetrics.registerSerde((String)"hyperUnique", (ComplexMetricSerde)new HyperUniquesSerde(HyperLogLogHash.getDefault()));
        }
    }
}

