/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.segment.AbstractSegment;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.ReferenceCountingSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.joda.time.Days;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReferenceCountingSegmentTest {
    private ReferenceCountingSegment segment;
    private ExecutorService exec;

    @Before
    public void setUp() throws Exception {
        this.segment = new ReferenceCountingSegment((Segment)new AbstractSegment(){

            public String getIdentifier() {
                return "test_segment";
            }

            public Interval getDataInterval() {
                return new Interval((ReadableInstant)DateTimes.nowUtc().minus((ReadablePeriod)Days.days((int)1)), (ReadableInstant)DateTimes.nowUtc());
            }

            public QueryableIndex asQueryableIndex() {
                return null;
            }

            public StorageAdapter asStorageAdapter() {
                return null;
            }

            public void close() throws IOException {
            }
        });
        this.exec = Executors.newSingleThreadExecutor();
    }

    @Test
    public void testMultipleClose() throws Exception {
        Assert.assertFalse((boolean)this.segment.isClosed());
        Assert.assertTrue((boolean)this.segment.increment());
        Assert.assertEquals((long)1L, (long)this.segment.getNumReferences());
        Closeable closeable = this.segment.decrementOnceCloseable();
        closeable.close();
        closeable.close();
        this.exec.submit(() -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertFalse((boolean)this.segment.isClosed());
        this.segment.close();
        this.segment.close();
        this.exec.submit(() -> {
            try {
                this.segment.close();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }).get();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        Assert.assertTrue((boolean)this.segment.isClosed());
        this.segment.increment();
        this.segment.increment();
        this.segment.increment();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
        this.segment.close();
        Assert.assertEquals((long)0L, (long)this.segment.getNumReferences());
    }
}

