/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.junit.Assert;
import org.junit.Test;

public class IndexSpecTest {
    @Test
    public void testSerde() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\", \"longEncoding\" : \"auto\" }";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"bitmap\" : { \"type\" : \"roaring\" }, \"dimensionCompression\" : \"lz4\", \"metricCompression\" : \"lzf\", \"longEncoding\" : \"auto\" }", IndexSpec.class);
        Assert.assertEquals((Object)new RoaringBitmapSerdeFactory(null), (Object)spec.getBitmapSerdeFactory());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)CompressionStrategy.LZF, (Object)spec.getMetricCompression());
        Assert.assertEquals((Object)CompressionFactory.LongEncodingStrategy.AUTO, (Object)spec.getLongEncoding());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testSerdeUncompressed() throws Exception {
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String json = "{ \"dimensionCompression\" : \"uncompressed\" }";
        IndexSpec spec = (IndexSpec)objectMapper.readValue("{ \"dimensionCompression\" : \"uncompressed\" }", IndexSpec.class);
        Assert.assertEquals((Object)CompressionStrategy.UNCOMPRESSED, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)spec, (Object)objectMapper.readValue(objectMapper.writeValueAsBytes((Object)spec), IndexSpec.class));
    }

    @Test
    public void testDefaults() throws Exception {
        IndexSpec spec = new IndexSpec();
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getDimensionCompression());
        Assert.assertEquals((Object)CompressionStrategy.LZ4, (Object)spec.getMetricCompression());
        Assert.assertEquals((Object)CompressionFactory.LongEncodingStrategy.LONGS, (Object)spec.getLongEncoding());
    }
}

