/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.ws.rs.POST;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.query.extraction.MapLookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectHandler;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectionResource;
import org.apache.hive.druid.io.druid.query.lookup.LookupReferencesManager;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LookupIntrospectionResourceTest {
    LookupReferencesManager lookupReferencesManager = (LookupReferencesManager)EasyMock.createMock(LookupReferencesManager.class);
    LookupExtractorFactory lookupExtractorFactory = (LookupExtractorFactory)EasyMock.createMock(LookupExtractorFactory.class);
    LookupIntrospectHandler lookupIntrospectHandler = (LookupIntrospectHandler)EasyMock.createMock(LookupIntrospectHandler.class);
    LookupIntrospectionResource lookupIntrospectionResource = new LookupIntrospectionResource(this.lookupReferencesManager);

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.lookupReferencesManager.get("lookupId")).andReturn((Object)new LookupExtractorFactoryContainer("v0", this.lookupExtractorFactory)).anyTimes();
        EasyMock.expect((Object)this.lookupReferencesManager.get(EasyMock.anyString())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lookupReferencesManager});
    }

    @Test
    public void testNotImplementedIntrospectLookup() {
        EasyMock.expect((Object)this.lookupExtractorFactory.getIntrospectHandler()).andReturn(null);
        EasyMock.expect((Object)this.lookupExtractorFactory.get()).andReturn((Object)new MapLookupExtractor((Map)ImmutableMap.of(), false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lookupExtractorFactory});
        Assert.assertEquals((long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)((Response)this.lookupIntrospectionResource.introspectLookup("lookupId")).getStatus());
    }

    @Test
    public void testNotExistingLookup() {
        Assert.assertEquals((long)Response.status((Response.Status)Response.Status.NOT_FOUND).build().getStatus(), (long)((Response)this.lookupIntrospectionResource.introspectLookup("not there")).getStatus());
    }

    @Test
    public void testExistingLookup() {
        EasyMock.expect((Object)this.lookupExtractorFactory.getIntrospectHandler()).andReturn((Object)this.lookupIntrospectHandler);
        EasyMock.expect((Object)this.lookupExtractorFactory.get()).andReturn((Object)new MapLookupExtractor((Map)ImmutableMap.of(), false)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lookupExtractorFactory});
        Assert.assertEquals((Object)this.lookupIntrospectHandler, (Object)this.lookupIntrospectionResource.introspectLookup("lookupId"));
    }

    @Test
    @Ignore
    public void testIntrospection() {
        LookupIntrospectHandler lookupIntrospectHandler = new LookupIntrospectHandler(){

            @POST
            public Response postMock(InputStream inputStream) {
                return Response.ok().build();
            }
        };
        LookupExtractorFactory lookupExtractorFactory1 = new LookupExtractorFactory(){
            final LookupExtractor mapLookup = new MapLookupExtractor((Map)ImmutableMap.of((Object)"key", (Object)"value"), true);

            public boolean start() {
                return true;
            }

            public boolean close() {
                return true;
            }

            public boolean replaces(@Nullable LookupExtractorFactory other) {
                return true;
            }

            @Nullable
            public LookupIntrospectHandler getIntrospectHandler() {
                return null;
            }

            public LookupExtractor get() {
                return this.mapLookup;
            }
        };
        LookupIntrospectionResource lookupIntrospectionResource = new LookupIntrospectionResource(this.lookupReferencesManager);
        EasyMock.expect((Object)this.lookupReferencesManager.get("lookupId1")).andReturn((Object)new LookupExtractorFactoryContainer("v0", lookupExtractorFactory1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.lookupReferencesManager});
    }
}

