/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractor;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactory;
import org.apache.hive.druid.io.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.hive.druid.io.druid.query.lookup.LookupIntrospectHandler;
import org.junit.Assert;
import org.junit.Test;

public class LookupExtractorFactoryContainerTest {
    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\n\"version\": \"v1\",\n\"lookupExtractorFactory\": {\n   \"type\": \"test\"\n }\n}\n";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.registerSubtypes(new Class[]{TestLookupExtractorFactory.class});
        LookupExtractorFactoryContainer actual = (LookupExtractorFactoryContainer)mapper.readValue(mapper.writeValueAsString(mapper.readValue(jsonStr, LookupExtractorFactoryContainer.class)), LookupExtractorFactoryContainer.class);
        Assert.assertEquals((Object)new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new TestLookupExtractorFactory()), (Object)actual);
    }

    @Test
    public void testReplaces() throws Exception {
        LookupExtractorFactoryContainer l0 = new LookupExtractorFactoryContainer(null, (LookupExtractorFactory)new TestLookupExtractorFactory());
        LookupExtractorFactoryContainer l1 = new LookupExtractorFactoryContainer(null, (LookupExtractorFactory)new TestLookupExtractorFactory());
        LookupExtractorFactoryContainer l2 = new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new TestLookupExtractorFactory());
        LookupExtractorFactoryContainer l3 = new LookupExtractorFactoryContainer("v1", (LookupExtractorFactory)new TestLookupExtractorFactory());
        Assert.assertTrue((boolean)l0.replaces(l1));
        Assert.assertFalse((boolean)l1.replaces(l2));
        Assert.assertTrue((boolean)l2.replaces(l1));
        Assert.assertFalse((boolean)l2.replaces(l3));
        Assert.assertTrue((boolean)l3.replaces(l2));
    }

    @JsonTypeName(value="test")
    static class TestLookupExtractorFactory
    implements LookupExtractorFactory {
        TestLookupExtractorFactory() {
        }

        public boolean start() {
            return false;
        }

        public boolean close() {
            return false;
        }

        public boolean replaces(@Nullable LookupExtractorFactory other) {
            return true;
        }

        @Nullable
        public LookupIntrospectHandler getIntrospectHandler() {
            return null;
        }

        public LookupExtractor get() {
            return null;
        }

        public boolean equals(Object other) {
            return other instanceof TestLookupExtractorFactory;
        }
    }
}

