/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.druid.io.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.junit.Assert;
import org.junit.Test;

public class ExecsTest {
    private static final Logger log = new Logger(ExecsTest.class);

    @Test
    public void testBlockingExecutorServiceZeroCapacity() throws Exception {
        ExecsTest.runTest(0);
    }

    @Test
    public void testBlockingExecutorServiceOneCapacity() throws Exception {
        ExecsTest.runTest(1);
    }

    @Test
    public void testBlockingExecutorServiceThreeCapacity() throws Exception {
        ExecsTest.runTest(3);
    }

    private static void runTest(int capacity) throws Exception {
        final int nTasks = (capacity + 1) * 3;
        final ExecutorService blockingExecutor = Execs.newBlockingSingleThreaded((String)"ExecsTest-Blocking-%d", (int)capacity);
        final CountDownLatch queueShouldBeFullSignal = new CountDownLatch(capacity + 1);
        final CountDownLatch taskCompletedSignal = new CountDownLatch(nTasks);
        final CountDownLatch taskStartSignal = new CountDownLatch(1);
        final AtomicInteger producedCount = new AtomicInteger();
        final AtomicInteger consumedCount = new AtomicInteger();
        ExecutorService producer = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("ExecsTest-Producer-%d").build());
        producer.submit(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < nTasks) {
                    final int taskID = i++;
                    log.info("Produced task %d", new Object[]{taskID});
                    blockingExecutor.submit(new Runnable(){

                        @Override
                        public void run() {
                            log.info("Starting task: %s", new Object[]{taskID});
                            try {
                                taskStartSignal.await();
                                consumedCount.incrementAndGet();
                                taskCompletedSignal.countDown();
                            }
                            catch (Exception e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                            log.info("Completed task: %s", new Object[]{taskID});
                        }
                    });
                    producedCount.incrementAndGet();
                    queueShouldBeFullSignal.countDown();
                }
            }
        });
        queueShouldBeFullSignal.await();
        Thread.sleep(500L);
        Assert.assertEquals((long)(capacity + 1), (long)producedCount.get());
        taskStartSignal.countDown();
        taskCompletedSignal.await();
        Assert.assertEquals((long)nTasks, (long)consumedCount.get());
        blockingExecutor.shutdown();
        producer.shutdown();
    }
}

