/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.bitmap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.collections.IntSetTestUtility;
import org.apache.hive.druid.io.druid.collections.bitmap.ImmutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedBitSetBitmap;
import org.apache.hive.druid.io.druid.collections.bitmap.WrappedImmutableBitSetBitmap;
import org.apache.hive.druid.org.roaringbitmap.IntIterator;
import org.junit.Assert;
import org.junit.Test;

public class WrappedBitSetBitmapBitSetTest {
    private static WrappedBitSetBitmap defaultBitSet() {
        return new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(IntSetTestUtility.getSetBits()));
    }

    @Test
    public void testIterator() {
        WrappedBitSetBitmap bitSet = new WrappedBitSetBitmap();
        for (int i : IntSetTestUtility.getSetBits()) {
            bitSet.add(i);
        }
        IntIterator intIt = bitSet.iterator();
        for (int i : IntSetTestUtility.getSetBits()) {
            Assert.assertTrue((boolean)intIt.hasNext());
            Assert.assertEquals((long)i, (long)intIt.next());
        }
    }

    @Test
    public void testSize() {
        BitSet bitSet = IntSetTestUtility.createSimpleBitSet(IntSetTestUtility.getSetBits());
        WrappedBitSetBitmap wrappedBitSetBitmapBitSet = new WrappedBitSetBitmap(bitSet);
        Assert.assertEquals((long)bitSet.cardinality(), (long)wrappedBitSetBitmapBitSet.size());
    }

    @Test
    public void testOffHeap() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(800).order(ByteOrder.LITTLE_ENDIAN);
        BitSet testSet = BitSet.valueOf(buffer);
        testSet.set(1);
        WrappedImmutableBitSetBitmap bitMap = new WrappedImmutableBitSetBitmap(testSet);
        Assert.assertTrue((boolean)bitMap.get(1));
        testSet.set(2);
        Assert.assertTrue((boolean)bitMap.get(2));
    }

    @Test
    public void testSimpleBitSet() {
        WrappedBitSetBitmap bitSet = new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(IntSetTestUtility.getSetBits()));
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets(IntSetTestUtility.getSetBits(), (ImmutableBitmap)bitSet));
    }

    @Test
    public void testUnion() {
        WrappedBitSetBitmap bitSet = new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(IntSetTestUtility.getSetBits()));
        HashSet extraBits = Sets.newHashSet((Object[])new Integer[]{6, 9});
        WrappedBitSetBitmap bitExtraSet = new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(extraBits));
        Sets.SetView union = Sets.union((Set)extraBits, IntSetTestUtility.getSetBits());
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets((Set<Integer>)union, (ImmutableBitmap)((WrappedBitSetBitmap)bitSet.union((ImmutableBitmap)bitExtraSet))));
    }

    @Test
    public void testIntersection() {
        WrappedBitSetBitmap bitSet = new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(IntSetTestUtility.getSetBits()));
        HashSet extraBits = Sets.newHashSet((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        WrappedBitSetBitmap bitExtraSet = new WrappedBitSetBitmap(IntSetTestUtility.createSimpleBitSet(extraBits));
        Sets.SetView intersection = Sets.intersection((Set)extraBits, IntSetTestUtility.getSetBits());
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets((Set<Integer>)intersection, (ImmutableBitmap)((WrappedBitSetBitmap)bitSet.intersection((ImmutableBitmap)bitExtraSet))));
    }

    @Test
    public void testAnd() {
        WrappedBitSetBitmap bitSet = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        WrappedBitSetBitmap bitSet2 = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        Set<Integer> defaultBitSet = IntSetTestUtility.getSetBits();
        bitSet.remove(1);
        bitSet2.remove(2);
        bitSet.and((MutableBitmap)bitSet2);
        defaultBitSet.remove(1);
        defaultBitSet.remove(2);
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets(defaultBitSet, (ImmutableBitmap)bitSet));
    }

    @Test
    public void testOr() {
        WrappedBitSetBitmap bitSet = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        WrappedBitSetBitmap bitSet2 = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        Set<Integer> defaultBitSet = IntSetTestUtility.getSetBits();
        bitSet.remove(1);
        bitSet2.remove(2);
        bitSet.or((MutableBitmap)bitSet2);
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets(defaultBitSet, (ImmutableBitmap)bitSet));
    }

    @Test
    public void testAndNot() {
        WrappedBitSetBitmap bitSet = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        WrappedBitSetBitmap bitSet2 = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        HashSet defaultBitSet = Sets.newHashSet();
        bitSet.remove(1);
        bitSet2.remove(2);
        bitSet.andNot((MutableBitmap)bitSet2);
        defaultBitSet.add(2);
        Assert.assertTrue((boolean)IntSetTestUtility.equalSets(defaultBitSet, (ImmutableBitmap)bitSet));
    }

    @Test
    public void testSerialize() {
        WrappedBitSetBitmap bitSet = WrappedBitSetBitmapBitSetTest.defaultBitSet();
        byte[] buffer = new byte[bitSet.getSizeInBytes()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        bitSet.serialize(byteBuffer);
    }
}

