/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.io.ByteStreams;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.metamx.common.CompressionUtils;
import org.apache.hive.druid.com.metamx.common.IAE;
import org.apache.hive.druid.com.metamx.common.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CompressionUtilsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final String content;
    private static final byte[] expected;
    private static final byte[] gzBytes;
    private File testDir;
    private File testFile;

    @Before
    public void setUp() throws IOException {
        this.testDir = this.temporaryFolder.newFolder("testDir");
        this.testFile = new File(this.testDir, "test.dat");
        try (FileOutputStream outputStream = new FileOutputStream(this.testFile);){
            ((OutputStream)outputStream).write(StringUtils.toUtf8((String)content));
        }
        Assert.assertTrue((boolean)this.testFile.getParentFile().equals(this.testDir));
    }

    public static void assertGoodDataStream(InputStream stream) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(expected.length);){
            ByteStreams.copy((InputStream)stream, (OutputStream)bos);
            Assert.assertArrayEquals((byte[])expected, (byte[])bos.toByteArray());
        }
    }

    @Test
    public void testGoodGzNameResolution() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"foo.gz"));
    }

    @Test(expected=IAE.class)
    public void testBadGzName() {
        CompressionUtils.getGzBaseName((String)"foo");
    }

    @Test(expected=IAE.class)
    public void testBadShortGzName() {
        CompressionUtils.getGzBaseName((String)".gz");
    }

    @Test
    public void testGoodZipCompressUncompress() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipCompressUncompress");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        zipFile.deleteOnExit();
        CompressionUtils.zip((File)this.testDir, (File)zipFile);
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        CompressionUtils.unzip((File)zipFile, (File)newDir);
        Path newPath = Paths.get(newDir.getAbsolutePath(), this.testFile.getName());
        Assert.assertTrue((boolean)newPath.toFile().exists());
        try (FileInputStream inputStream = new FileInputStream(newPath.toFile());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
    }

    @Test
    public void testGoodZipCompressUncompressWithLocalCopy() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipCompressUncompressWithLocalCopy");
        final File zipFile = new File(tmpDir, "testGoodZipCompressUncompressWithLocalCopy.zip");
        CompressionUtils.zip((File)this.testDir, (File)zipFile);
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        CompressionUtils.unzip((ByteSource)new ByteSource(){

            public InputStream openStream() throws IOException {
                return new FileInputStream(zipFile);
            }
        }, (File)newDir, (boolean)true);
        Path newPath = Paths.get(newDir.getAbsolutePath(), this.testFile.getName());
        Assert.assertTrue((boolean)newPath.toFile().exists());
        try (FileInputStream inputStream = new FileInputStream(newPath.toFile());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
    }

    @Test
    public void testGoodGZCompressUncompressToFile() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGZCompressUncompressToFile");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((File)this.testFile, (File)gzFile);
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = new GZIPInputStream(new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        this.testFile.delete();
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((File)gzFile, (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testGoodZipStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodZipStream");
        File zipFile = new File(tmpDir, "compressionUtilTest.zip");
        CompressionUtils.zip((File)this.testDir, (OutputStream)new FileOutputStream(zipFile));
        File newDir = new File(tmpDir, "newDir");
        newDir.mkdir();
        CompressionUtils.unzip((InputStream)new FileInputStream(zipFile), (File)newDir);
        Path newPath = Paths.get(newDir.getAbsolutePath(), this.testFile.getName());
        Assert.assertTrue((boolean)newPath.toFile().exists());
        try (FileInputStream inputStream = new FileInputStream(newPath.toFile());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
    }

    @Test
    public void testGoodGzipByteSource() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)Files.asByteSource((File)this.testFile), (ByteSink)Files.asByteSink((File)gzFile, (FileWriteMode[])new FileWriteMode[0]), (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = CompressionUtils.gzipInputStream((InputStream)new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOException(String.format("Unable to delete file [%s]", this.testFile.getAbsolutePath()));
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((ByteSource)Files.asByteSource((File)gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testGoodGZStream() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGZStream");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((InputStream)new FileInputStream(this.testFile), (OutputStream)new FileOutputStream(gzFile));
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = new GZIPInputStream(new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOException(String.format("Unable to delete file [%s]", this.testFile.getAbsolutePath()));
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((InputStream)new FileInputStream(gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var4_4 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var4_4 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testZeroRemainingInputStream() throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(this.testFile);){
            Assert.assertEquals((long)gzBytes.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(gzBytes)), (OutputStream)outputStream));
            Assert.assertEquals((long)gzBytes.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(gzBytes)), (OutputStream)outputStream));
            Assert.assertEquals((long)gzBytes.length, (long)ByteStreams.copy((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(gzBytes)), (OutputStream)outputStream));
        }
        Assert.assertEquals((long)(gzBytes.length * 3), (long)this.testFile.length());
        var2_2 = null;
        try (ZeroRemainingInputStream inputStream = new ZeroRemainingInputStream(new FileInputStream(this.testFile));){
            for (int i = 0; i < 3; ++i) {
                byte[] bytes = new byte[gzBytes.length];
                Assert.assertEquals((long)bytes.length, (long)((InputStream)inputStream).read(bytes));
                Assert.assertArrayEquals((String)String.format("Failed on range %d", i), (byte[])gzBytes, (byte[])bytes);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test(expected=AssertionError.class)
    public void testGunzipBug() throws IOException {
        ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(gzBytes.length * 3);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        try (GZIPInputStream inputStream = new GZIPInputStream(new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray())));
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(expected.length * 3);){
            Assert.assertEquals((String)"Read terminated too soon (bug 7036144)", (long)(expected.length * 3), (long)ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream));
            byte[] found = outputStream.toByteArray();
            Assert.assertEquals((long)(expected.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 0, expected.length * 1));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 1, expected.length * 2));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 2, expected.length * 3));
        }
    }

    @Test
    public void testGunzipBugworkarround() throws IOException {
        this.testFile.delete();
        Assert.assertFalse((boolean)this.testFile.exists());
        final ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(gzBytes.length * 3);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        ByteSource inputStreamFactory = new ByteSource(){

            public InputStream openStream() throws IOException {
                return new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray()));
            }
        };
        Assert.assertEquals((long)(expected.length * 3), (long)CompressionUtils.gunzip((ByteSource)inputStreamFactory, (File)this.testFile).size());
        try (FileInputStream inputStream = new FileInputStream(this.testFile);
             ByteArrayOutputStream outputStream = new ByteArrayOutputStream(expected.length * 3);){
            Assert.assertEquals((String)"Read terminated too soon (7036144)", (long)(expected.length * 3), (long)ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream));
            byte[] found = outputStream.toByteArray();
            Assert.assertEquals((long)(expected.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 0, expected.length * 1));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 1, expected.length * 2));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 2, expected.length * 3));
        }
    }

    @Test
    public void testGunzipBugStreamWorkarround() throws IOException {
        ByteArrayOutputStream tripleGzByteStream = new ByteArrayOutputStream(gzBytes.length * 3);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        tripleGzByteStream.write(gzBytes);
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(expected.length * 3);){
            Assert.assertEquals((long)(expected.length * 3), (long)CompressionUtils.gunzip((InputStream)new ZeroRemainingInputStream(new ByteArrayInputStream(tripleGzByteStream.toByteArray())), (OutputStream)bos));
            byte[] found = bos.toByteArray();
            Assert.assertEquals((long)(expected.length * 3), (long)found.length);
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 0, expected.length * 1));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 1, expected.length * 2));
            Assert.assertArrayEquals((byte[])expected, (byte[])Arrays.copyOfRange(found, expected.length * 2, expected.length * 3));
        }
    }

    @Test
    public void testZipName() throws IOException {
        File tmpDir = this.temporaryFolder.newFolder("testZipName");
        File zipDir = new File(tmpDir, "zipDir");
        zipDir.mkdir();
        File file = new File(tmpDir, "zipDir.zip");
        Path unzipPath = Paths.get(zipDir.getPath(), "test.dat");
        file.delete();
        Assert.assertFalse((boolean)file.exists());
        Assert.assertFalse((boolean)unzipPath.toFile().exists());
        CompressionUtils.zip((File)this.testDir, (File)file);
        Assert.assertTrue((boolean)file.exists());
        CompressionUtils.unzip((File)file, (File)zipDir);
        Assert.assertTrue((boolean)unzipPath.toFile().exists());
        try (FileInputStream inputStream = new FileInputStream(unzipPath.toFile());){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
    }

    @Test
    public void testNewFileDoesntCreateFile() {
        File tmpFile = new File(this.testDir, "fofooofodshfudhfwdjkfwf.dat");
        Assert.assertFalse((boolean)tmpFile.exists());
    }

    @Test
    public void testGoodGzipName() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"foo.gz"));
    }

    @Test
    public void testGoodGzipNameWithPath() {
        Assert.assertEquals((Object)"foo", (Object)CompressionUtils.getGzBaseName((String)"/tar/ball/baz/bock/foo.gz"));
    }

    @Test(expected=IAE.class)
    public void testBadShortName() {
        CompressionUtils.getGzBaseName((String)".gz");
    }

    @Test(expected=IAE.class)
    public void testBadName() {
        CompressionUtils.getGzBaseName((String)"BANANAS");
    }

    @Test(expected=IAE.class)
    public void testBadNameWithPath() {
        CompressionUtils.getGzBaseName((String)"/foo/big/.gz");
    }

    @Test
    public void testGoodGzipWithException() throws Exception {
        final AtomicLong flushes = new AtomicLong(0L);
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        final File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)Files.asByteSource((File)this.testFile), (ByteSink)new ByteSink(){

            public OutputStream openStream() throws IOException {
                return new FilterOutputStream(new FileOutputStream(gzFile)){

                    @Override
                    public void flush() throws IOException {
                        if (flushes.getAndIncrement() <= 0L) {
                            throw new IOException("Haven't flushed enough");
                        }
                        super.flush();
                    }
                };
            }
        }, (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (InputStream inputStream = CompressionUtils.gzipInputStream((InputStream)new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (!this.testFile.delete()) {
            throw new IOException(String.format("Unable to delete file [%s]", this.testFile.getAbsolutePath()));
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        CompressionUtils.gunzip((ByteSource)Files.asByteSource((File)gzFile), (File)this.testFile);
        Assert.assertTrue((boolean)this.testFile.exists());
        inputStream = new FileInputStream(this.testFile);
        var5_5 = null;
        try {
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (inputStream != null) {
                if (var5_5 != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
        Assert.assertEquals((long)4L, (long)flushes.get());
    }

    @Test(expected=IOException.class)
    public void testStreamErrorGzip() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        final AtomicLong flushes = new AtomicLong(0L);
        CompressionUtils.gzip((InputStream)new FileInputStream(this.testFile), (OutputStream)new FileOutputStream(gzFile){

            @Override
            public void flush() throws IOException {
                if (flushes.getAndIncrement() <= 0L) {
                    throw new IOException("Test exception");
                }
                super.flush();
            }
        });
    }

    @Test(expected=IOException.class)
    public void testStreamErrorGunzip() throws Exception {
        File tmpDir = this.temporaryFolder.newFolder("testGoodGzipByteSource");
        File gzFile = new File(tmpDir, this.testFile.getName() + ".gz");
        Assert.assertFalse((boolean)gzFile.exists());
        CompressionUtils.gzip((ByteSource)Files.asByteSource((File)this.testFile), (ByteSink)Files.asByteSink((File)gzFile, (FileWriteMode[])new FileWriteMode[0]), (Predicate)Predicates.alwaysTrue());
        Assert.assertTrue((boolean)gzFile.exists());
        try (GZIPInputStream inputStream = CompressionUtils.gzipInputStream((InputStream)new FileInputStream(gzFile));){
            CompressionUtilsTest.assertGoodDataStream(inputStream);
        }
        if (this.testFile.exists() && !this.testFile.delete()) {
            throw new RuntimeException(String.format("Unable to delete file [%s]", this.testFile.getAbsolutePath()));
        }
        Assert.assertFalse((boolean)this.testFile.exists());
        final AtomicLong flushes = new AtomicLong(0L);
        CompressionUtils.gunzip((InputStream)new FileInputStream(gzFile), (OutputStream)new FilterOutputStream(new FileOutputStream(this.testFile){

            @Override
            public void flush() throws IOException {
                if (flushes.getAndIncrement() <= 0L) {
                    throw new IOException("Test exception");
                }
                super.flush();
            }
        }));
    }

    static {
        StringBuilder builder = new StringBuilder();
        try (InputStream stream = CompressionUtilsTest.class.getClassLoader().getResourceAsStream("loremipsum.txt");){
            Scanner it = new Scanner(stream).useDelimiter(Pattern.quote("|"));
            while (it.hasNext()) {
                builder.append((String)it.next());
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        content = builder.toString();
        expected = StringUtils.toUtf8((String)content);
        ByteArrayOutputStream gzByteStream = new ByteArrayOutputStream(expected.length);
        try (GZIPOutputStream outputStream = new GZIPOutputStream(gzByteStream);
             ByteArrayInputStream in = new ByteArrayInputStream(expected);){
            ByteStreams.copy((InputStream)in, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        gzBytes = gzByteStream.toByteArray();
    }

    private static class ZeroRemainingInputStream
    extends FilterInputStream {
        private final AtomicInteger pos = new AtomicInteger(0);

        protected ZeroRemainingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public synchronized void reset() throws IOException {
            super.reset();
            this.pos.set(0);
        }

        @Override
        public int read(byte[] b) throws IOException {
            int len = Math.min(b.length, gzBytes.length - this.pos.get() % gzBytes.length);
            this.pos.addAndGet(len);
            return this.read(b, 0, len);
        }

        @Override
        public int read() throws IOException {
            this.pos.incrementAndGet();
            return super.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int l = Math.min(len, gzBytes.length - this.pos.get() % gzBytes.length);
            this.pos.addAndGet(l);
            return super.read(b, off, l);
        }

        @Override
        public int available() throws IOException {
            return 0;
        }
    }
}

