/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.MemoryLimitException;
import org.apache.commons.compress.PasswordRequiredException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.sevenz.SevenZFileOptions;
import org.apache.commons.compress.archivers.sevenz.SevenZMethod;
import org.apache.commons.compress.archivers.sevenz.SevenZMethodConfiguration;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.compress.utils.MultiReadOnlySeekableByteChannel;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SevenZFileTest
extends AbstractTestCase {
    private static final String TEST2_CONTENT = "<?xml version = '1.0'?>\r\n<!DOCTYPE connections>\r\n<meinxml>\r\n\t<leer />\r\n</meinxml>\n";
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Test
    public void testRandomlySkippingEntries() throws Exception {
        HashMap<String, byte[]> entriesByName = new HashMap<String, byte[]>();
        try (SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("COMPRESS-320/Copy.7z"));){
            SevenZArchiveEntry entry;
            while ((entry = archive.getNextEntry()) != null) {
                if (!entry.hasStream()) continue;
                entriesByName.put(entry.getName(), this.readFully(archive));
            }
        }
        String[] variants = new String[]{"BZip2-solid.7z", "BZip2.7z", "Copy-solid.7z", "Copy.7z", "Deflate-solid.7z", "Deflate.7z", "LZMA-solid.7z", "LZMA.7z", "LZMA2-solid.7z", "LZMA2.7z"};
        Random rnd = new Random(-559038737L);
        for (String fileName : variants) {
            try (SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("COMPRESS-320/" + fileName));){
                SevenZArchiveEntry entry;
                while ((entry = archive.getNextEntry()) != null) {
                    if (rnd.nextBoolean() || !entry.hasStream()) continue;
                    Assert.assertTrue((boolean)entriesByName.containsKey(entry.getName()));
                    byte[] content = this.readFully(archive);
                    Assert.assertArrayEquals((String)("Content mismatch on: " + fileName + "!" + entry.getName()), (byte[])content, (byte[])((byte[])entriesByName.get(entry.getName())));
                }
            }
        }
    }

    private byte[] readFully(SevenZFile archive) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = 0;
        while ((len = archive.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        return baos.toByteArray();
    }

    @Test
    public void testAllEmptyFilesArchive() throws Exception {
        try (SevenZFile archive = new SevenZFile(SevenZFileTest.getFile("7z-empty-mhc-off.7z"));){
            Assert.assertNotNull((Object)archive.getNextEntry());
        }
    }

    @Test
    public void testHelloWorldHeaderCompressionOffCopy() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-copy.7z");
    }

    @Test
    public void testHelloWorldHeaderCompressionOffLZMA2() throws Exception {
        this.checkHelloWorld("7z-hello-mhc-off-lzma2.7z");
    }

    @Test
    public void test7zUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.7z"), SevenZMethod.LZMA);
    }

    @Test
    public void test7zDeflateUnarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.deflate.7z"), SevenZMethod.DEFLATE);
    }

    @Test
    public void test7zDeflate64Unarchive() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.deflate64.7z"), SevenZMethod.DEFLATE64);
    }

    @Test
    public void test7zDecryptUnarchive() throws Exception {
        if (SevenZFileTest.isStrongCryptoAvailable()) {
            this.test7zUnarchive(SevenZFileTest.getFile("bla.encrypted.7z"), SevenZMethod.LZMA, "foo".getBytes(StandardCharsets.UTF_16LE));
        }
    }

    @Test
    public void test7zDecryptUnarchiveUsingCharArrayPassword() throws Exception {
        if (SevenZFileTest.isStrongCryptoAvailable()) {
            this.test7zUnarchive(SevenZFileTest.getFile("bla.encrypted.7z"), SevenZMethod.LZMA, "foo".toCharArray());
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m) throws Exception {
        this.test7zUnarchive(f, m, false);
    }

    private void test7zUnarchive(File f, SevenZMethod m, boolean tryToRecoverBrokenArchives) throws Exception {
        this.test7zUnarchive(f, m, null, tryToRecoverBrokenArchives);
    }

    @Test
    public void testEncryptedArchiveRequiresPassword() throws Exception {
        try {
            new SevenZFile(SevenZFileTest.getFile("bla.encrypted.7z")).close();
            Assert.fail((String)"shouldn't decrypt without a password");
        }
        catch (PasswordRequiredException ex) {
            String msg = ex.getMessage();
            Assert.assertTrue((String)"Should start with whining about being unable to decrypt", (boolean)msg.startsWith("Cannot read encrypted content from "));
            Assert.assertTrue((String)"Should finish the sentence properly", (boolean)msg.endsWith(" without a password."));
            Assert.assertTrue((String)"Should contain archive's name", (boolean)msg.contains("bla.encrypted.7z"));
        }
    }

    @Test
    public void testCompressedHeaderWithNonDefaultDictionarySize() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            int count = 0;
            while (sevenZFile.getNextEntry() != null) {
                ++count;
            }
            Assert.assertEquals((long)446L, (long)count);
        }
    }

    @Test
    public void testSignatureCheck() {
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)SevenZFile.sevenZSignature.length));
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length + 1)));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])SevenZFile.sevenZSignature, (int)(SevenZFile.sevenZSignature.length - 1)));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (int)6));
        Assert.assertTrue((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 28}, (int)6));
        Assert.assertFalse((boolean)SevenZFile.matches((byte[])new byte[]{55, 122, -68, -81, 39, 29}, (int)6));
    }

    @Test
    public void testReadingBackLZMA2DictSize() throws Exception {
        SevenZArchiveEntry entry;
        File output = new File(this.dir, "lzma2-dictsize.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.LZMA2, (Object)0x100000)));
            entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        var3_3 = null;
        try (SevenZFile archive = new SevenZFile(output);){
            entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)m.getMethod());
            Assert.assertEquals((Object)0x100000, (Object)m.getOptions());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReadingBackDeltaDistance() throws Exception {
        SevenZArchiveEntry entry;
        File output = new File(this.dir, "delta-distance.7z");
        try (SevenZOutputFile outArchive = new SevenZOutputFile(output);){
            outArchive.setContentMethods(Arrays.asList(new SevenZMethodConfiguration(SevenZMethod.DELTA_FILTER, (Object)32), new SevenZMethodConfiguration(SevenZMethod.LZMA2)));
            entry = new SevenZArchiveEntry();
            entry.setName("foo.txt");
            outArchive.putArchiveEntry((ArchiveEntry)entry);
            outArchive.write(new byte[]{65});
            outArchive.closeArchiveEntry();
        }
        var3_3 = null;
        try (SevenZFile archive = new SevenZFile(output);){
            entry = archive.getNextEntry();
            SevenZMethodConfiguration m = (SevenZMethodConfiguration)entry.getContentMethods().iterator().next();
            Assert.assertEquals((Object)SevenZMethod.DELTA_FILTER, (Object)m.getMethod());
            Assert.assertEquals((Object)32, (Object)m.getOptions());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void getEntriesOfUnarchiveTest() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"));){
            Iterable entries = sevenZFile.getEntries();
            Iterator iter = entries.iterator();
            SevenZArchiveEntry entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
            Assert.assertFalse((boolean)iter.hasNext());
        }
    }

    @Test
    public void getEntriesOfUnarchiveInMemoryTest() throws IOException {
        byte[] data = null;
        try (InputStream fis = Files.newInputStream(SevenZFileTest.getFile("bla.7z").toPath(), new OpenOption[0]);){
            data = IOUtils.toByteArray((InputStream)fis);
        }
        var3_3 = null;
        try (SevenZFile sevenZFile = new SevenZFile((SeekableByteChannel)new SeekableInMemoryByteChannel(data));){
            Iterable entries = sevenZFile.getEntries();
            Iterator iter = entries.iterator();
            SevenZArchiveEntry entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
            entry = (SevenZArchiveEntry)iter.next();
            Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
            Assert.assertFalse((boolean)iter.hasNext());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void readEntriesOfSize0() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-348.7z"));){
            int entries = 0;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            while (entry != null) {
                ++entries;
                int b = sevenZFile.read();
                if ("2.txt".equals(entry.getName()) || "5.txt".equals(entry.getName())) {
                    Assert.assertEquals((long)-1L, (long)b);
                } else {
                    Assert.assertNotEquals((long)-1L, (long)b);
                }
                entry = sevenZFile.getNextEntry();
            }
            Assert.assertEquals((long)5L, (long)entries);
        }
    }

    @Test(expected=MemoryLimitException.class)
    public void limitExtractionMemory() throws IOException {
        SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"), SevenZFileOptions.builder().withMaxMemoryLimitInKb(1).build());
        Throwable throwable = null;
        if (sevenZFile != null) {
            if (throwable != null) {
                try {
                    sevenZFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                sevenZFile.close();
            }
        }
    }

    @Test
    public void test7zMultiVolumeUnarchive() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(MultiReadOnlySeekableByteChannel.forFiles((File[])new File[]{SevenZFileTest.getFile("bla-multi.7z.001"), SevenZFileTest.getFile("bla-multi.7z.002")}));){
            this.test7zUnarchive(sevenZFile, SevenZMethod.LZMA2);
        }
    }

    @Test
    public void getDefaultNameWorksAsExpected() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.deflate64.7z"));){
            Assert.assertEquals((Object)"bla.deflate64", (Object)sevenZFile.getDefaultName());
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]));
        var2_2 = null;
        try {
            Assert.assertNull((Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]), "foo");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)"foo~", (Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
        sevenZFile = new SevenZFile(Files.newByteChannel(SevenZFileTest.getFile("bla.deflate64.7z").toPath(), new OpenOption[0]), ".foo");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)".foo~", (Object)sevenZFile.getDefaultName());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (sevenZFile != null) {
                if (var2_2 != null) {
                    try {
                        sevenZFile.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    sevenZFile.close();
                }
            }
        }
    }

    @Test
    public void noNameMeansNoNameByDefault() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla-nonames.7z"));){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertNull((Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertNull((Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    @Test
    public void noNameCanBeReplacedByDefaultName() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla-nonames.7z"), SevenZFileOptions.builder().withUseDefaultNameForUnnamedEntries(true).build());){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"bla-nonames", (Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"bla-nonames", (Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    @Test
    public void givenNameWinsOverDefaultName() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"), SevenZFileOptions.builder().withUseDefaultNameForUnnamedEntries(true).build());){
            SevenZArchiveEntry ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"test1.xml", (Object)ae.getName());
            ae = sevenZFile.getNextEntry();
            Assert.assertNotNull((Object)ae);
            Assert.assertEquals((Object)"test2.xml", (Object)ae.getName());
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    @Test
    public void handlesEmptyArchiveWithFilesInfo() throws Exception {
        File f = new File(this.dir, "empty.7z");
        SevenZOutputFile s = new SevenZOutputFile(f);
        Throwable throwable = null;
        if (s != null) {
            if (throwable != null) {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                s.close();
            }
        }
        throwable = null;
        try (SevenZFile z = new SevenZFile(f);){
            Assert.assertFalse((boolean)z.getEntries().iterator().hasNext());
            Assert.assertNull((Object)z.getNextEntry());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    @Test
    public void handlesEmptyArchiveWithoutFilesInfo() throws Exception {
        try (SevenZFile z = new SevenZFile(SevenZFileTest.getFile("COMPRESS-492.7z"));){
            Assert.assertFalse((boolean)z.getEntries().iterator().hasNext());
            Assert.assertNull((Object)z.getNextEntry());
        }
    }

    @Test
    public void test7zUnarchiveWithDefectHeaderFailsByDefault() throws Exception {
        this.thrown.expect(IOException.class);
        this.test7zUnarchive(SevenZFileTest.getFile("bla.noendheaderoffset.7z"), SevenZMethod.LZMA);
    }

    @Test
    public void test7zUnarchiveWithDefectHeader() throws Exception {
        this.test7zUnarchive(SevenZFileTest.getFile("bla.noendheaderoffset.7z"), SevenZMethod.LZMA, true);
    }

    @Test
    public void extractSpecifiedFile() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            String testTxtContents = "111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011";
            for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
                int bytesRead;
                if (!entry.getName().equals("commons-compress-1.7-src/src/test/resources/test.txt")) continue;
                byte[] contents = new byte[(int)entry.getSize()];
                InputStream inputStream = sevenZFile.getInputStream(entry);
                for (int off = 0; off < contents.length; off += bytesRead) {
                    bytesRead = inputStream.read(contents, off, contents.length - off);
                    assert (bytesRead >= 0);
                }
                Assert.assertEquals((Object)"111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011", (Object)new String(contents, StandardCharsets.UTF_8));
                break;
            }
        }
    }

    @Test
    public void testRandomAccessTogetherWithSequentialAccess() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            int bytesRead;
            int off;
            int bytesRead2;
            String testTxtContents = "111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011";
            String filesTxtContents = "0xxxxxxxxx10xxxxxxxx20xxxxxxxx30xxxxxxxx40xxxxxxxx50xxxxxxxx60xxxxxxxx70xxxxxxxx80xxxxxxxx90xxxxxxxx100xxxxxxx110xxxxxxx120xxxxxxx130xxxxxxx -> 0yyyyyyyyy10yyyyyyyy20yyyyyyyy30yyyyyyyy40yyyyyyyy50yyyyyyyy60yyyyyyyy70yyyyyyyy80yyyyyyyy90yyyyyyyy100yyyyyyy110yyyyyyy120yyyyyyy130yyyyyyy\n";
            sevenZFile.getNextEntry();
            SevenZArchiveEntry nextEntry = sevenZFile.getNextEntry();
            byte[] contents = new byte[(int)nextEntry.getSize()];
            Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)nextEntry.getContentMethods().iterator().next()).getMethod());
            for (off = 0; off < contents.length; off += bytesRead2) {
                bytesRead2 = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead2 >= 0);
            }
            sevenZFile.getNextEntry();
            sevenZFile.getNextEntry();
            for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
                int bytesRead3;
                if (!entry.getName().equals("commons-compress-1.7-src/src/test/resources/longsymlink/files.txt")) continue;
                contents = new byte[(int)entry.getSize()];
                InputStream inputStream = sevenZFile.getInputStream(entry);
                for (off = 0; off < contents.length; off += bytesRead3) {
                    bytesRead3 = inputStream.read(contents, off, contents.length - off);
                    assert (bytesRead3 >= 0);
                }
                Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
                Assert.assertEquals((Object)"0xxxxxxxxx10xxxxxxxx20xxxxxxxx30xxxxxxxx40xxxxxxxx50xxxxxxxx60xxxxxxxx70xxxxxxxx80xxxxxxxx90xxxxxxxx100xxxxxxx110xxxxxxx120xxxxxxx130xxxxxxx -> 0yyyyyyyyy10yyyyyyyy20yyyyyyyy30yyyyyyyy40yyyyyyyy50yyyyyyyy60yyyyyyyy70yyyyyyyy80yyyyyyyy90yyyyyyyy100yyyyyyy110yyyyyyy120yyyyyyy130yyyyyyy\n", (Object)new String(contents, StandardCharsets.UTF_8));
                break;
            }
            nextEntry = sevenZFile.getNextEntry();
            while (!nextEntry.getName().equals("commons-compress-1.7-src/src/test/resources/test.txt")) {
                nextEntry = sevenZFile.getNextEntry();
            }
            contents = new byte[(int)nextEntry.getSize()];
            for (off = 0; off < contents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead >= 0);
            }
            Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)nextEntry.getContentMethods().iterator().next()).getMethod());
            Assert.assertEquals((Object)"111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011", (Object)new String(contents, StandardCharsets.UTF_8));
        }
    }

    @Test
    public void testRandomAccessWhenJumpingBackwards() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            int off;
            int bytesRead;
            SevenZArchiveEntry entry;
            String testTxtContents = "111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011";
            SevenZArchiveEntry testTxtEntry = null;
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (!entry.getName().equals("commons-compress-1.7-src/src/test/resources/test.txt")) continue;
                testTxtEntry = entry;
                break;
            }
            SevenZArchiveEntry entryAfterTestTxtEntry = sevenZFile.getNextEntry();
            byte[] entryAfterTestTxtEntryContents = new byte[(int)entryAfterTestTxtEntry.getSize()];
            for (off = 0; off < entryAfterTestTxtEntryContents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(entryAfterTestTxtEntryContents, off, entryAfterTestTxtEntryContents.length - off);
                assert (bytesRead >= 0);
            }
            byte[] contents = new byte[(int)testTxtEntry.getSize()];
            try (InputStream inputStream = sevenZFile.getInputStream(testTxtEntry);){
                int bytesRead2;
                for (off = 0; off < contents.length; off += bytesRead2) {
                    bytesRead2 = inputStream.read(contents, off, contents.length - off);
                    assert (bytesRead2 >= 0);
                }
                Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)testTxtEntry.getContentMethods().iterator().next()).getMethod());
                Assert.assertEquals((Object)"111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011", (Object)new String(contents, StandardCharsets.UTF_8));
            }
            SevenZArchiveEntry nextTestTxtEntry = sevenZFile.getNextEntry();
            byte[] nextTestContents = new byte[(int)nextTestTxtEntry.getSize()];
            for (off = 0; off < nextTestContents.length; off += bytesRead3) {
                int bytesRead3 = sevenZFile.read(nextTestContents, off, nextTestContents.length - off);
                assert (bytesRead3 >= 0);
            }
            Assert.assertEquals((Object)nextTestTxtEntry.getName(), (Object)entryAfterTestTxtEntry.getName());
            Assert.assertEquals((long)nextTestTxtEntry.getSize(), (long)entryAfterTestTxtEntry.getSize());
            Assert.assertArrayEquals((byte[])nextTestContents, (byte[])entryAfterTestTxtEntryContents);
        }
    }

    @Test
    public void testRandomAccessWhenJumpingForwards() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            String testTxtContents = "111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011";
            SevenZArchiveEntry testTxtEntry = null;
            Iterable entries = sevenZFile.getEntries();
            Iterator iter = entries.iterator();
            while (iter.hasNext() && !(testTxtEntry = (SevenZArchiveEntry)iter.next()).getName().equals("commons-compress-1.7-src/src/test/resources/test.txt")) {
            }
            SevenZArchiveEntry firstEntry = sevenZFile.getNextEntry();
            byte[] contents = new byte[(int)firstEntry.getSize() / 2];
            sevenZFile.read(contents);
            sevenZFile.getNextEntry();
            SevenZArchiveEntry thirdEntry = sevenZFile.getNextEntry();
            contents = new byte[(int)thirdEntry.getSize() / 2];
            sevenZFile.read(contents);
            contents = new byte[(int)testTxtEntry.getSize()];
            int numberOfReads = 10;
            while (numberOfReads-- > 0) {
                InputStream inputStream = sevenZFile.getInputStream(testTxtEntry);
                Throwable throwable = null;
                try {
                    int bytesRead;
                    for (int off = 0; off < contents.length; off += bytesRead) {
                        bytesRead = inputStream.read(contents, off, contents.length - off);
                        assert (bytesRead >= 0);
                    }
                    Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)testTxtEntry.getContentMethods().iterator().next()).getMethod());
                    Assert.assertEquals((Object)"111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011", (Object)new String(contents, StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void testRandomAccessMultipleReadSameFile() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));){
            SevenZArchiveEntry entry;
            String testTxtContents = "111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011";
            SevenZArchiveEntry testTxtEntry = null;
            while ((entry = sevenZFile.getNextEntry()) != null) {
                if (!entry.getName().equals("commons-compress-1.7-src/src/test/resources/test.txt")) continue;
                testTxtEntry = entry;
                break;
            }
            byte[] contents = new byte[(int)testTxtEntry.getSize()];
            int numberOfReads = 10;
            while (numberOfReads-- > 0) {
                InputStream inputStream = sevenZFile.getInputStream(testTxtEntry);
                Throwable throwable = null;
                try {
                    int bytesRead;
                    for (int off = 0; off < contents.length; off += bytesRead) {
                        bytesRead = inputStream.read(contents, off, contents.length - off);
                        assert (bytesRead >= 0);
                    }
                    Assert.assertEquals((Object)SevenZMethod.LZMA2, (Object)((SevenZMethodConfiguration)testTxtEntry.getContentMethods().iterator().next()).getMethod());
                    Assert.assertEquals((Object)"111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011\n111111111111111111111111111000101011", (Object)new String(contents, StandardCharsets.UTF_8));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
    }

    @Test
    public void extractNonExistSpecifiedFile() throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-256.7z"));
             SevenZFile anotherSevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"));){
            for (SevenZArchiveEntry nonExistEntry : anotherSevenZFile.getEntries()) {
                this.thrown.expect(IllegalArgumentException.class);
                sevenZFile.getInputStream(nonExistEntry);
            }
        }
    }

    @Test
    public void retrieveInputStreamForAllEntriesMultipleTimes() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("bla.7z"));){
            for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
                byte[] firstRead = IOUtils.toByteArray((InputStream)sevenZFile.getInputStream(entry));
                byte[] secondRead = IOUtils.toByteArray((InputStream)sevenZFile.getInputStream(entry));
                Assert.assertArrayEquals((byte[])firstRead, (byte[])secondRead);
            }
        }
    }

    @Test
    public void retrieveInputStreamForAllEntriesWithoutCRCMultipleTimes() throws IOException {
        try (SevenZOutputFile out = new SevenZOutputFile(new File(this.dir, "test.7z"));){
            Path inputFile = Files.createTempFile("SevenZTestTemp", "", new FileAttribute[0]);
            SevenZArchiveEntry entry = out.createArchiveEntry(inputFile.toFile(), "test.txt");
            out.putArchiveEntry((ArchiveEntry)entry);
            out.write("Test".getBytes(StandardCharsets.UTF_8));
            out.closeArchiveEntry();
            Files.deleteIfExists(inputFile);
        }
        var2_2 = null;
        try (SevenZFile sevenZFile = new SevenZFile(new File(this.dir, "test.7z"));){
            for (SevenZArchiveEntry entry : sevenZFile.getEntries()) {
                byte[] firstRead = IOUtils.toByteArray((InputStream)sevenZFile.getInputStream(entry));
                byte[] secondRead = IOUtils.toByteArray((InputStream)sevenZFile.getInputStream(entry));
                Assert.assertArrayEquals((byte[])firstRead, (byte[])secondRead);
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testNoOOMOnCorruptedHeader() throws IOException {
        ArrayList<Path> testFiles = new ArrayList<Path>();
        testFiles.add(SevenZFileTest.getPath("COMPRESS-542-1.7z"));
        testFiles.add(SevenZFileTest.getPath("COMPRESS-542-2.7z"));
        testFiles.add(SevenZFileTest.getPath("COMPRESS-542-endheadercorrupted.7z"));
        testFiles.add(SevenZFileTest.getPath("COMPRESS-542-endheadercorrupted2.7z"));
        for (Path file : testFiles) {
            try {
                SevenZFile sevenZFile = new SevenZFile(Files.newByteChannel(file, new OpenOption[0]), SevenZFileOptions.builder().withTryToRecoverBrokenArchives(true).build());
                Throwable throwable = null;
                try {
                    Assert.fail((String)"Expected IOException: start header corrupt and unable to guess end header");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sevenZFile == null) continue;
                    if (throwable != null) {
                        try {
                            sevenZFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sevenZFile.close();
                }
            }
            catch (IOException e) {
                Assert.assertEquals((Object)"Start header corrupt and unable to guess end header", (Object)e.getMessage());
            }
        }
    }

    @Test
    public void retrieveInputStreamForShuffledEntries() throws IOException {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile("COMPRESS-348.7z"));){
            List entries = (List)sevenZFile.getEntries();
            Collections.shuffle(entries);
            for (SevenZArchiveEntry entry : entries) {
                IOUtils.toByteArray((InputStream)sevenZFile.getInputStream(entry));
            }
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m, byte[] password) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(f, password);){
            this.test7zUnarchive(sevenZFile, m);
        }
    }

    private void test7zUnarchive(File f, SevenZMethod m, char[] password) throws Exception {
        this.test7zUnarchive(f, m, password, false);
    }

    private void test7zUnarchive(File f, SevenZMethod m, char[] password, boolean tryToRecoverBrokenArchives) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(f, password, SevenZFileOptions.builder().withTryToRecoverBrokenArchives(tryToRecoverBrokenArchives).build());){
            this.test7zUnarchive(sevenZFile, m);
        }
    }

    private void test7zUnarchive(SevenZFile sevenZFile, SevenZMethod m) throws Exception {
        int bytesRead;
        SevenZArchiveEntry entry = sevenZFile.getNextEntry();
        Assert.assertEquals((Object)"test1.xml", (Object)entry.getName());
        Assert.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
        entry = sevenZFile.getNextEntry();
        Assert.assertEquals((Object)"test2.xml", (Object)entry.getName());
        Assert.assertEquals((Object)m, (Object)((SevenZMethodConfiguration)entry.getContentMethods().iterator().next()).getMethod());
        byte[] contents = new byte[(int)entry.getSize()];
        for (int off = 0; off < contents.length; off += bytesRead) {
            bytesRead = sevenZFile.read(contents, off, contents.length - off);
            assert (bytesRead >= 0);
        }
        Assert.assertEquals((Object)TEST2_CONTENT, (Object)new String(contents, StandardCharsets.UTF_8));
        Assert.assertNull((Object)sevenZFile.getNextEntry());
    }

    private void checkHelloWorld(String filename) throws Exception {
        try (SevenZFile sevenZFile = new SevenZFile(SevenZFileTest.getFile(filename));){
            int bytesRead;
            SevenZArchiveEntry entry = sevenZFile.getNextEntry();
            Assert.assertEquals((Object)"Hello world.txt", (Object)entry.getName());
            byte[] contents = new byte[(int)entry.getSize()];
            for (int off = 0; off < contents.length; off += bytesRead) {
                bytesRead = sevenZFile.read(contents, off, contents.length - off);
                assert (bytesRead >= 0);
            }
            Assert.assertEquals((Object)"Hello, world!\n", (Object)new String(contents, StandardCharsets.UTF_8));
            Assert.assertNull((Object)sevenZFile.getNextEntry());
        }
    }

    private static boolean isStrongCryptoAvailable() throws NoSuchAlgorithmException {
        return Cipher.getMaxAllowedKeyLength("AES/ECB/PKCS5Padding") >= 256;
    }
}

