/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.jar;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.JarMarker;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipExtraField;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.junit.Assert;
import org.junit.Test;

public class JarArchiveOutputStreamTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJarMarker() throws IOException {
        ZipFile zf;
        File testArchive;
        block7: {
            testArchive = File.createTempFile("jar-aostest", ".jar");
            testArchive.deleteOnExit();
            JarArchiveOutputStream out = null;
            zf = null;
            try {
                out = new JarArchiveOutputStream(Files.newOutputStream(testArchive.toPath(), new OpenOption[0]));
                out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("foo/"));
                out.closeArchiveEntry();
                out.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry("bar/"));
                out.closeArchiveEntry();
                out.finish();
                out.close();
                out = null;
                zf = new ZipFile(testArchive);
                ZipArchiveEntry ze = zf.getEntry("foo/");
                Assert.assertNotNull((Object)ze);
                ZipExtraField[] fes = ze.getExtraFields();
                Assert.assertEquals((long)1L, (long)fes.length);
                Assert.assertTrue((boolean)(fes[0] instanceof JarMarker));
                ze = zf.getEntry("bar/");
                Assert.assertNotNull((Object)ze);
                fes = ze.getExtraFields();
                Assert.assertEquals((long)0L, (long)fes.length);
                if (out == null) break block7;
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ZipFile.closeQuietly(zf);
                AbstractTestCase.tryHardToDelete(testArchive);
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ZipFile.closeQuietly((ZipFile)zf);
        AbstractTestCase.tryHardToDelete(testArchive);
    }
}

