/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress;

import java.io.BufferedReader;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.AbstractTestCase;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ArchiveReadTest
extends AbstractTestCase {
    private static final ClassLoader CLASSLOADER = ArchiveReadTest.class.getClassLoader();
    private static final File ARCDIR;
    private static final ArrayList<String> FILELIST;
    private final File file;

    public ArchiveReadTest(String file) {
        this.file = new File(ARCDIR, file);
    }

    @BeforeClass
    public static void setUpFileList() throws Exception {
        Assert.assertTrue((boolean)ARCDIR.exists());
        File listing = new File(ARCDIR, "files.txt");
        Assert.assertTrue((String)"files.txt is readable", (boolean)listing.canRead());
        try (BufferedReader br = new BufferedReader(Files.newBufferedReader(listing.toPath()));){
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#")) continue;
                FILELIST.add(line);
            }
        }
    }

    @Parameterized.Parameters(name="file={0}")
    public static Collection<Object[]> data() {
        Assert.assertTrue((boolean)ARCDIR.exists());
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String f : ARCDIR.list((dir, name) -> !name.endsWith(".txt"))) {
            params.add(new Object[]{f});
        }
        return params;
    }

    @Override
    protected String getExpectedString(ArchiveEntry entry) {
        return entry.getSize() + " " + entry.getName();
    }

    @Test
    public void testArchive() throws Exception {
        ArrayList expected = (ArrayList)FILELIST.clone();
        try {
            this.checkArchiveContent(this.file, (List<String>)expected);
        }
        catch (ArchiveException e) {
            Assert.fail((String)("Problem checking " + this.file));
        }
        catch (AssertionError e) {
            Assert.fail((String)("Problem checking " + this.file + " " + e));
        }
    }

    static {
        FILELIST = new ArrayList();
        try {
            ARCDIR = new File(CLASSLOADER.getResource("archives").toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

