/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.UUID;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestStatements {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi = new DBI((DataSource)ds);
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    @Test
    public void testInsert() throws Exception {
        Inserter i = (Inserter)SqlObjectBuilder.open((IDBI)this.dbi, Inserter.class);
        int rows_affected = i.insert(2L, "Diego");
        String name = (String)this.handle.createQuery("select name from something where id = 2").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertEquals((long)1L, (long)rows_affected);
        Assert.assertEquals((Object)"Diego", (Object)name);
        i.close();
    }

    @Test
    public void testInsertWithVoidReturn() throws Exception {
        Inserter i = (Inserter)SqlObjectBuilder.open((IDBI)this.dbi, Inserter.class);
        i.insertWithVoidReturn(2L, "Diego");
        String name = (String)this.handle.createQuery("select name from something where id = 2").map((ResultSetMapper)StringMapper.FIRST).first();
        Assert.assertEquals((Object)"Diego", (Object)name);
        i.close();
    }

    public static interface Inserter
    extends CloseMe {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public int insert(@Bind(value="id") long var1, @Bind(value="name") String var3);

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insertWithVoidReturn(@Bind(value="id") long var1, @Bind(value="name") String var3);
    }
}

