/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.logging.PrintStreamLog;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlCall;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.tweak.SQLLog;

public class TestSqlCall {
    private DBI dbi;
    private Handle handle;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.dbi.setSQLLog((SQLLog)new PrintStreamLog(System.out));
        this.handle = this.dbi.open();
        this.handle.execute("create table something( id integer primary key, name varchar(100) )", new Object[0]);
        this.handle.execute("CREATE ALIAS stored_insert FOR \"org.skife.jdbi.v2.sqlobject.TestSqlCall.insertSomething\";", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testFoo() throws Exception {
        Dao dao = (Dao)this.handle.attach(Dao.class);
        dao.insert(1, "Jeff");
        Assert.assertThat((Object)((Dao)this.handle.attach(Dao.class)).findById(1), (Matcher)CoreMatchers.equalTo((Object)new Something(1, "Jeff")));
    }

    public static int insertSomething(Connection conn, int id, String name) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement("insert into something (id, name) values (?, ?)");
        stmt.setInt(1, id);
        stmt.setString(2, name);
        return stmt.executeUpdate();
    }

    public static interface Dao {
        @SqlCall(value="call stored_insert(:id, :name)")
        public void insert(@Bind(value="id") int var1, @Bind(value="name") String var2);

        @SqlQuery(value="select id, name from something where id = :id")
        @RegisterMapper(value={SomethingMapper.class})
        public Something findById(@Bind(value="id") int var1);
    }
}

