/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.h2.jdbcx.JdbcDataSource;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SomethingMapper;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.TransactionIsolation;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class TestDoublyTransactional {
    private DBI dbi;
    private Handle handle;
    private final AtomicBoolean inTransaction = new AtomicBoolean();
    private static final Set<Method> CHECKED_METHODS;

    @Test
    public void testDoublyTransactional() throws Exception {
        TheBasics dao = (TheBasics)this.dbi.onDemand(TheBasics.class);
        dao.inTransaction(TransactionIsolationLevel.SERIALIZABLE, (Transaction)new Transaction<Void, TheBasics>(){

            public Void inTransaction(TheBasics transactional, TransactionStatus status) throws Exception {
                transactional.insert(new Something(1, "2"));
                TestDoublyTransactional.this.inTransaction.set(true);
                transactional.insert(new Something(2, "3"));
                TestDoublyTransactional.this.inTransaction.set(false);
                return null;
            }
        });
    }

    @Before
    public void setUp() throws Exception {
        JdbcDataSource ds = new JdbcDataSource(){
            private static final long serialVersionUID = 1L;

            public Connection getConnection() throws SQLException {
                Connection real = super.getConnection();
                return (Connection)Proxy.newProxyInstance(real.getClass().getClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new TxnIsolationCheckingInvocationHandler(real));
            }
        };
        ds.setURL(String.format("jdbc:h2:mem:%s;MVCC=TRUE", UUID.randomUUID()));
        this.dbi = new DBI((DataSource)ds);
        this.dbi.registerMapper((ResultSetMapper)new SomethingMapper());
        this.handle = this.dbi.open();
        this.handle.execute("create table something (id int primary key, name varchar(100))", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.execute("drop table something", new Object[0]);
        this.handle.close();
    }

    static {
        try {
            CHECKED_METHODS = ImmutableSet.of((Object)Connection.class.getMethod("setTransactionIsolation", Integer.TYPE));
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class TxnIsolationCheckingInvocationHandler
    implements InvocationHandler {
        private final Connection real;

        public TxnIsolationCheckingInvocationHandler(Connection real) {
            this.real = real;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (CHECKED_METHODS.contains(method) && TestDoublyTransactional.this.inTransaction.get()) {
                throw new SQLException(String.format("PostgreSQL would not let you set the transaction isolation here", new Object[0]));
            }
            return method.invoke((Object)this.real, args);
        }
    }

    static interface TheBasics
    extends Transactional<TheBasics> {
        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        @TransactionIsolation(value=TransactionIsolationLevel.SERIALIZABLE)
        public int insert(@BindBean Something var1);
    }
}

