/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;

public class TestIterator
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
    }

    @Override
    public void doTearDown() throws Exception {
        Assert.assertTrue((String)"Handle was not closed correctly!", (boolean)this.h.isClosed());
    }

    @Test
    public void testSimple() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testEmptyWorksToo() throws Exception {
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testHasNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        it.next();
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testJustNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        it.next();
        it.next();
        it.next();
    }

    @Test
    public void testTwoTwo() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        it.next();
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testTwoOne() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        it.next();
        Assert.assertTrue((boolean)it.hasNext());
        it.next();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testExplodeIterator() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        this.h.createStatement("insert into something (id, name) values (3, 'john')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        try {
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
            Assert.assertTrue((boolean)it.hasNext());
            it.next();
            Assert.assertFalse((boolean)it.hasNext());
        }
        catch (Throwable t) {
            Assert.fail((String)("unexpected throwable:" + t.getMessage()));
        }
        try {
            it.next();
            Assert.fail((String)"Expected IllegalStateException did not show up!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyExplosion() throws Exception {
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        try {
            it.next();
            Assert.fail((String)"Expected IllegalStateException did not show up!");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testNonPathologicalJustNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        Map result = (Map)((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator().next();
        Assert.assertEquals((Object)1, result.get("id"));
        Assert.assertEquals((Object)"eric", result.get("name"));
    }

    @Test
    public void testStillLeakingJustNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        Map result = (Map)((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator().next();
        Assert.assertEquals((Object)1, result.get("id"));
        Assert.assertEquals((Object)"eric", result.get("name"));
        Assert.assertFalse((boolean)this.h.isClosed());
        this.h.close();
    }

    @Test
    public void testLessLeakingJustNext() throws Exception {
        this.h.createStatement("insert into something (id, name) values (1, 'eric')").execute();
        this.h.createStatement("insert into something (id, name) values (2, 'brian')").execute();
        ResultIterator it = ((Query)this.h.createQuery("select * from something order by id").cleanupHandle()).iterator();
        try {
            Map result = (Map)it.next();
            Assert.assertEquals((Object)1, result.get("id"));
            Assert.assertEquals((Object)"eric", result.get("name"));
            Assert.assertFalse((boolean)this.h.isClosed());
        }
        finally {
            it.close();
        }
    }
}

