/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.skife.jdbi.v2.ContainerBuilder;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Something;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterContainerMapper;
import org.skife.jdbi.v2.sqlobject.customizers.SingleValueResult;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class TestContainerFactory {
    private DBI dbi;
    private Handle h;

    @Before
    public void setUp() throws Exception {
        this.dbi = new DBI("jdbc:h2:mem:" + UUID.randomUUID());
        this.h = this.dbi.open();
        this.h.execute("create table something (id int primary key, name varchar)", new Object[0]);
    }

    @After
    public void tearDown() throws Exception {
        this.h.close();
    }

    @Test
    public void testExists() throws Exception {
        this.h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        this.h.registerContainerFactory((ContainerFactory)new MaybeContainerFactory());
        Maybe rs = (Maybe)((Query)this.h.createQuery("select name from something where id = :id").bind("id", 1)).map((ResultSetMapper)StringMapper.FIRST).first(Maybe.class);
        Assert.assertThat((Object)rs.isKnown(), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat(rs.getValue(), (Matcher)CoreMatchers.equalTo((Object)"Coda"));
    }

    @Test
    public void testDoesNotExist() throws Exception {
        this.h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        this.h.registerContainerFactory((ContainerFactory)new MaybeContainerFactory());
        Maybe rs = (Maybe)((Query)this.h.createQuery("select name from something where id = :id").bind("id", 2)).map((ResultSetMapper)StringMapper.FIRST).first(Maybe.class);
        Assert.assertThat((Object)rs.isKnown(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testOnList() throws Exception {
        this.h.registerContainerFactory((ContainerFactory)new ImmutableListContainerFactory());
        this.h.execute("insert into something (id, name) values (1, 'Coda')", new Object[0]);
        this.h.execute("insert into something (id, name) values (2, 'Brian')", new Object[0]);
        ImmutableList rs = (ImmutableList)this.h.createQuery("select name from something order by id").map((ResultSetMapper)StringMapper.FIRST).list(ImmutableList.class);
        Assert.assertThat((Object)rs, (Matcher)CoreMatchers.equalTo((Object)ImmutableList.of((Object)"Coda", (Object)"Brian")));
    }

    @Test
    public void testWithSqlObject() throws Exception {
        Dao dao = (Dao)this.dbi.onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        ImmutableList<String> rs = dao.findAll();
        Assert.assertThat(rs, (Matcher)CoreMatchers.equalTo((Object)ImmutableList.of((Object)"Coda", (Object)"Brian")));
    }

    @Test
    public void testWithSqlObjectSingleValue() throws Exception {
        Dao dao = (Dao)this.dbi.onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        Maybe<String> rs = dao.findNameById(1);
        Assert.assertThat(rs, (Matcher)CoreMatchers.equalTo(Maybe.definitely("Coda")));
        rs = dao.smartFindNameById(1);
        Assert.assertThat(rs, (Matcher)CoreMatchers.equalTo(Maybe.definitely("Coda")));
        rs = dao.inheritedGenericFindNameById(1);
        Assert.assertThat(rs, (Matcher)CoreMatchers.equalTo(Maybe.definitely("Coda")));
    }

    @Test
    public void testWithSqlObjectSetReturnValue() throws Exception {
        Dao dao = (Dao)this.dbi.onDemand(Dao.class);
        dao.insert(new Something(1, "Coda"));
        dao.insert(new Something(2, "Brian"));
        Set<String> rs = dao.findAllAsSet();
        Assert.assertThat(rs, (Matcher)CoreMatchers.equalTo((Object)ImmutableSet.of((Object)"Coda", (Object)"Brian")));
    }

    public static abstract class Maybe<T> {
        public abstract Maybe<T> otherwise(Maybe<T> var1);

        public abstract T getValue();

        public abstract boolean isKnown();

        public static <T> Maybe<T> definitely(T theValue) {
            return new DefiniteValue<T>(theValue);
        }

        public static <T> Maybe<T> unknown() {
            return new Maybe<T>(){

                @Override
                public boolean isKnown() {
                    return false;
                }

                @Override
                public Maybe<T> otherwise(Maybe<T> maybeDefaultValue) {
                    return maybeDefaultValue;
                }

                @Override
                public T getValue() {
                    throw new IllegalStateException("No value known!");
                }

                public String toString() {
                    return "unknown";
                }

                public boolean equals(Object obj) {
                    return false;
                }

                public int hashCode() {
                    return 0;
                }
            };
        }

        private static class DefiniteValue<T>
        extends Maybe<T> {
            private final T theValue;

            public DefiniteValue(T theValue) {
                this.theValue = theValue;
            }

            @Override
            public boolean isKnown() {
                return true;
            }

            @Override
            public Maybe<T> otherwise(Maybe<T> maybeDefaultValue) {
                return this;
            }

            @Override
            public T getValue() {
                return this.theValue;
            }

            public String toString() {
                return "definitely " + this.theValue.toString();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                DefiniteValue that = (DefiniteValue)o;
                return this.theValue.equals(that.theValue);
            }

            public int hashCode() {
                return this.theValue.hashCode();
            }
        }
    }

    public static class MaybeContainerFactory
    implements ContainerFactory<Maybe<?>> {
        public boolean accepts(Class<?> type) {
            return type.equals(Maybe.class);
        }

        public ContainerBuilder<Maybe<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<Maybe<?>>(){
                private Maybe<Object> value = Maybe.unknown();

                public ContainerBuilder<Maybe<?>> add(Object it) {
                    this.value = this.value.otherwise(Maybe.definitely(it));
                    return this;
                }

                public Maybe<?> build() {
                    return this.value;
                }
            };
        }
    }

    public static class ImmutableListContainerFactory
    implements ContainerFactory<ImmutableList<?>> {
        public boolean accepts(Class<?> type) {
            return ImmutableList.class.equals(type);
        }

        public ContainerBuilder<ImmutableList<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<ImmutableList<?>>(){
                private final ImmutableList.Builder<Object> b = ImmutableList.builder();

                public ContainerBuilder<ImmutableList<?>> add(Object it) {
                    this.b.add(it);
                    return this;
                }

                public ImmutableList<?> build() {
                    return this.b.build();
                }
            };
        }
    }

    public static class SetContainerFactory
    implements ContainerFactory<Set<?>> {
        public boolean accepts(Class<?> type) {
            return Set.class.equals(type);
        }

        public ContainerBuilder<Set<?>> newContainerBuilderFor(Class<?> type) {
            return new ContainerBuilder<Set<?>>(){
                private Set<Object> rs = new LinkedHashSet<Object>();

                public ContainerBuilder<Set<?>> add(Object it) {
                    this.rs.add(it);
                    return this;
                }

                public Set<?> build() {
                    return this.rs;
                }
            };
        }
    }

    public static interface Base<T> {
        @SqlQuery(value="select name from something where id = :id")
        @SingleValueResult
        public Maybe<T> inheritedGenericFindNameById(@Bind(value="id") int var1);
    }

    @RegisterContainerMapper(value={ImmutableListContainerFactory.class, MaybeContainerFactory.class})
    public static interface Dao
    extends Base<String> {
        @SqlQuery(value="select name from something order by id")
        public ImmutableList<String> findAll();

        @SqlQuery(value="select name from something order by id")
        public Set<String> findAllAsSet();

        @SqlUpdate(value="insert into something (id, name) values (:id, :name)")
        public void insert(@BindBean Something var1);

        @SqlQuery(value="select name from something where id = :id")
        @SingleValueResult(value=String.class)
        public Maybe<String> findNameById(@Bind(value="id") int var1);

        @SqlQuery(value="select name from something where id = :id")
        @SingleValueResult
        public Maybe<String> smartFindNameById(@Bind(value="id") int var1);
    }
}

