/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import org.junit.Assert;
import org.junit.Test;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.Call;
import org.skife.jdbi.v2.DBITestCase;
import org.skife.jdbi.v2.OutParameters;

public class TestCallable
extends DBITestCase {
    private BasicHandle h;

    @Override
    public void doSetUp() throws Exception {
        this.h = this.openHandle();
        try {
            this.h.execute("drop function to_degrees", new Object[0]);
            this.h.execute("drop procedure test_procedure", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.h.execute("CREATE FUNCTION TO_DEGREES(RADIANS DOUBLE) RETURNS DOUBLE\nPARAMETER STYLE JAVA NO SQL LANGUAGE JAVA\nEXTERNAL NAME 'java.lang.Math.toDegrees'", new Object[0]);
        this.h.execute("CREATE PROCEDURE TEST_PROCEDURE(in in_param varchar(20), out out_param varchar(20))\nPARAMETER STYLE JAVA NO SQL LANGUAGE JAVA\nEXTERNAL NAME 'org.skife.jdbi.v2.TestCallable.testProcedure'", new Object[0]);
    }

    @Override
    public void doTearDown() throws Exception {
        try {
            this.h.execute("drop function to_degrees", new Object[0]);
            this.h.execute("drop procedure test_procedure", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.h != null) {
            this.h.close();
        }
    }

    @Test
    public void testStatement() throws Exception {
        OutParameters ret = ((Call)this.h.createCall("? = CALL TO_DEGREES(?)").registerOutParameter(0, 8).bind(1, 100.0)).invoke();
        Double expected = Math.toDegrees(100.0);
        Assert.assertEquals((Object)expected, (Object)ret.getDouble(1));
        Assert.assertEquals((long)expected.longValue(), (long)ret.getLong(1));
        Assert.assertEquals((long)expected.shortValue(), (long)ret.getShort(1).shortValue());
        Assert.assertEquals((long)expected.intValue(), (long)ret.getInt(1).intValue());
        Assert.assertEquals((double)expected.floatValue(), (double)ret.getFloat(1).floatValue(), (double)0.001);
        try {
            ret.getDate(1);
            Assert.fail((String)"didn't throw exception !");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ret.getDate(2);
            Assert.fail((String)"didn't throw exception !");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStatementWithNamedParam() throws Exception {
        OutParameters ret = ((Call)this.h.createCall(":x = CALL TO_DEGREES(:y)").registerOutParameter("x", 8).bind("y", 100.0)).invoke();
        Double expected = Math.toDegrees(100.0);
        Assert.assertEquals((Object)expected, (Object)ret.getDouble("x"));
        Assert.assertEquals((long)expected.longValue(), (long)ret.getLong("x"));
        Assert.assertEquals((long)expected.shortValue(), (long)ret.getShort("x").shortValue());
        Assert.assertEquals((long)expected.intValue(), (long)ret.getInt("x").intValue());
        Assert.assertEquals((double)expected.floatValue(), (double)ret.getFloat("x").floatValue(), (double)0.001);
        try {
            ret.getDate("x");
            Assert.fail((String)"didn't throw exception !");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ret.getDate("y");
            Assert.fail((String)"didn't throw exception !");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testWithNullReturn() throws Exception {
        OutParameters ret = ((Call)this.h.createCall("CALL TEST_PROCEDURE(?, ?)").bind(0, (String)null)).registerOutParameter(1, 12).invoke();
        String out = ret.getString(2);
        Assert.assertEquals((Object)out, null);
    }

    @Test
    public void testWithNullReturnWithNamedParam() throws Exception {
        OutParameters ret = ((Call)this.h.createCall("CALL TEST_PROCEDURE(:x, :y)").bind("x", (String)null)).registerOutParameter("y", 12).invoke();
        String out = ret.getString("y");
        Assert.assertEquals((Object)out, null);
    }

    public static void testProcedure(String in, String[] out) {
        out = new String[]{in};
    }
}

