/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import java.util.concurrent.Semaphore;
import org.asynchttpclient.netty.channel.NonBlockingSemaphore;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NonBlockingSemaphoreTest {
    @Test
    public void test0() {
        Mirror mirror = new Mirror(0);
        Assert.assertFalse((boolean)mirror.tryAcquire());
    }

    @Test
    public void three() {
        Mirror mirror = new Mirror(3);
        for (int i = 0; i < 3; ++i) {
            Assert.assertTrue((boolean)mirror.tryAcquire());
        }
        Assert.assertFalse((boolean)mirror.tryAcquire());
        mirror.release();
        Assert.assertTrue((boolean)mirror.tryAcquire());
    }

    @Test
    public void negative() {
        Mirror mirror = new Mirror(-1);
        Assert.assertFalse((boolean)mirror.tryAcquire());
        mirror.release();
        Assert.assertFalse((boolean)mirror.tryAcquire());
        mirror.release();
        Assert.assertTrue((boolean)mirror.tryAcquire());
    }

    private static class Mirror {
        private final Semaphore real;
        private final NonBlockingSemaphore nonBlocking;

        public Mirror(int permits) {
            this.real = new Semaphore(permits);
            this.nonBlocking = new NonBlockingSemaphore(permits);
        }

        public boolean tryAcquire() {
            boolean a = this.real.tryAcquire();
            boolean b = this.nonBlocking.tryAcquire();
            Assert.assertEquals((boolean)a, (boolean)b);
            return a;
        }

        public void release() {
            this.real.release();
            this.nonBlocking.release();
        }
    }
}

