/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.test;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.test.CalciteAssert;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.CustomTypeSafeMatcher;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.Is;

public class Matchers {
    private static final ThreadLocal<Object> THREAD_ACTUAL = new ThreadLocal();

    private Matchers() {
    }

    public static Matcher<? super ResultSet> returnsUnordered(String ... lines) {
        final ArrayList expectedList = Lists.newArrayList((Object[])lines);
        Collections.sort(expectedList);
        return new CustomTypeSafeMatcher<ResultSet>(Arrays.toString(lines)){

            protected void describeMismatchSafely(ResultSet item, Description description) {
                Object value = THREAD_ACTUAL.get();
                THREAD_ACTUAL.remove();
                description.appendText("was ").appendValue(value);
            }

            protected boolean matchesSafely(ResultSet resultSet) {
                ArrayList actualList = Lists.newArrayList();
                try {
                    CalciteAssert.toStringList(resultSet, actualList);
                    resultSet.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                Collections.sort(actualList);
                THREAD_ACTUAL.set(actualList);
                boolean equals = actualList.equals(expectedList);
                if (!equals) {
                    THREAD_ACTUAL.set(actualList);
                }
                return equals;
            }
        };
    }

    public static <E extends Comparable> Matcher<Iterable<E>> equalsUnordered(E ... lines) {
        final ArrayList expectedList = Lists.newArrayList(Matchers.toStringList(Arrays.asList(lines)));
        Collections.sort(expectedList);
        String description = Util.lines((Iterable)expectedList);
        return new CustomTypeSafeMatcher<Iterable<E>>(description){

            protected void describeMismatchSafely(Iterable<E> actuals, Description description) {
                ArrayList actualList = Lists.newArrayList((Iterable)Matchers.toStringList(actuals));
                Collections.sort(actualList);
                description.appendText("was ").appendValue((Object)Util.lines((Iterable)actualList));
            }

            protected boolean matchesSafely(Iterable<E> actuals) {
                ArrayList actualList = Lists.newArrayList((Iterable)Matchers.toStringList(actuals));
                Collections.sort(actualList);
                return actualList.equals(expectedList);
            }
        };
    }

    private static <E> Iterable<String> toStringList(Iterable<E> items) {
        return Iterables.transform(items, (Function)Functions.toStringFunction());
    }

    @Factory
    public static <T extends Number> Matcher<T> within(T value, double epsilon) {
        return new IsWithin<T>(value, epsilon);
    }

    public static <F, T> Matcher<F> compose(Matcher<T> matcher, Function<F, T> f) {
        return new ComposingMatcher<F, T>(matcher, f);
    }

    @Factory
    public static Matcher<String> isLinux(String value) {
        return Matchers.compose(Is.is((Object)value), new Function<String, String>(){

            public String apply(String input) {
                return input == null ? null : Util.toLinux((String)input);
            }
        });
    }

    @Factory
    public static Matcher<RelNode> hasTree(String value) {
        return Matchers.compose(Is.is((Object)value), new Function<RelNode, String>(){

            public String apply(RelNode input) {
                return Util.toLinux((String)RelOptUtil.toString((RelNode)input));
            }
        });
    }

    @Factory
    public static Matcher<String> containsStringLinux(String value) {
        return Matchers.compose(CoreMatchers.containsString((String)value), new Function<String, String>(){

            public String apply(String input) {
                return Util.toLinux((String)input);
            }
        });
    }

    private static class ComposingMatcher<F, T>
    extends TypeSafeMatcher<F> {
        private final Matcher<T> matcher;
        private final Function<F, T> f;

        ComposingMatcher(Matcher<T> matcher, Function<F, T> f) {
            this.matcher = matcher;
            this.f = f;
        }

        protected boolean matchesSafely(F item) {
            return this.matcher.matches(this.f.apply(item));
        }

        public void describeTo(Description description) {
            this.matcher.describeTo(description);
        }
    }

    public static class IsWithin<T extends Number>
    extends BaseMatcher<T> {
        private final T expectedValue;
        private final double epsilon;

        public IsWithin(T expectedValue, double epsilon) {
            Preconditions.checkArgument((epsilon >= 0.0 ? 1 : 0) != 0);
            this.expectedValue = expectedValue;
            this.epsilon = epsilon;
        }

        public boolean matches(Object actualValue) {
            return IsWithin.isWithin(actualValue, this.expectedValue, this.epsilon);
        }

        public void describeTo(Description description) {
            description.appendValue((Object)(this.expectedValue + " +/-" + this.epsilon));
        }

        private static boolean isWithin(Object actual, Number expected, double epsilon) {
            if (actual == null) {
                return expected == null;
            }
            if (actual.equals(expected)) {
                return true;
            }
            double a = ((Number)actual).doubleValue();
            double min = expected.doubleValue() - epsilon;
            double max = expected.doubleValue() + epsilon;
            return min <= a && a <= max;
        }
    }
}

