/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.prepare;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalciteConnection;
import org.apache.hive.druid.org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.hive.druid.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.hive.druid.org.apache.calcite.schema.Function;
import org.apache.hive.druid.org.apache.calcite.schema.Schema;
import org.apache.hive.druid.org.apache.calcite.schema.SchemaPlus;
import org.apache.hive.druid.org.apache.calcite.schema.TableFunction;
import org.apache.hive.druid.org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.hive.druid.org.apache.calcite.schema.impl.TableFunctionImpl;
import org.apache.hive.druid.org.apache.calcite.server.CalciteServerStatement;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlIdentifier;
import org.apache.hive.druid.org.apache.calcite.sql.SqlOperator;
import org.apache.hive.druid.org.apache.calcite.sql.SqlSyntax;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import org.apache.hive.druid.org.apache.calcite.util.Smalls;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LookupOperatorOverloadsTest {
    private void checkFunctionType(int size, String name, List<SqlOperator> operatorList) {
        Assert.assertThat((Object)size, (Matcher)CoreMatchers.is((Object)operatorList.size()));
        for (SqlOperator op : operatorList) {
            Assert.assertThat((Object)op, (Matcher)CoreMatchers.instanceOf(SqlUserDefinedTableFunction.class));
            Assert.assertThat((Object)name, (Matcher)CoreMatchers.is((Object)op.getName()));
        }
    }

    private static void check(List<SqlFunctionCategory> actuals, SqlFunctionCategory ... expecteds) {
        Assert.assertThat(actuals, (Matcher)CoreMatchers.is(Arrays.asList(expecteds)));
    }

    @Test
    public void testIsUserDefined() throws SQLException {
        ArrayList<SqlFunctionCategory> cats = new ArrayList<SqlFunctionCategory>();
        for (SqlFunctionCategory c : SqlFunctionCategory.values()) {
            if (!c.isUserDefined()) continue;
            cats.add(c);
        }
        LookupOperatorOverloadsTest.check(cats, SqlFunctionCategory.USER_DEFINED_FUNCTION, SqlFunctionCategory.USER_DEFINED_PROCEDURE, SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR, SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
    }

    @Test
    public void testIsTableFunction() throws SQLException {
        ArrayList<SqlFunctionCategory> cats = new ArrayList<SqlFunctionCategory>();
        for (SqlFunctionCategory c : SqlFunctionCategory.values()) {
            if (!c.isTableFunction()) continue;
            cats.add(c);
        }
        LookupOperatorOverloadsTest.check(cats, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION, SqlFunctionCategory.MATCH_RECOGNIZE);
    }

    @Test
    public void testIsSpecific() throws SQLException {
        ArrayList<SqlFunctionCategory> cats = new ArrayList<SqlFunctionCategory>();
        for (SqlFunctionCategory c : SqlFunctionCategory.values()) {
            if (!c.isSpecific()) continue;
            cats.add(c);
        }
        LookupOperatorOverloadsTest.check(cats, SqlFunctionCategory.USER_DEFINED_SPECIFIC_FUNCTION, SqlFunctionCategory.USER_DEFINED_TABLE_SPECIFIC_FUNCTION);
    }

    @Test
    public void testIsUserDefinedNotSpecificFunction() throws SQLException {
        ArrayList<SqlFunctionCategory> cats = new ArrayList<SqlFunctionCategory>();
        for (SqlFunctionCategory sqlFunctionCategory : SqlFunctionCategory.values()) {
            if (!sqlFunctionCategory.isUserDefinedNotSpecificFunction()) continue;
            cats.add(sqlFunctionCategory);
        }
        LookupOperatorOverloadsTest.check(cats, SqlFunctionCategory.USER_DEFINED_FUNCTION, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION);
    }

    @Test
    public void test() throws SQLException {
        String schemaName = "MySchema";
        String funcName = "MyFUNC";
        String anotherName = "AnotherFunc";
        try (Connection connection = DriverManager.getConnection("jdbc:calcite:");){
            CalciteConnection calciteConnection = connection.unwrap(CalciteConnection.class);
            SchemaPlus rootSchema = calciteConnection.getRootSchema();
            SchemaPlus schema = rootSchema.add("MySchema", (Schema)new AbstractSchema());
            TableFunction table = TableFunctionImpl.create((Method)Smalls.MAZE_METHOD);
            schema.add("MyFUNC", (Function)table);
            schema.add("AnotherFunc", (Function)table);
            TableFunction table2 = TableFunctionImpl.create((Method)Smalls.MAZE3_METHOD);
            schema.add("MyFUNC", (Function)table2);
            CalciteServerStatement statement = connection.createStatement().unwrap(CalciteServerStatement.class);
            CalcitePrepare.Context prepareContext = statement.createPrepareContext();
            JavaTypeFactory typeFactory = prepareContext.getTypeFactory();
            CalciteCatalogReader reader = new CalciteCatalogReader(prepareContext.getRootSchema(), (List)ImmutableList.of(), (RelDataTypeFactory)typeFactory, prepareContext.config());
            ArrayList<SqlOperator> operatorList = new ArrayList<SqlOperator>();
            SqlIdentifier myFuncIdentifier = new SqlIdentifier((List)Lists.newArrayList((Object[])new String[]{"MySchema", "MyFUNC"}), null, SqlParserPos.ZERO, null);
            reader.lookupOperatorOverloads(myFuncIdentifier, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, SqlSyntax.FUNCTION, operatorList);
            this.checkFunctionType(2, "MyFUNC", operatorList);
            operatorList.clear();
            reader.lookupOperatorOverloads(myFuncIdentifier, SqlFunctionCategory.USER_DEFINED_FUNCTION, SqlSyntax.FUNCTION, operatorList);
            this.checkFunctionType(0, null, operatorList);
            operatorList.clear();
            SqlIdentifier anotherFuncIdentifier = new SqlIdentifier((List)Lists.newArrayList((Object[])new String[]{"MySchema", "AnotherFunc"}), null, SqlParserPos.ZERO, null);
            reader.lookupOperatorOverloads(anotherFuncIdentifier, SqlFunctionCategory.USER_DEFINED_TABLE_FUNCTION, SqlSyntax.FUNCTION, operatorList);
            this.checkFunctionType(1, "AnotherFunc", operatorList);
        }
    }
}

