/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.redis;

import java.util.List;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.DecoderException;
import org.apache.hive.druid.io.netty.handler.codec.redis.ArrayRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.ErrorRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.InlineCommandRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.IntegerRedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisArrayAggregator;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisBulkStringAggregator;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisCodecTestUtil;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisDecoder;
import org.apache.hive.druid.io.netty.handler.codec.redis.RedisMessage;
import org.apache.hive.druid.io.netty.handler.codec.redis.SimpleStringRedisMessage;
import org.apache.hive.druid.io.netty.util.IllegalReferenceCountException;
import org.apache.hive.druid.io.netty.util.ReferenceCountUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class RedisDecoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setup() throws Exception {
        this.channel = RedisDecoderTest.newChannel(false);
    }

    private static EmbeddedChannel newChannel(boolean decodeInlineCommands) {
        return new EmbeddedChannel(new ChannelHandler[]{new RedisDecoder(decodeInlineCommands), new RedisBulkStringAggregator(), new RedisArrayAggregator()});
    }

    @AfterEach
    public void teardown() throws Exception {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void splitEOLDoesNotInfiniteLoop() throws Exception {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$6\r\nfoobar\r")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\n")}));
        RedisMessage msg = (RedisMessage)this.channel.readInbound();
        Assertions.assertTrue((boolean)(msg instanceof FullBulkStringRedisMessage));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldNotDecodeInlineCommandByDefault() {
        Assertions.assertThrows(DecoderException.class, (Executable)new Executable(){

            public void execute() {
                Assertions.assertFalse((boolean)RedisDecoderTest.this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("P")}));
                Assertions.assertFalse((boolean)RedisDecoderTest.this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("I")}));
                Assertions.assertFalse((boolean)RedisDecoderTest.this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("N")}));
                Assertions.assertFalse((boolean)RedisDecoderTest.this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("G")}));
                Assertions.assertTrue((boolean)RedisDecoderTest.this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
                RedisDecoderTest.this.channel.readInbound();
            }
        });
    }

    @Test
    public void shouldDecodeInlineCommand() {
        this.channel = RedisDecoderTest.newChannel(true);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("P")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("I")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("N")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("G")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        InlineCommandRedisMessage msg = (InlineCommandRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)"PING"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeSimpleString() {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("O")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("K")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        SimpleStringRedisMessage msg = (SimpleStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)"OK"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeTwoSimpleStrings() {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("O")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("K")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n+SEC")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("OND\r\n")}));
        SimpleStringRedisMessage msg1 = (SimpleStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg1.content(), (Matcher)CoreMatchers.is((Object)"OK"));
        ReferenceCountUtil.release((Object)msg1);
        SimpleStringRedisMessage msg2 = (SimpleStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg2.content(), (Matcher)CoreMatchers.is((Object)"SECOND"));
        ReferenceCountUtil.release((Object)msg2);
    }

    @Test
    public void shouldDecodeError() {
        String content = "ERROR sample message";
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("-")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\n")}));
        ErrorRedisMessage msg = (ErrorRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg.content(), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeInteger() {
        long value = 1234L;
        byte[] content = RedisCodecTestUtil.bytesOf(value);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(":")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        IntegerRedisMessage msg = (IntegerRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg.value(), (Matcher)CoreMatchers.is((Object)value));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeBulkString() {
        String buf1 = "bulk\nst";
        String buf2 = "ring\ntest\n1234";
        byte[] content = RedisCodecTestUtil.bytesOf(buf1 + buf2);
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(content.length))}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(buf1)}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(buf2)}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg = (FullBulkStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(msg.content()), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeEmptyBulkString() {
        byte[] content = RedisCodecTestUtil.bytesOf("");
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(content.length))}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(content)}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg = (FullBulkStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)RedisCodecTestUtil.bytesOf(msg.content()), (Matcher)CoreMatchers.is((Object)content));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeNullBulkString() {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(-1))}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("$")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(Integer.toString(-1))}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("\r\n")}));
        FullBulkStringRedisMessage msg1 = (FullBulkStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg1.isNull(), (Matcher)CoreMatchers.is((Object)true));
        ReferenceCountUtil.release((Object)msg1);
        FullBulkStringRedisMessage msg2 = (FullBulkStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg2.isNull(), (Matcher)CoreMatchers.is((Object)true));
        ReferenceCountUtil.release((Object)msg2);
        FullBulkStringRedisMessage msg3 = (FullBulkStringRedisMessage)this.channel.readInbound();
        MatcherAssert.assertThat((Object)msg3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldDecodeSimpleArray() throws Exception {
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("*3\r\n")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf(":1234\r\n")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("+sim")}));
        Assertions.assertFalse((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("ple\r\n-err")}));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{RedisCodecTestUtil.byteBufOf("or\r\n")}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        MatcherAssert.assertThat((Object)msg.children().size(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)3)));
        MatcherAssert.assertThat(children.get(0), (Matcher)CoreMatchers.instanceOf(IntegerRedisMessage.class));
        MatcherAssert.assertThat((Object)((IntegerRedisMessage)children.get(0)).value(), (Matcher)CoreMatchers.is((Object)1234L));
        MatcherAssert.assertThat(children.get(1), (Matcher)CoreMatchers.instanceOf(SimpleStringRedisMessage.class));
        MatcherAssert.assertThat((Object)((SimpleStringRedisMessage)children.get(1)).content(), (Matcher)CoreMatchers.is((Object)"simple"));
        MatcherAssert.assertThat(children.get(2), (Matcher)CoreMatchers.instanceOf(ErrorRedisMessage.class));
        MatcherAssert.assertThat((Object)((ErrorRedisMessage)children.get(2)).content(), (Matcher)CoreMatchers.is((Object)"error"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldDecodeNestedArray() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n+Foo\r\n-Bar\r\n"));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        MatcherAssert.assertThat((Object)msg.children().size(), (Matcher)CoreMatchers.is((Object)2));
        ArrayRedisMessage intArray = (ArrayRedisMessage)children.get(0);
        ArrayRedisMessage strArray = (ArrayRedisMessage)children.get(1);
        MatcherAssert.assertThat((Object)intArray.children().size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(0)).value(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(1)).value(), (Matcher)CoreMatchers.is((Object)2L));
        MatcherAssert.assertThat((Object)((IntegerRedisMessage)intArray.children().get(2)).value(), (Matcher)CoreMatchers.is((Object)3L));
        MatcherAssert.assertThat((Object)strArray.children().size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat((Object)((SimpleStringRedisMessage)strArray.children().get(0)).content(), (Matcher)CoreMatchers.is((Object)"Foo"));
        MatcherAssert.assertThat((Object)((ErrorRedisMessage)strArray.children().get(1)).content(), (Matcher)CoreMatchers.is((Object)"Bar"));
        ReferenceCountUtil.release((Object)msg);
    }

    @Test
    public void shouldErrorOnDoubleReleaseArrayReferenceCounted() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n+Foo\r\n-Bar\r\n"));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        final ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        ReferenceCountUtil.release((Object)msg);
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                ReferenceCountUtil.release((Object)msg);
            }
        });
    }

    @Test
    public void shouldErrorOnReleaseArrayChildReferenceCounted() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*3\r\n:1\r\n:2\r\n:3\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("$3\r\nFoo\r\n"));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        final List children = msg.children();
        ReferenceCountUtil.release((Object)msg);
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                ReferenceCountUtil.release(children.get(1));
            }
        });
    }

    @Test
    public void shouldErrorOnReleasecontentOfArrayChildReferenceCounted() throws Exception {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("*2\r\n"));
        buf.writeBytes(RedisCodecTestUtil.byteBufOf("$3\r\nFoo\r\n$3\r\nBar\r\n"));
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{buf}));
        ArrayRedisMessage msg = (ArrayRedisMessage)this.channel.readInbound();
        List children = msg.children();
        final ByteBuf childBuf = ((FullBulkStringRedisMessage)children.get(0)).content();
        ReferenceCountUtil.release((Object)msg);
        Assertions.assertThrows(IllegalReferenceCountException.class, (Executable)new Executable(){

            public void execute() {
                ReferenceCountUtil.release((Object)childBuf);
            }
        });
    }

    @Test
    public void testPredefinedMessagesNotEqual() {
        Assertions.assertNotEquals((Object)FullBulkStringRedisMessage.EMPTY_INSTANCE, (Object)FullBulkStringRedisMessage.NULL_INSTANCE);
        Assertions.assertNotEquals((Object)FullBulkStringRedisMessage.NULL_INSTANCE, (Object)FullBulkStringRedisMessage.EMPTY_INSTANCE);
    }
}

