/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.mqtt;

import java.util.Arrays;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttMessage;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttMessageBuilders;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttSubAckMessage;
import org.apache.hive.druid.io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class MqttMessageBuildersPacketIdTest {
    static Iterable<Integer> data() {
        return Arrays.asList(1, 15, 255, 4095, 65535);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUnsubAckMessageIdAsShort(Integer id) {
        MqttUnsubAckMessage msg = MqttMessageBuilders.unsubAck().packetId(id.shortValue()).build();
        Assertions.assertEquals((int)id, (int)msg.variableHeader().messageId());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSubAckMessageIdAsShort(Integer id) {
        MqttSubAckMessage msg = MqttMessageBuilders.subAck().packetId(id.shortValue()).build();
        Assertions.assertEquals((int)id, (int)msg.variableHeader().messageId());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPubAckMessageIdAsShort(Integer id) {
        MqttMessage msg = MqttMessageBuilders.pubAck().packetId(id.shortValue()).build();
        Assertions.assertEquals((int)id, (int)((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testUnsubAckMessageIdAsInt(Integer id) {
        MqttUnsubAckMessage msg = MqttMessageBuilders.unsubAck().packetId(id.intValue()).build();
        Assertions.assertEquals((int)id, (int)msg.variableHeader().messageId());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testSubAckMessageIdAsInt(Integer id) {
        MqttSubAckMessage msg = MqttMessageBuilders.subAck().packetId(id.intValue()).build();
        Assertions.assertEquals((int)id, (int)msg.variableHeader().messageId());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testPubAckMessageIdAsInt(Integer id) {
        MqttMessage msg = MqttMessageBuilders.pubAck().packetId(id.intValue()).build();
        Assertions.assertEquals((int)id, (int)((MqttMessageIdVariableHeader)msg.variableHeader()).messageId());
    }
}

