/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.handler.codec.http2.AbstractWeightedFairQueueByteDistributorDependencyTest;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Connection;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Stream;
import org.apache.hive.druid.io.netty.handler.codec.http2.StreamByteDistributor;
import org.apache.hive.druid.io.netty.handler.codec.http2.WeightedFairQueueByteDistributor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class WeightedFairQueueByteDistributorTest
extends AbstractWeightedFairQueueByteDistributorDependencyTest {
    private static final int STREAM_A = 1;
    private static final int STREAM_B = 3;
    private static final int STREAM_C = 5;
    private static final int STREAM_D = 7;
    private static final int STREAM_E = 9;
    private static final int ALLOCATION_QUANTUM = 100;

    @BeforeEach
    public void setup() throws Http2Exception {
        MockitoAnnotations.initMocks((Object)this);
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(false)).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        this.setup(-1);
    }

    private void setup(int maxStateOnlySize) throws Http2Exception {
        this.connection = new DefaultHttp2Connection(false);
        this.distributor = maxStateOnlySize >= 0 ? new WeightedFairQueueByteDistributor(this.connection, maxStateOnlySize) : new WeightedFairQueueByteDistributor(this.connection);
        this.distributor.allocationQuantum(100);
        this.connection.local().createStream(1, false);
        this.connection.local().createStream(3, false);
        Http2Stream streamC = this.connection.local().createStream(5, false);
        Http2Stream streamD = this.connection.local().createStream(7, false);
        this.setPriority(streamC.id(), 1, 16, false);
        this.setPriority(streamD.id(), 1, 16, false);
    }

    @Test
    public void writeWithNonActiveStreamShouldNotDobuleAddToPriorityQueue() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.setPriority(3, 1, 16, true);
        this.setPriority(7, 5, 16, true);
        this.initState(3, 0L, false);
        Http2Stream streamA = this.stream(1);
        Http2Stream streamB = this.stream(3);
        Http2Stream streamC = this.stream(5);
        Http2Stream streamD = this.stream(7);
        Mockito.reset((Object[])new StreamByteDistributor.Writer[]{this.writer});
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(true)).when((Object)this.writer)).write((Http2Stream)Mockito.any(Http2Stream.class), Mockito.anyInt());
        Assertions.assertFalse((boolean)this.write(1700));
        Assertions.assertEquals((int)400, (int)this.captureWrites(streamA));
        this.verifyNeverWrite(streamB);
        Assertions.assertEquals((int)600, (int)this.captureWrites(streamC));
        Assertions.assertEquals((int)700, (int)this.captureWrites(streamD));
    }

    @Test
    public void bytesUnassignedAfterProcessing() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        Assertions.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(7, 4);
        Assertions.assertFalse((boolean)this.write(10));
        this.verifyAnyWrite(1, 1);
        this.verifyAnyWrite(3, 1);
        this.verifyAnyWrite(5, 1);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void connectionErrorForWriterException() throws Http2Exception {
        this.initState(1, 1L, true);
        this.initState(3, 2L, true);
        this.initState(5, 3L, true);
        this.initState(7, 4L, true);
        RuntimeException fakeException = new RuntimeException("Fake exception");
        ((StreamByteDistributor.Writer)Mockito.doThrow((Throwable[])new Throwable[]{fakeException}).when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                WeightedFairQueueByteDistributorTest.this.write(10);
            }
        });
        Assertions.assertFalse((boolean)Http2Exception.isStreamError((Http2Exception)e));
        Assertions.assertEquals((Object)Http2Error.INTERNAL_ERROR, (Object)e.error());
        Assertions.assertSame((Object)fakeException, (Object)e.getCause());
        this.verifyWrite(Mockito.atMost((int)1), 1, 1);
        this.verifyWrite(Mockito.atMost((int)1), 3, 2);
        this.verifyWrite(5, 3);
        this.verifyWrite(Mockito.atMost((int)1), 7, 4);
        ((StreamByteDistributor.Writer)Mockito.doAnswer(this.writeAnswer(false)).when((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(5)), Mockito.eq((int)3));
        Assertions.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 1);
        this.verifyWrite(3, 2);
        this.verifyWrite(Mockito.times((int)2), 5, 3);
        this.verifyWrite(7, 4);
    }

    @Test
    public void minChunkShouldBeAllocatedPerStream() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 1, 100, false);
        this.setPriority(7, 1, 100, false);
        this.initState(1, 100L, true);
        this.initState(3, 100L, true);
        this.initState(5, 100L, true);
        this.initState(7, 100L, true);
        int written = 300;
        Assertions.assertTrue((boolean)this.write(written));
        Assertions.assertEquals((int)100, (int)this.captureWrites(1));
        Assertions.assertEquals((int)100, (int)this.captureWrites(3));
        Assertions.assertEquals((int)100, (int)this.captureWrites(5));
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assertions.assertFalse((boolean)this.write(100));
        Assertions.assertEquals((int)100, (int)this.captureWrites(1));
        Assertions.assertEquals((int)100, (int)this.captureWrites(3));
        Assertions.assertEquals((int)100, (int)this.captureWrites(5));
        Assertions.assertEquals((int)100, (int)this.captureWrites(7));
    }

    @Test
    public void emptyFrameAtHeadIsWritten() throws Http2Exception {
        this.initState(1, 0L, true);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 10L, true);
        this.setPriority(3, 1, 16, true);
        Assertions.assertFalse((boolean)this.write(10));
        this.verifyWrite(1, 0);
        this.verifyWrite(3, 0);
        this.verifyWrite(5, 0);
        this.verifyWrite(7, 10);
    }

    @Test
    public void blockedStreamNoDataShouldSpreadDataToChildren() throws Http2Exception {
        this.blockedStreamShouldSpreadDataToChildren(false);
    }

    @Test
    public void blockedStreamWithDataAndNotAllowedToSendShouldSpreadDataToChildren() throws Http2Exception {
        this.initState(1, 0L, true, false);
        this.blockedStreamShouldSpreadDataToChildren(false);
    }

    @Test
    public void streamWithZeroFlowControlWindowAndDataShouldWriteOnlyOnce() throws Http2Exception {
        this.initState(1, 0L, true, true);
        this.blockedStreamShouldSpreadDataToChildren(true);
        this.initState(1, 0L, true, true);
        Assertions.assertFalse((boolean)this.write(1));
        this.verifyWrite(Mockito.times((int)2), 1, 0);
        Assertions.assertFalse((boolean)this.write(1));
        this.verifyWrite(Mockito.times((int)2), 1, 0);
    }

    private void blockedStreamShouldSpreadDataToChildren(boolean streamAShouldWriteZero) throws Http2Exception {
        this.initState(3, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assertions.assertTrue((boolean)this.write(10));
        if (streamAShouldWriteZero) {
            this.verifyWrite(1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        this.verifyWrite(3, 10);
        Assertions.assertTrue((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(7, 5);
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        Assertions.assertTrue((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        Assertions.assertEquals((int)10, (int)(this.captureWrites(5) + this.captureWrites(7)));
        Assertions.assertTrue((boolean)this.write(5));
        Assertions.assertFalse((boolean)this.write(5));
        if (streamAShouldWriteZero) {
            this.verifyWrite(Mockito.times((int)1), 1, 0);
        } else {
            this.verifyNeverWrite(1);
        }
        this.verifyWrite(Mockito.times((int)2), 5, 5);
        this.verifyWrite(Mockito.times((int)2), 7, 5);
    }

    @Test
    public void childrenShouldNotSendDataUntilParentBlocked() throws Http2Exception {
        this.initState(1, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assertions.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 10);
        this.verifyNeverWrite(3);
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
    }

    @Test
    public void parentShouldWaterFallDataToChildren() throws Http2Exception {
        this.initState(1, 5L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        Assertions.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 5);
        this.verifyNeverWrite(3);
        this.verifyWrite(5, 5);
        this.verifyNeverWrite(7);
        Assertions.assertFalse((boolean)this.write(15));
        this.verifyAnyWrite(1, 1);
        this.verifyNeverWrite(3);
        this.verifyWrite(Mockito.times((int)2), 5, 5);
        this.verifyWrite(7, 10);
    }

    @Test
    public void reprioritizeShouldAdjustOutboundFlow() throws Http2Exception {
        this.initState(1, 10L, true);
        this.initState(5, 10L, true);
        this.initState(7, 10L, true);
        this.setPriority(7, 0, 16, false);
        Assertions.assertTrue((boolean)this.write(10));
        this.verifyWrite(1, 10);
        this.verifyNeverWrite(3);
        this.verifyNeverWrite(5);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assertions.assertFalse((boolean)this.write(20));
        this.verifyAnyWrite(1, 1);
        this.verifyNeverWrite(3);
        this.verifyWrite(5, 10);
        this.verifyWrite(7, 10);
    }

    @Test
    public void unstreamableParentsShouldFeedHungryChildren() throws Http2Exception {
        this.setPriority(1, 0, 32, false);
        this.setPriority(3, 0, 16, false);
        this.setPriority(5, 0, 16, false);
        this.setPriority(7, 1, 16, false);
        int writableBytes = 100;
        boolean expectedUnsentAmount = true;
        this.initState(7, 101L, true);
        Assertions.assertTrue((boolean)this.write(100));
        this.verifyWrite(7, 100);
        Assertions.assertFalse((boolean)this.write(1));
        this.verifyWrite(7, 1);
    }

    @Test
    public void writeShouldPreferHighestWeight() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 0, 100, false);
        this.setPriority(7, 0, 100, false);
        this.initState(1, 1000L, true);
        this.initState(3, 1000L, true);
        this.initState(5, 1000L, true);
        this.initState(7, 1000L, true);
        this.distributor.allocationQuantum(1);
        Assertions.assertTrue((boolean)this.write(1000));
        Assertions.assertEquals((int)100, (int)this.captureWrites(1));
        Assertions.assertEquals((int)450, (int)this.captureWrites(3));
        Assertions.assertEquals((int)225, (int)this.captureWrites(5));
        Assertions.assertEquals((int)225, (int)this.captureWrites(7));
    }

    @Test
    public void writeShouldFavorPriority() throws Http2Exception {
        this.setPriority(1, 0, 50, false);
        this.setPriority(3, 0, 200, false);
        this.setPriority(5, 0, 100, false);
        this.setPriority(7, 0, 100, false);
        this.initState(1, 1000L, true);
        this.initState(3, 1000L, true);
        this.initState(5, 1000L, false);
        this.initState(7, 1000L, false);
        this.distributor.allocationQuantum(1);
        Assertions.assertTrue((boolean)this.write(100));
        Assertions.assertEquals((int)20, (int)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)20), 1, 1);
        Assertions.assertEquals((int)80, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)0), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assertions.assertTrue((boolean)this.write(100));
        Assertions.assertEquals((int)40, (int)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)40), 1, 1);
        Assertions.assertEquals((int)160, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assertions.assertTrue((boolean)this.write(1050));
        Assertions.assertEquals((int)250, (int)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)250), 1, 1);
        Assertions.assertEquals((int)1000, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)2), 3, 1);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assertions.assertFalse((boolean)this.write(750));
        Assertions.assertEquals((int)1000, (int)this.captureWrites(1));
        this.verifyWrite(Mockito.times((int)1), 1, 750);
        Assertions.assertEquals((int)1000, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)0), 3, 0);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
    }

    @Test
    public void samePriorityShouldDistributeBasedOnData() throws Http2Exception {
        this.setPriority(1, 0, 16, false);
        this.setPriority(3, 0, 16, false);
        this.setPriority(5, 0, 16, false);
        this.setPriority(7, 0, 16, false);
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 0L, true);
        this.initState(7, 700L, true);
        this.distributor.allocationQuantum(1);
        Assertions.assertTrue((boolean)this.write(999));
        Assertions.assertEquals((int)333, (int)this.captureWrites(1));
        Assertions.assertEquals((int)333, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.times((int)1), 5, 0);
        Assertions.assertEquals((int)333, (int)this.captureWrites(7));
    }

    @Test
    public void zeroDistributeShouldWriteAllZeroFrames() throws Http2Exception {
        this.initState(1, 400L, false);
        this.initState(3, 0L, true);
        this.initState(5, 0L, true);
        this.initState(7, 0L, true);
        this.setPriority(3, 1, 16, true);
        Assertions.assertFalse((boolean)this.write(0));
        this.verifyNeverWrite(1);
        this.verifyWrite(3, 0);
        this.verifyAnyWrite(3, 1);
        this.verifyWrite(5, 0);
        this.verifyAnyWrite(5, 1);
        this.verifyWrite(7, 0);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void nonZeroDistributeShouldWriteAllZeroFramesIfAllEligibleDataIsWritten() throws Http2Exception {
        this.initState(1, 400L, false);
        this.initState(3, 100L, true);
        this.initState(5, 0L, true);
        this.initState(7, 0L, true);
        this.setPriority(3, 1, 16, true);
        Assertions.assertFalse((boolean)this.write(100));
        this.verifyNeverWrite(1);
        this.verifyWrite(3, 100);
        this.verifyAnyWrite(3, 1);
        this.verifyWrite(5, 0);
        this.verifyAnyWrite(5, 1);
        this.verifyWrite(7, 0);
        this.verifyAnyWrite(7, 1);
    }

    @Test
    public void bytesDistributedWithRestructureShouldBeCorrect() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.setPriority(3, 1, 16, true);
        Assertions.assertTrue((boolean)this.write(500));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        this.verifyWrite(3, 100);
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        Assertions.assertTrue((boolean)this.write(400));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assertions.assertFalse((boolean)this.write(1300));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        Assertions.assertEquals((int)600, (int)this.captureWrites(5));
        Assertions.assertEquals((int)700, (int)this.captureWrites(7));
    }

    @Test
    public void bytesDistributedWithAdditionShouldBeCorrect() throws Http2Exception {
        Http2Stream streamE = this.connection.local().createStream(9, false);
        this.setPriority(streamE.id(), 1, 16, true);
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.initState(9, 900L, true);
        Assertions.assertTrue((boolean)this.write(900));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        this.verifyNeverWrite(5);
        this.verifyNeverWrite(7);
        this.verifyWrite(Mockito.atMost((int)1), 9, 0);
        Assertions.assertTrue((boolean)this.write(900));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        this.verifyWrite(Mockito.atMost((int)1), 5, 0);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assertions.assertEquals((int)900, (int)this.captureWrites(9));
        Assertions.assertFalse((boolean)this.write(1301));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        Assertions.assertEquals((int)600, (int)this.captureWrites(5));
        Assertions.assertEquals((int)700, (int)this.captureWrites(7));
        Assertions.assertEquals((int)900, (int)this.captureWrites(9));
    }

    @Test
    public void bytesDistributedShouldBeCorrectWithInternalStreamClose() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.stream(1).close();
        Assertions.assertTrue((boolean)this.write(500));
        this.verifyNeverWrite(1);
        Assertions.assertEquals((int)500, (int)(this.captureWrites(3) + this.captureWrites(5) + this.captureWrites(7)));
        Assertions.assertFalse((boolean)this.write(1300));
        this.verifyNeverWrite(1);
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        Assertions.assertEquals((int)600, (int)this.captureWrites(5));
        Assertions.assertEquals((int)700, (int)this.captureWrites(7));
    }

    @Test
    public void bytesDistributedShouldBeCorrectWithLeafStreamClose() throws Http2Exception {
        this.initState(1, 400L, true);
        this.initState(3, 500L, true);
        this.initState(5, 600L, true);
        this.initState(7, 700L, true);
        this.stream(5).close();
        Assertions.assertTrue((boolean)this.write(900));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        this.verifyNeverWrite(5);
        this.verifyWrite(Mockito.atMost((int)1), 7, 0);
        Assertions.assertFalse((boolean)this.write(700));
        Assertions.assertEquals((int)400, (int)this.captureWrites(1));
        Assertions.assertEquals((int)500, (int)this.captureWrites(3));
        this.verifyNeverWrite(5);
        Assertions.assertEquals((int)700, (int)this.captureWrites(7));
    }

    @Test
    public void activeStreamDependentOnNewNonActiveStreamGetsQuantum() throws Http2Exception {
        this.setup(0);
        this.initState(7, 700L, true);
        this.setPriority(7, 9, 16, true);
        Assertions.assertFalse((boolean)this.write(700));
        Assertions.assertEquals((int)700, (int)this.captureWrites(7));
    }

    @Test
    public void streamWindowLargerThanIntDoesNotInfiniteLoop() throws Http2Exception {
        this.initState(1, 0x80000000L, true, true);
        Assertions.assertTrue((boolean)this.write(Integer.MAX_VALUE));
        this.verifyWrite(1, Integer.MAX_VALUE);
        Assertions.assertFalse((boolean)this.write(1));
        this.verifyWrite(1, 1);
    }

    private boolean write(int numBytes) throws Http2Exception {
        return this.distributor.distribute(numBytes, this.writer);
    }

    private void verifyWrite(int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private void verifyWrite(VerificationMode mode, int streamId, int numBytes) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)mode)).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.eq((int)numBytes));
    }

    private void verifyAnyWrite(int streamId, int times) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.times((int)times))).write((Http2Stream)Mockito.same((Object)this.stream(streamId)), Mockito.anyInt());
    }

    private void verifyNeverWrite(int streamId) {
        this.verifyNeverWrite(this.stream(streamId));
    }

    private void verifyNeverWrite(Http2Stream stream) {
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.never())).write((Http2Stream)Mockito.same((Object)stream), Mockito.anyInt());
    }

    private int captureWrites(int streamId) {
        return this.captureWrites(this.stream(streamId));
    }

    private int captureWrites(Http2Stream stream) {
        ArgumentCaptor captor = ArgumentCaptor.forClass(Integer.class);
        ((StreamByteDistributor.Writer)Mockito.verify((Object)this.writer, (VerificationMode)Mockito.atLeastOnce())).write((Http2Stream)Mockito.same((Object)stream), ((Integer)captor.capture()).intValue());
        int total = 0;
        for (Integer x : captor.getAllValues()) {
            total += x.intValue();
        }
        return total;
    }
}

