/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.hive.druid.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpMethod;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpRequest;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpVersion;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameAdapter;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2FrameListener;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexCodecBuilder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2MultiplexHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class Http2ClientUpgradeCodecTest {
    @Test
    public void testUpgradeToHttp2ConnectionHandler() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade(new Http2ConnectionHandlerBuilder().server(false).frameListener((Http2FrameListener)new Http2FrameAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodec() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2FrameCodecBuilder.forClient().build(), null);
    }

    @Test
    public void testUpgradeToHttp2MultiplexCodec() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2MultiplexCodecBuilder.forClient((ChannelHandler)new HttpInboundHandler()).withUpgradeStreamHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).build(), null);
    }

    @Test
    public void testUpgradeToHttp2FrameCodecWithMultiplexer() throws Exception {
        Http2ClientUpgradeCodecTest.testUpgrade((Http2ConnectionHandler)Http2FrameCodecBuilder.forClient().build(), new Http2MultiplexHandler((ChannelHandler)new HttpInboundHandler(), (ChannelHandler)new HttpInboundHandler()));
    }

    private static void testUpgrade(Http2ConnectionHandler handler, Http2MultiplexHandler multiplexer) throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.OPTIONS, "*");
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ChannelHandlerContext ctx = channel.pipeline().firstContext();
        Http2ClientUpgradeCodec codec = multiplexer == null ? new Http2ClientUpgradeCodec("connectionHandler", handler) : new Http2ClientUpgradeCodec("connectionHandler", handler, multiplexer);
        codec.setUpgradeHeaders(ctx, (HttpRequest)request);
        channel.flush();
        codec.upgradeTo(ctx, null);
        Assertions.assertNotNull((Object)channel.pipeline().get("connectionHandler"));
        if (multiplexer != null) {
            Assertions.assertNotNull((Object)channel.pipeline().get(Http2MultiplexHandler.class));
        }
        Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
    }

    @ChannelHandler.Sharable
    private static final class HttpInboundHandler
    extends ChannelInboundHandlerAdapter {
        private HttpInboundHandler() {
        }
    }
}

