/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import org.apache.hive.druid.io.netty.handler.codec.http2.HpackStaticTable;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HpackStaticTableTest {
    @Test
    public void testEmptyHeaderName() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndex((CharSequence)""));
    }

    @Test
    public void testMissingHeaderName() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndex((CharSequence)"missing"));
    }

    @Test
    public void testExistingHeaderName() {
        Assertions.assertEquals((int)6, (int)HpackStaticTable.getIndex((CharSequence)":scheme"));
    }

    @Test
    public void testMissingHeaderNameAndValue() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndexInsensitive((CharSequence)"missing", (CharSequence)"value"));
    }

    @Test
    public void testMissingHeaderNameButValueExists() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndexInsensitive((CharSequence)"missing", (CharSequence)"https"));
    }

    @Test
    public void testExistingHeaderNameAndValueFirstMatch() {
        Assertions.assertEquals((int)6, (int)HpackStaticTable.getIndexInsensitive((CharSequence)":scheme", (CharSequence)"http"));
    }

    @Test
    public void testExistingHeaderNameAndValueSecondMatch() {
        Assertions.assertEquals((int)7, (int)HpackStaticTable.getIndexInsensitive((CharSequence)AsciiString.cached((String)":scheme"), (CharSequence)AsciiString.cached((String)"https")));
    }

    @Test
    public void testExistingHeaderNameAndEmptyValueMismatch() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndexInsensitive((CharSequence)":scheme", (CharSequence)""));
    }

    @Test
    public void testExistingHeaderNameAndEmptyValueMatch() {
        Assertions.assertEquals((int)27, (int)HpackStaticTable.getIndexInsensitive((CharSequence)"content-language", (CharSequence)""));
    }

    @Test
    public void testExistingHeaderNameButMissingValue() {
        Assertions.assertEquals((int)-1, (int)HpackStaticTable.getIndexInsensitive((CharSequence)":scheme", (CharSequence)"missing"));
    }
}

