/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.handler.codec.http2;

import java.lang.reflect.Method;
import org.apache.hive.druid.io.netty.buffer.ByteBuf;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.handler.codec.http2.DefaultHttp2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackDecoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.HpackEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Error;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Exception;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.druid.io.netty.handler.codec.http2.Http2HeadersEncoder;
import org.apache.hive.druid.io.netty.handler.codec.http2.InOrderHttp2Headers;
import org.apache.hive.druid.io.netty.util.AsciiString;
import org.apache.hive.druid.io.netty.util.internal.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.mockito.invocation.Invocation;
import org.mockito.verification.VerificationMode;

public class HpackDecoderTest {
    private HpackDecoder hpackDecoder;
    private Http2Headers mockHeaders;

    private static String hex(String s) {
        return StringUtil.toHexString((byte[])s.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(String encoded) throws Http2Exception {
        byte[] b = StringUtil.decodeHexDump((CharSequence)encoded);
        ByteBuf in = Unpooled.wrappedBuffer((byte[])b);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
        }
        finally {
            in.release();
        }
    }

    @BeforeEach
    public void setUp() {
        this.hpackDecoder = new HpackDecoder(8192L);
        this.mockHeaders = (Http2Headers)Mockito.mock(Http2Headers.class);
    }

    @Test
    public void testDecodeULE128IntMax() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 7};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertEquals((int)Integer.MAX_VALUE, (int)HpackDecoder.decodeULE128((ByteBuf)in, (int)0));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeULE128IntOverflow1() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 7};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoder.decodeULE128((ByteBuf)in, (int)1);
                }
            });
        }
        finally {
            Assertions.assertEquals((int)readerIndex, (int)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeULE128IntOverflow2() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, 8};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoder.decodeULE128((ByteBuf)in, (int)0);
                }
            });
        }
        finally {
            Assertions.assertEquals((int)readerIndex, (int)in.readerIndex());
            in.release();
        }
    }

    @Test
    public void testDecodeULE128LongMax() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertEquals((long)Long.MAX_VALUE, (long)HpackDecoder.decodeULE128((ByteBuf)in, (long)0L));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeULE128LongOverflow1() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoder.decodeULE128((ByteBuf)in, (long)0L);
                }
            });
        }
        finally {
            Assertions.assertEquals((int)readerIndex, (int)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeULE128LongOverflow2() throws Http2Exception {
        byte[] input = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, 127};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        int readerIndex = in.readerIndex();
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoder.decodeULE128((ByteBuf)in, (long)1L);
                }
            });
        }
        finally {
            Assertions.assertEquals((int)readerIndex, (int)in.readerIndex());
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetTableSizeWithMaxUnsigned32BitValueSucceeds() throws Http2Exception {
        byte[] input = new byte[]{63, -1, -1, -1, -1, 14};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            long expectedHeaderSize = 4026531870L;
            this.hpackDecoder.setMaxHeaderTableSize(4026531870L);
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
            Assertions.assertEquals((long)4026531870L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testSetTableSizeOverLimitFails() throws Http2Exception {
        byte[] input = new byte[]{63, -1, -1, -1, -1, 14};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.setMaxHeaderTableSize(4026531869L);
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testLiteralHuffmanEncodedWithEmptyNameAndValue() throws Http2Exception {
        byte[] input = new byte[]{0, -128, 0};
        ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            this.hpackDecoder.decode(0, in, this.mockHeaders, true);
            ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.EMPTY_STRING);
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testLiteralHuffmanEncodedWithPaddingGreaterThan7Throws() throws Http2Exception {
        byte[] input = new byte[]{0, -127, -1};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testLiteralHuffmanEncodedWithDecodingEOSThrows() throws Http2Exception {
        byte[] input = new byte[]{0, -124, -1, -1, -1, -1};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testLiteralHuffmanEncodedWithPaddingNotCorrespondingToMSBThrows() throws Http2Exception {
        byte[] input = new byte[]{0, -127, 0};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testIncompleteIndex() throws Http2Exception {
        byte[] compressed = StringUtil.decodeHexDump((CharSequence)"FFF0");
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])compressed);
        try {
            Assertions.assertEquals((int)2, (int)in.readableBytes());
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testUnusedIndex() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("80");
            }
        });
    }

    @Test
    public void testIllegalIndex() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("FF00");
            }
        });
    }

    @Test
    public void testInsidiousIndex() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("FF8080808007");
            }
        });
    }

    @Test
    public void testDynamicTableSizeUpdate() throws Http2Exception {
        this.decode("20");
        Assertions.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("3FE11F");
        Assertions.assertEquals((long)4096L, (long)this.hpackDecoder.getMaxHeaderTableSize());
    }

    @Test
    public void testDynamicTableSizeUpdateRequired() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(32L);
        this.decode("3F00");
        Assertions.assertEquals((long)31L, (long)this.hpackDecoder.getMaxHeaderTableSize());
    }

    @Test
    public void testIllegalDynamicTableSizeUpdate() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("3FE21F");
            }
        });
    }

    @Test
    public void testInsidiousMaxDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(Integer.MAX_VALUE);
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("3FE1FFFFFF07");
            }
        });
    }

    @Test
    public void testMaxValidDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(Integer.MAX_VALUE);
        String baseValue = "3FE1FFFFFF0";
        for (int i = 0; i < 7; ++i) {
            this.decode(baseValue + i);
        }
    }

    @Test
    public void testReduceMaxDynamicTableSize() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assertions.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        this.decode("2081");
    }

    @Test
    public void testTooLargeDynamicTableSizeUpdate() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assertions.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("21");
            }
        });
    }

    @Test
    public void testMissingDynamicTableSizeUpdate() throws Http2Exception {
        this.hpackDecoder.setMaxHeaderTableSize(0L);
        Assertions.assertEquals((long)0L, (long)this.hpackDecoder.getMaxHeaderTableSize());
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("81");
            }
        });
    }

    @Test
    public void testDynamicTableSizeUpdateAfterTheBeginingOfTheBlock() throws Http2Exception {
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("8120");
            }
        });
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode("813FE11F");
            }
        });
    }

    @Test
    public void testLiteralWithIncrementalIndexingWithEmptyName() throws Http2Exception {
        this.decode("400005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test
    public void testLiteralWithIncrementalIndexingCompleteEviction() throws Http2Exception {
        this.decode("4004" + HpackDecoderTest.hex("name") + "05" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders)).add((Object)AsciiString.of((CharSequence)"name"), (Object)AsciiString.of((CharSequence)"value"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
        Mockito.reset((Object[])new Http2Headers[]{this.mockHeaders});
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4096; ++i) {
            sb.append('a');
        }
        String value = sb.toString();
        sb = new StringBuilder();
        sb.append("417F811F");
        for (int i = 0; i < 4096; ++i) {
            sb.append("61");
        }
        this.decode(sb.toString());
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders)).add((Object)AsciiString.of((CharSequence)":authority"), (Object)AsciiString.of((CharSequence)value));
        MockingDetails details = Mockito.mockingDetails((Object)this.mockHeaders);
        for (Invocation invocation : details.getInvocations()) {
            Method method = invocation.getMethod();
            if ("authority".equals(method.getName()) && invocation.getArguments().length == 0) {
                invocation.markVerified();
                continue;
            }
            if (!"contains".equals(method.getName()) || invocation.getArguments().length != 1 || !invocation.getArgument(0).equals(AsciiString.of((CharSequence)":authority"))) continue;
            invocation.markVerified();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
        Mockito.reset((Object[])new Http2Headers[]{this.mockHeaders});
        this.decode("4004" + HpackDecoderTest.hex("name") + "05" + HpackDecoderTest.hex("value") + "BE");
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)2))).add((Object)AsciiString.of((CharSequence)"name"), (Object)AsciiString.of((CharSequence)"value"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockHeaders});
    }

    @Test
    public void testLiteralWithIncrementalIndexingWithLargeValue() throws Http2Exception {
        final StringBuilder sb = new StringBuilder();
        sb.append("4004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode(sb.toString());
            }
        });
    }

    @Test
    public void testLiteralWithoutIndexingWithEmptyName() throws Http2Exception {
        this.decode("000005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test
    public void testLiteralWithoutIndexingWithLargeName() throws Http2Exception {
        final StringBuilder sb = new StringBuilder();
        sb.append("007F817F");
        for (int i = 0; i < 16384; ++i) {
            sb.append("61");
        }
        sb.append("00");
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode(sb.toString());
            }
        });
    }

    @Test
    public void testLiteralWithoutIndexingWithLargeValue() throws Http2Exception {
        final StringBuilder sb = new StringBuilder();
        sb.append("0004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode(sb.toString());
            }
        });
    }

    @Test
    public void testLiteralNeverIndexedWithEmptyName() throws Http2Exception {
        this.decode("100005" + HpackDecoderTest.hex("value"));
        ((Http2Headers)Mockito.verify((Object)this.mockHeaders, (VerificationMode)Mockito.times((int)1))).add((Object)AsciiString.EMPTY_STRING, (Object)AsciiString.of((CharSequence)"value"));
    }

    @Test
    public void testLiteralNeverIndexedWithLargeName() throws Http2Exception {
        final StringBuilder sb = new StringBuilder();
        sb.append("107F817F");
        for (int i = 0; i < 16384; ++i) {
            sb.append("61");
        }
        sb.append("00");
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode(sb.toString());
            }
        });
    }

    @Test
    public void testLiteralNeverIndexedWithLargeValue() throws Http2Exception {
        final StringBuilder sb = new StringBuilder();
        sb.append("1004");
        sb.append(HpackDecoderTest.hex("name"));
        sb.append("7F813F");
        for (int i = 0; i < 8192; ++i) {
            sb.append("61");
        }
        Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                HpackDecoderTest.this.decode(sb.toString());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeLargerThanMaxHeaderListSizeUpdatesDynamicTable() throws Http2Exception {
        final ByteBuf in = Unpooled.buffer((int)300);
        try {
            this.hpackDecoder.setMaxHeaderListSize(200L);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)"test_1", (Object)"1");
            toEncode.add((Object)"test_2", (Object)"2");
            toEncode.add((Object)"long", (Object)String.format("%0100d", 0).replace('0', 'A'));
            toEncode.add((Object)"test_3", (Object)"3");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in, this.val$decoded, true);
                }
            });
            in.clear();
            in.writeByte(190);
            DefaultHttp2Headers decoded2 = new DefaultHttp2Headers();
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded2, true);
            DefaultHttp2Headers golden = new DefaultHttp2Headers();
            golden.add((Object)"test_3", (Object)"3");
            Assertions.assertEquals((Object)golden, (Object)decoded2);
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDecodeCountsNamesOnlyOnce() throws Http2Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            this.hpackDecoder.setMaxHeaderListSize(3500L);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)String.format("%03000d", 0).replace('0', 'f'), (Object)"value");
            toEncode.add((Object)"accept", (Object)"value");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, true);
            Assertions.assertEquals((int)2, (int)decoded.size());
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAccountForHeaderOverhead() throws Exception {
        final ByteBuf in = Unpooled.buffer((int)100);
        try {
            String headerName = "12345";
            String headerValue = "56789";
            long headerSize = headerName.length() + headerValue.length();
            this.hpackDecoder.setMaxHeaderListSize(headerSize);
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)headerName, (Object)headerValue);
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            MatcherAssert.assertThat((Object)this.hpackDecoder.getMaxHeaderListSize(), (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(headerSize))));
            Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in, this.val$decoded, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    @Test
    public void testIncompleteHeaderFieldRepresentation() throws Http2Exception {
        byte[] input = new byte[]{64};
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])input);
        try {
            Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(0, in, HpackDecoderTest.this.mockHeaders, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void unknownPseudoHeader() throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers(false);
            toEncode.add((Object)":test", (Object)"1");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers(true);
            Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in, this.val$decoded, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void disableHeaderValidation() throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers(false);
            toEncode.add((Object)":test", (Object)"1");
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)":method", (Object)"GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers(false);
            this.hpackDecoder.decode(1, in, (Http2Headers)decoded, false);
            MatcherAssert.assertThat((Object)((CharSequence)decoded.valueIterator((CharSequence)":test").next()).toString(), (Matcher)CoreMatchers.is((Object)"1"));
            MatcherAssert.assertThat((Object)decoded.status().toString(), (Matcher)CoreMatchers.is((Object)"200"));
            MatcherAssert.assertThat((Object)decoded.method().toString(), (Matcher)CoreMatchers.is((Object)"GET"));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void requestPseudoHeaderInResponse() throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)":method", (Object)"GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in, this.val$decoded, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void responsePseudoHeaderInRequest() throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":method", (Object)"GET");
            toEncode.add((Object)":status", (Object)"200");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in, this.val$decoded, true);
                }
            });
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void pseudoHeaderAfterRegularHeader() throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            InOrderHttp2Headers toEncode = new InOrderHttp2Headers();
            toEncode.add("test", "1");
            toEncode.add(":method", "GET");
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Http2Exception.StreamException e = (Http2Exception.StreamException)Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(3, in, this.val$decoded, true);
                }
            });
            MatcherAssert.assertThat((Object)e.streamId(), (Matcher)CoreMatchers.is((Object)3));
            MatcherAssert.assertThat((Object)e.error(), (Matcher)CoreMatchers.is((Object)Http2Error.PROTOCOL_ERROR));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{displayName} [{index}] name={0} value={1}")
    @CsvSource(value={"upgrade,protocol1", "connection,close", "keep-alive,timeout=5", "proxy-connection,close", "transfer-encoding,chunked", "te,something-else"})
    public void receivedConnectionHeader(String name, String value) throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            InOrderHttp2Headers toEncode = new InOrderHttp2Headers();
            toEncode.add(":method", "GET");
            toEncode.add(name, value);
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Http2Exception.StreamException e = (Http2Exception.StreamException)Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(3, in, this.val$decoded, true);
                }
            });
            MatcherAssert.assertThat((Object)e.streamId(), (Matcher)CoreMatchers.is((Object)3));
            MatcherAssert.assertThat((Object)e.error(), (Matcher)CoreMatchers.is((Object)Http2Error.PROTOCOL_ERROR));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void failedValidationDoesntCorruptHpack() throws Exception {
        final ByteBuf in1 = Unpooled.buffer((int)200);
        ByteBuf in2 = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            DefaultHttp2Headers toEncode = new DefaultHttp2Headers();
            toEncode.add((Object)":method", (Object)"GET");
            toEncode.add((Object)":status", (Object)"200");
            toEncode.add((Object)"foo", (Object)"bar");
            hpackEncoder.encodeHeaders(1, in1, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Http2Exception.StreamException expected = (Http2Exception.StreamException)Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(1, in1, this.val$decoded, true);
                }
            });
            Assertions.assertEquals((int)1, (int)expected.streamId());
            decoded.clear();
            hpackEncoder.encodeHeaders(1, in2, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            this.hpackDecoder.decode(1, in2, (Http2Headers)decoded, false);
            Assertions.assertEquals((int)3, (int)decoded.size());
            Assertions.assertEquals((Object)"GET", (Object)decoded.method().toString());
            Assertions.assertEquals((Object)"200", (Object)decoded.status().toString());
            Assertions.assertEquals((Object)"bar", (Object)((CharSequence)decoded.get((Object)"foo")).toString());
        }
        finally {
            in1.release();
            in2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @CsvSource(value={":method,''", ":scheme,''", ":authority,''", ":path,''"})
    public void testPseudoHeaderEmptyValidationEnabled(String name, String value) throws Exception {
        final ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            InOrderHttp2Headers toEncode = new InOrderHttp2Headers();
            toEncode.add(name, value);
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers();
            Http2Exception.StreamException e = (Http2Exception.StreamException)Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable((Http2Headers)decoded){
                final /* synthetic */ Http2Headers val$decoded;
                {
                    this.val$decoded = http2Headers;
                }

                public void execute() throws Throwable {
                    HpackDecoderTest.this.hpackDecoder.decode(3, in, this.val$decoded, true);
                }
            });
            MatcherAssert.assertThat((Object)e.streamId(), (Matcher)CoreMatchers.is((Object)3));
            MatcherAssert.assertThat((Object)e.error(), (Matcher)CoreMatchers.is((Object)Http2Error.PROTOCOL_ERROR));
        }
        finally {
            in.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @CsvSource(value={":method,''", ":scheme,''", ":authority,''", ":path,''"})
    public void testPseudoHeaderEmptyValidationDisabled(String name, String value) throws Exception {
        ByteBuf in = Unpooled.buffer((int)200);
        try {
            HpackEncoder hpackEncoder = new HpackEncoder(true);
            InOrderHttp2Headers toEncode = new InOrderHttp2Headers();
            toEncode.add(name, value);
            hpackEncoder.encodeHeaders(1, in, (Http2Headers)toEncode, Http2HeadersEncoder.NEVER_SENSITIVE);
            DefaultHttp2Headers decoded = new DefaultHttp2Headers(false);
            this.hpackDecoder.decode(3, in, (Http2Headers)decoded, true);
            Assertions.assertSame((Object)AsciiString.EMPTY_STRING, (Object)decoded.get((Object)name));
        }
        finally {
            in.release();
        }
    }
}

