/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.apache.hive.druid.io.netty.bootstrap.Bootstrap;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.channel.ChannelFactory;
import org.apache.hive.druid.io.netty.channel.ChannelOption;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueDatagramChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueDomainDatagramChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueSocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.InternetProtocolFamily;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hive.druid.io.netty.channel.unix.DomainSocketAddress;
import org.apache.hive.druid.io.netty.channel.unix.tests.UnixTestUtils;
import org.apache.hive.druid.io.netty.testsuite.transport.TestsuitePermutation;
import org.apache.hive.druid.io.netty.testsuite.transport.socket.SocketTestPermutation;
import org.apache.hive.druid.io.netty.util.concurrent.DefaultThreadFactory;

class KQueueSocketTestPermutation
extends SocketTestPermutation {
    static final KQueueSocketTestPermutation INSTANCE = new KQueueSocketTestPermutation();
    static final EventLoopGroup KQUEUE_BOSS_GROUP = new KQueueEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-KQueue-boss", true));
    static final EventLoopGroup KQUEUE_WORKER_GROUP = new KQueueEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-KQueue-worker", true));

    KQueueSocketTestPermutation() {
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List list = this.combo(this.serverSocket(), this.clientSocketWithFastOpen());
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_BOSS_GROUP, KQUEUE_WORKER_GROUP).channel(KQueueServerSocketChannel.class);
            }
        });
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                ServerBootstrap serverBootstrap = (ServerBootstrap)new ServerBootstrap().group(KQUEUE_BOSS_GROUP, KQUEUE_WORKER_GROUP).channel(KQueueServerSocketChannel.class);
                serverBootstrap.option(ChannelOption.TCP_FASTOPEN, (Object)1);
                return serverBootstrap;
            }
        });
        toReturn.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQueueSocketTestPermutation.this.nioBossGroup, KQueueSocketTestPermutation.this.nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> toReturn = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        toReturn.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueSocketChannel.class);
            }
        });
        toReturn.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        });
        return toReturn;
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocketWithFastOpen() {
        List<TestsuitePermutation.BootstrapFactory<Bootstrap>> factories = this.clientSocket();
        int insertIndex = factories.size() - 1;
        factories.add(insertIndex, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueSocketChannel.class)).option(ChannelOption.TCP_FASTOPEN_CONNECT, (Object)true);
            }
        });
        return factories;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram(final InternetProtocolFamily family) {
        List<TestsuitePermutation.BootstrapFactory> bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQueueSocketTestPermutation.this.nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(family);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDatagramChannel.class);
            }
        });
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> domainSocket() {
        return this.combo(this.serverDomainSocket(), this.clientDomainSocket());
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(KQUEUE_BOSS_GROUP, KQUEUE_WORKER_GROUP).channel(KQueueServerDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientDomainSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDomainSocketChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> datagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDatagramChannel.class);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> domainDatagram() {
        return this.combo(this.domainDatagramSocket(), this.domainDatagramSocket());
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> domainDatagramSocket() {
        return Collections.singletonList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(KQUEUE_WORKER_GROUP)).channel(KQueueDomainDatagramChannel.class);
            }
        });
    }

    public static DomainSocketAddress newSocketAddress() {
        return UnixTestUtils.newDomainSocketAddress();
    }
}

