/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.hive.druid.io.netty.bootstrap.ServerBootstrap;
import org.apache.hive.druid.io.netty.channel.ChannelHandler;
import org.apache.hive.druid.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.AcceptFilter;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueServerSocketChannel;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class KQueueServerSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static KQueueServerSocketChannel ch;

    @BeforeAll
    public static void before() {
        group = new KQueueEventLoopGroup(1);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ch = (KQueueServerSocketChannel)((ServerBootstrap)bootstrap.group(group).channel(KQueueServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterAll
    public static void after() {
        try {
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testReusePort() {
        ch.config().setReusePort(false);
        Assertions.assertFalse((boolean)ch.config().isReusePort());
        ch.config().setReusePort(true);
        Assertions.assertTrue((boolean)ch.config().isReusePort());
    }

    @Test
    public void testAcceptFilter() {
        AcceptFilter currentFilter = ch.config().getAcceptFilter();
        Assumptions.assumeTrue((currentFilter != AcceptFilter.PLATFORM_UNSUPPORTED ? 1 : 0) != 0);
        AcceptFilter af = new AcceptFilter("test", "foo");
        ch.config().setAcceptFilter(af);
        Assertions.assertEquals((Object)af, (Object)ch.config().getAcceptFilter());
    }

    @Test
    public void testOptionsDoesNotThrow() {
        Assertions.assertFalse((boolean)ch.config().getOptions().isEmpty());
    }
}

