/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.channel.kqueue;

import java.util.concurrent.TimeUnit;
import org.apache.hive.druid.io.netty.channel.EventLoop;
import org.apache.hive.druid.io.netty.channel.EventLoopGroup;
import org.apache.hive.druid.io.netty.channel.ServerChannel;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueEventLoopGroup;
import org.apache.hive.druid.io.netty.channel.kqueue.KQueueServerSocketChannel;
import org.apache.hive.druid.io.netty.channel.socket.ServerSocketChannel;
import org.apache.hive.druid.io.netty.testsuite.transport.AbstractSingleThreadEventLoopTest;
import org.apache.hive.druid.io.netty.util.concurrent.ScheduledFuture;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KQueueEventLoopTest
extends AbstractSingleThreadEventLoopTest {
    protected boolean supportsChannelIteration() {
        return true;
    }

    protected EventLoopGroup newEventLoopGroup() {
        return new KQueueEventLoopGroup();
    }

    protected ServerSocketChannel newChannel() {
        return new KQueueServerSocketChannel();
    }

    protected Class<? extends ServerChannel> serverChannelClass() {
        return KQueueServerSocketChannel.class;
    }

    @Test
    public void testScheduleBigDelayNotOverflow() {
        KQueueEventLoopGroup group = new KQueueEventLoopGroup(1);
        EventLoop el = group.next();
        ScheduledFuture future = el.schedule(new Runnable(){

            @Override
            public void run() {
            }
        }, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)future.awaitUninterruptibly(1000L));
        Assertions.assertTrue((boolean)future.cancel(true));
        group.shutdownGracefully();
    }
}

