/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.timeline;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.ImmutablePartitionHolder;
import org.apache.hive.druid.io.druid.timeline.partition.IntegerPartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionHolder;
import org.apache.hive.druid.io.druid.timeline.partition.SingleElementPartitionChunk;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VersionedIntervalTimelineTest {
    VersionedIntervalTimeline<String, Integer> timeline;

    @Before
    public void setUp() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.add("2011-04-06/2011-04-09", "3", (Integer)4);
        this.add("2011-04-01/2011-04-02", "3", (Integer)5);
        this.add("2011-05-01/2011-05-02", "1", (Integer)6);
        this.add("2011-05-01/2011-05-05", "2", (Integer)7);
        this.add("2011-05-03/2011-05-04", "3", (Integer)8);
        this.add("2011-05-01/2011-05-10", "4", (Integer)9);
        this.add("2011-10-01/2011-10-02", "1", (Integer)1);
        this.add("2011-10-02/2011-10-03", "3", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)20));
        this.add("2011-10-02/2011-10-03", "3", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)10, null, (int)1, (Object)21));
        this.add("2011-10-03/2011-10-04", "3", (Integer)3);
        this.add("2011-10-04/2011-10-05", "4", (Integer)4);
        this.add("2011-10-05/2011-10-06", "5", (Integer)5);
    }

    @Test
    public void testApril() throws Exception {
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-06", "2", 1), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril2() throws Exception {
        Assert.assertEquals(this.makeSingle(1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle(1)));
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril3() throws Exception {
        Assert.assertEquals(this.makeSingle(1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle(1)));
        Assert.assertEquals(this.makeSingle(2), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"1", this.makeSingle(2)));
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-09")));
    }

    @Test
    public void testApril4() throws Exception {
        Assert.assertEquals(this.makeSingle(1), (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"2", this.makeSingle(1)));
        this.assertValues(Arrays.asList(this.createExpected("2011-04-01/2011-04-02", "3", 5), this.createExpected("2011-04-02/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-05", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-05")));
        this.assertValues(Arrays.asList(this.createExpected("2011-04-02T18/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-04T01", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-04-02T18/2011-04-04T01")));
    }

    @Test
    public void testMay() throws Exception {
        this.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "4", 9)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testMay2() throws Exception {
        Assert.assertNotNull((Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle(1)));
        this.assertValues(Arrays.asList(this.createExpected("2011-05-01/2011-05-03", "2", 7), this.createExpected("2011-05-03/2011-05-04", "3", 8), this.createExpected("2011-05-04/2011-05-05", "2", 7)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testMay3() throws Exception {
        Assert.assertEquals(this.makeSingle(9), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle(9)));
        Assert.assertEquals(this.makeSingle(7), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-05"), (Object)"2", this.makeSingle(7)));
        this.assertValues(Arrays.asList(this.createExpected("2011-05-01/2011-05-02", "1", 6), this.createExpected("2011-05-03/2011-05-04", "3", 8)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test
    public void testInsertInWrongOrder() throws Exception {
        DateTime overallStart = DateTimes.nowUtc().minus((ReadablePeriod)Hours.TWO);
        Assert.assertTrue((String)"These timestamps have to be at the end AND include now for this test to work.", (boolean)overallStart.isAfter((ReadableInstant)((Interval)this.timeline.incompletePartitionsTimeline.lastEntry().getKey()).getEnd()));
        Interval oneHourInterval1 = new Interval((ReadableInstant)overallStart.plus((ReadablePeriod)Hours.THREE), (ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FOUR));
        Interval oneHourInterval2 = new Interval((ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FOUR), (ReadableInstant)overallStart.plus((ReadablePeriod)Hours.FIVE));
        this.add(oneHourInterval1, "1", (Integer)1);
        this.add(oneHourInterval2, "1", (Integer)1);
        this.add(new Interval((ReadableInstant)overallStart, (ReadableInstant)overallStart.plus((ReadablePeriod)Days.ONE)), "2", (Integer)2);
        this.assertValues(Collections.singletonList(this.createExpected(oneHourInterval1.toString(), "2", 2)), this.timeline.lookup(oneHourInterval1));
    }

    @Test
    public void testRemove() throws Exception {
        for (TimelineObjectHolder holder : this.timeline.findOvershadowed()) {
            for (PartitionChunk chunk : holder.getObject()) {
                this.timeline.remove(holder.getInterval(), holder.getVersion(), chunk);
            }
        }
        Assert.assertTrue((boolean)this.timeline.findOvershadowed().isEmpty());
    }

    @Test
    public void testFindEntry() throws Exception {
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle(1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01/2011-10-02"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle(1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01/2011-10-01T10"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle(1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T02/2011-10-02"), (Object)"1"));
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle(1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-01T17"), (Object)"1"));
        Assert.assertEquals(null, (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-01T17"), (Object)"2"));
        Assert.assertEquals(null, (Object)this.timeline.findEntry(Intervals.of((String)"2011-10-01T04/2011-10-02T17"), (Object)"1"));
    }

    @Test
    public void testFindEntryWithOverlap() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-02/2011-01-05", "2", (Integer)1);
        Assert.assertEquals((Object)new ImmutablePartitionHolder(new PartitionHolder(this.makeSingle(1))), (Object)this.timeline.findEntry(Intervals.of((String)"2011-01-02T02/2011-01-04"), (Object)"1"));
    }

    @Test
    public void testPartitioning() throws Exception {
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-10-01/2011-10-02", "1", 1), this.createExpected("2011-10-02/2011-10-03", "3", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)20), IntegerPartitionChunk.make((Integer)10, null, (int)1, (Object)21))), this.createExpected("2011-10-03/2011-10-04", "3", 3), this.createExpected("2011-10-04/2011-10-05", "4", 4), this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-01/2011-10-06")));
    }

    @Test
    public void testPartialPartitionNotReturned() throws Exception {
        this.testRemove();
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)60));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Object)61));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
        this.add("2011-10-06/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)20, null, (int)2, (Object)62));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5), this.createExpected("2011-10-06/2011-10-07", "6", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)60), IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Object)61), IntegerPartitionChunk.make((Integer)20, null, (int)2, (Object)62)))), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
    }

    @Test
    public void testIncompletePartitionDoesNotOvershadow() throws Exception {
        this.testRemove();
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)60));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)10, (Integer)20, (int)1, (Object)61));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
        this.add("2011-10-05/2011-10-07", "6", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)20, null, (int)2, (Object)62));
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.findOvershadowed());
    }

    @Test
    public void testRemovePartitionMakesIncomplete() throws Exception {
        this.testIncompletePartitionDoesNotOvershadow();
        IntegerPartitionChunk chunk = IntegerPartitionChunk.make(null, (Integer)10, (int)0, (Object)60);
        Assert.assertEquals((Object)chunk, (Object)this.timeline.remove(Intervals.of((String)"2011-10-05/2011-10-07"), (Object)"6", (PartitionChunk)chunk));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-10-05/2011-10-06", "5", 5)), this.timeline.lookup(Intervals.of((String)"2011-10-05/2011-10-07")));
        Assert.assertTrue((String)"Expected no overshadowed entries", (boolean)this.timeline.findOvershadowed().isEmpty());
    }

    @Test
    public void testInsertAndRemoveSameThingsion() throws Exception {
        this.add("2011-05-01/2011-05-10", "5", (Integer)10);
        this.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        Assert.assertEquals(this.makeSingle(10), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"5", this.makeSingle(10)));
        this.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "4", 9)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        this.add("2011-05-01/2011-05-10", "5", (Integer)10);
        this.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
        Assert.assertEquals(this.makeSingle(9), (Object)this.timeline.remove(Intervals.of((String)"2011-05-01/2011-05-10"), (Object)"4", this.makeSingle(9)));
        this.assertValues(Collections.singletonList(this.createExpected("2011-05-01/2011-05-09", "5", 10)), this.timeline.lookup(Intervals.of((String)"2011-05-01/2011-05-09")));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testOverlapSameVersionThrowException() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "1", (Integer)3);
    }

    @Test
    public void testOverlapSameVersionIsOkay() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)4);
        this.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-10", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-10")));
    }

    @Test
    public void testOverlapSecondBetween() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstBetween() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstBefore() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapFirstAfter() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapSecondBefore() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-05/2011-01-15", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "2", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 1), this.createExpected("2011-01-10/2011-01-15", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapSecondAfter() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "2", (Integer)3);
        this.add("2011-01-05/2011-01-15", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 1), this.createExpected("2011-01-10/2011-01-15", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-15")));
    }

    @Test
    public void testOverlapFirstLarger() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)2);
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 2), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondLarger() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-05/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)2);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 2), this.createExpected("2011-01-05/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondPartialAlign() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.add("2011-01-01/2011-01-15", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstPartialAlign() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-15", "2", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "1", (Integer)2);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 3), this.createExpected("2011-01-15/2011-01-20", "1", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAscending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapDescending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapMixed() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-05/2011-01-20", "2", (Integer)2);
        this.add("2011-01-03/2011-01-06", "3", (Integer)3);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedAscending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedDescending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapContainedmixed() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-02/2011-01-10", "2", (Integer)2);
        this.add("2011-01-02/2011-01-06", "3", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-02", "1", 1), this.createExpected("2011-01-02/2011-01-06", "3", 3), this.createExpected("2011-01-06/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondContained() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-07", "1", (Integer)1);
        this.add("2011-01-07/2011-01-15", "1", (Integer)2);
        this.add("2011-01-15/2011-01-20", "1", (Integer)3);
        this.add("2011-01-10/2011-01-13", "2", (Integer)4);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-07", "1", 1), this.createExpected("2011-01-07/2011-01-10", "1", 2), this.createExpected("2011-01-10/2011-01-13", "2", 4), this.createExpected("2011-01-13/2011-01-15", "1", 2), this.createExpected("2011-01-15/2011-01-20", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstContained() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-10/2011-01-13", "2", (Integer)4);
        this.add("2011-01-01/2011-01-07", "1", (Integer)1);
        this.add("2011-01-07/2011-01-15", "1", (Integer)2);
        this.add("2011-01-15/2011-01-20", "1", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-07", "1", 1), this.createExpected("2011-01-07/2011-01-10", "1", 2), this.createExpected("2011-01-10/2011-01-13", "2", 4), this.createExpected("2011-01-13/2011-01-15", "1", 2), this.createExpected("2011-01-15/2011-01-20", "1", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapSecondContainsFirst() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        this.add("2011-01-10/2011-01-20", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapFirstContainsSecond() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-10/2011-01-20", "2", (Integer)3);
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-10", "2", (Integer)2);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapLayeredAscending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.add("2011-01-05/2011-01-15", "2", (Integer)2);
        this.add("2011-01-15/2011-01-25", "3", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-25", "3", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-25")));
    }

    @Test
    public void testOverlapLayeredDescending() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-15/2011-01-25", "3", (Integer)3);
        this.add("2011-01-05/2011-01-15", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-25", "3", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-25")));
    }

    @Test
    public void testOverlapV1Large() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-15", "1", (Integer)1);
        this.add("2011-01-03/2011-01-05", "2", (Integer)2);
        this.add("2011-01-13/2011-01-20", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-20", "2", 2)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV2Large() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-15", "2", (Integer)1);
        this.add("2011-01-03/2011-01-05", "1", (Integer)2);
        this.add("2011-01-13/2011-01-20", "1", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1LargeIsAfter() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-03/2011-01-20", "1", (Integer)1);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-13/2011-01-17", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-17", "2", 3), this.createExpected("2011-01-17/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1SecondLargeIsAfter() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-13/2011-01-17", "2", (Integer)3);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-03/2011-01-20", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-13", "1", 1), this.createExpected("2011-01-13/2011-01-17", "2", 3), this.createExpected("2011-01-17/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1FirstBetween() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-03/2011-01-17", "1", (Integer)1);
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-15", "1", 1), this.createExpected("2011-01-15/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapV1SecondBetween() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-05", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        this.add("2011-01-03/2011-01-17", "1", (Integer)1);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "2", 2), this.createExpected("2011-01-05/2011-01-15", "1", 1), this.createExpected("2011-01-15/2011-01-20", "2", 3)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapLargeUnderlyingWithSmallDayAlignedOverlays() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-05", "1", (Integer)1);
        this.add("2011-01-03/2011-01-04", "2", (Integer)2);
        this.add("2011-01-04/2011-01-05", "3", (Integer)3);
        this.add("2011-01-05/2011-01-06", "4", (Integer)4);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-03", "1", 1), this.createExpected("2011-01-03/2011-01-04", "2", 2), this.createExpected("2011-01-04/2011-01-05", "3", 3), this.createExpected("2011-01-05/2011-01-06", "4", 4)), this.timeline.lookup(Intervals.of((String)"0000-01-01/3000-01-01")));
    }

    @Test
    public void testOverlapCausesNullEntries() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01T12/2011-01-02", "3", (Integer)3);
        this.add("2011-01-02/3011-01-03", "1", (Integer)1);
        this.add("2011-01-01/2011-01-02", "2", (Integer)2);
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-01T12", "2", 2), this.createExpected("2011-01-01T12/2011-01-02", "3", 3), this.createExpected("2011-01-02/3011-01-03", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/3011-01-03")));
    }

    @Test
    public void testOverlapOvershadowedThirdContains() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-03/2011-01-06", "1", (Integer)1);
        this.add("2011-01-09/2011-01-12", "1", (Integer)2);
        this.add("2011-01-02/2011-01-08", "2", (Integer)3);
        this.add("2011-01-10/2011-01-16", "2", (Integer)4);
        this.add("2011-01-01/2011-01-20", "3", (Integer)5);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-02/2011-01-08", "2", 3), this.createExpected("2011-01-10/2011-01-16", "2", 4), this.createExpected("2011-01-03/2011-01-06", "1", 1), this.createExpected("2011-01-09/2011-01-12", "1", 2)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOverlapOvershadowedAligned() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-05", "2", (Integer)1);
        this.add("2011-01-05/2011-01-10", "2", (Integer)2);
        this.add("2011-01-01/2011-01-10", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "3", (Integer)4);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-01/2011-01-05", "2", 1), this.createExpected("2011-01-05/2011-01-10", "2", 2), this.createExpected("2011-01-01/2011-01-10", "1", 3)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOverlapOvershadowedSomeComplexOverlapsCantThinkOfBetterName() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-05", "2", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.add("2011-01-03/2011-01-12", "1", (Integer)3);
        this.add("2011-01-01/2011-01-10", "3", (Integer)4);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-01-03/2011-01-12", "1", 3), this.createExpected("2011-01-01/2011-01-05", "2", 1)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOverlapAndRemove() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-15"), (Object)"2", this.makeSingle(2));
        this.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove2() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-20", "2", (Integer)2);
        this.add("2011-01-20/2011-01-30", "3", (Integer)4);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-20"), (Object)"2", this.makeSingle(2));
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-20", "1", 1), this.createExpected("2011-01-20/2011-01-30", "3", 4)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-30")));
    }

    @Test
    public void testOverlapAndRemove3() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-02/2011-01-03", "2", (Integer)2);
        this.add("2011-01-10/2011-01-14", "2", (Integer)3);
        this.timeline.remove(Intervals.of((String)"2011-01-02/2011-01-03"), (Object)"2", this.makeSingle(2));
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-14"), (Object)"2", this.makeSingle(3));
        this.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove4() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.add("2011-01-15/2011-01-20", "2", (Integer)3);
        this.timeline.remove(Intervals.of((String)"2011-01-15/2011-01-20"), (Object)"2", this.makeSingle(3));
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-10", "1", 1), this.createExpected("2011-01-10/2011-01-15", "2", 2), this.createExpected("2011-01-15/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testOverlapAndRemove5() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.add("2011-01-10/2011-01-15", "2", (Integer)2);
        this.timeline.remove(Intervals.of((String)"2011-01-10/2011-01-15"), (Object)"2", this.makeSingle(2));
        this.add("2011-01-01/2011-01-20", "1", (Integer)1);
        this.assertValues(Collections.singletonList(this.createExpected("2011-01-01/2011-01-20", "1", 1)), this.timeline.lookup(Intervals.of((String)"2011-01-01/2011-01-20")));
    }

    @Test
    public void testRemoveSomethingDontHave() throws Exception {
        Assert.assertNull((String)"Don't have it, should be null", (Object)this.timeline.remove(Intervals.of((String)"1970-01-01/2025-04-20"), (Object)"1", this.makeSingle(1)));
        Assert.assertNull((String)"Don't have it, should be null", (Object)this.timeline.remove(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"version does not exist", this.makeSingle(1)));
    }

    @Test
    public void testRemoveNothingBacking() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-01-01/2011-01-05", "1", (Integer)1);
        this.add("2011-01-05/2011-01-10", "2", (Integer)2);
        this.add("2011-01-10/2011-01-15", "3", (Integer)3);
        this.add("2011-01-15/2011-01-20", "4", (Integer)4);
        this.timeline.remove(Intervals.of((String)"2011-01-15/2011-01-20"), (Object)"4", this.makeSingle(4));
        this.assertValues(Arrays.asList(this.createExpected("2011-01-01/2011-01-05", "1", 1), this.createExpected("2011-01-05/2011-01-10", "2", 2), this.createExpected("2011-01-10/2011-01-15", "3", 3)), this.timeline.lookup(new Interval((ReadableInstant)DateTimes.EPOCH, (ReadableInstant)DateTimes.MAX)));
    }

    @Test
    public void testOvershadowingHigherVersionWins1() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-06/2011-04-09", "1", (Integer)4);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(this.createExpected("2011-04-01/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "1", 4)), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins2() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(this.createExpected("2011-04-01/2011-04-09", "1", 1)), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins3() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-03", "1", (Integer)2);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-09/2011-04-12", "1", (Integer)4);
        this.add("2011-04-01/2011-04-12", "2", (Integer)1);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-03", "1", 2), this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-09/2011-04-12", "1", 4)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionWins4() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.add("2011-04-06/2011-04-09", "1", (Integer)4);
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-06/2011-04-09", "1", 4)), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower1() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower2() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-06/2011-04-09", "2", (Integer)4);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower3() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-03", "2", (Integer)2);
        this.add("2011-04-03/2011-04-06", "2", (Integer)3);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower4() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "2", (Integer)1);
        this.add("2011-04-01/2011-04-03", "3", (Integer)2);
        this.add("2011-04-03/2011-04-06", "4", (Integer)3);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.assertValues((Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableSet.of(this.createExpected("2011-04-03/2011-04-06", "1", 3)), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingHigherVersionNeverOvershadowedByLower5() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-12", "2", (Integer)1);
        this.add("2011-04-01/2011-04-03", "3", (Integer)2);
        this.add("2011-04-06/2011-04-09", "4", (Integer)3);
        this.add("2011-04-09/2011-04-12", "1", (Integer)3);
        this.add("2011-04-03/2011-04-06", "1", (Integer)3);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-03/2011-04-06", "1", 3), this.createExpected("2011-04-09/2011-04-12", "1", 3)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingSameIntervalHighVersionWins() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-09", "9", (Integer)2);
        this.add("2011-04-01/2011-04-09", "2", (Integer)3);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-09", "2", 3), this.createExpected("2011-04-01/2011-04-09", "1", 1)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testOvershadowingSameIntervalSameVersionAllKept() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        this.add("2011-04-01/2011-04-09", "9", (Integer)2);
        this.add("2011-04-01/2011-04-09", "2", (Integer)3);
        this.add("2011-04-01/2011-04-09", "9", (Integer)4);
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-09", "2", 3), this.createExpected("2011-04-01/2011-04-09", "1", 1)}), this.timeline.findOvershadowed());
    }

    @Test
    public void testNotFoundReturnsEmpty() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-09", "1", (Integer)1);
        Assert.assertTrue((boolean)this.timeline.lookup(Intervals.of((String)"1970/1980")).isEmpty());
    }

    @Test
    public void testRemoveIncompleteKeepsComplete() throws Exception {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-01/2011-04-02", "1", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)77));
        this.add("2011-04-01/2011-04-02", "1", (PartitionChunk<Integer>)IntegerPartitionChunk.make((Integer)1, null, (int)1, (Object)88));
        this.add("2011-04-01/2011-04-02", "2", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)99));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)77), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Object)88)))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
        this.add("2011-04-01/2011-04-02", "3", (PartitionChunk<Integer>)IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)110));
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)77), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Object)88)))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
        this.assertValues(Sets.newHashSet((Object[])new Pair[]{this.createExpected("2011-04-01/2011-04-02", "2", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)99)))}), this.timeline.findOvershadowed());
        this.testRemove();
        this.assertValues((List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>>)ImmutableList.of(this.createExpected("2011-04-01/2011-04-02", "1", Arrays.asList(IntegerPartitionChunk.make(null, (Integer)1, (int)0, (Object)77), IntegerPartitionChunk.make((Integer)1, null, (int)1, (Object)88)))), this.timeline.lookup(Intervals.of((String)"2011-04-01/2011-04-02")));
    }

    @Test
    public void testIsOvershadowedWithNonOverlappingSegmentsInTimeline() {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-05/2011-04-07", "1", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-07/2011-04-09", "1", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-15/2011-04-17", "1", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-17/2011-04-19", "1", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-05"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-06"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-07"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-08"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-30"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"1"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"1"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"1"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"1"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"2"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"2"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"2"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"2"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-07"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-08"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-30"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-08"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-07/2011-04-30"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-08/2011-04-30"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-15"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-17"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-19"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-09/2011-04-30"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-16"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-17"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-18"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-19"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-20"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-30"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-19/2011-04-20"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-21/2011-04-22"), (Object)"0"));
    }

    @Test
    public void testIsOvershadowedWithOverlappingSegmentsInTimeline() {
        this.timeline = this.makeStringIntegerTimeline();
        this.add("2011-04-05/2011-04-09", "11", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-07/2011-04-11", "12", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-15/2011-04-19", "12", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        this.add("2011-04-17/2011-04-21", "11", (PartitionChunk<Integer>)new SingleElementPartitionChunk((Object)1));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-03"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-05"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-06"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-07"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-08"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-09"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-10"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-11"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-01/2011-04-30"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"12"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-06"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-07"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-08"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-09"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-10"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-11"), (Object)"13"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-12"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-15"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-16"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-17"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-18"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-19"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-20"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-21"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-05/2011-04-22"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-07"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-08"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-09"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-10"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-11"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-12"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-15"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-16"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-17"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-18"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-19"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-20"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-21"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-06/2011-04-22"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-15"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-16"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-17"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-18"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-19"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-20"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-21"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-12/2011-04-22"), (Object)"0"));
        Assert.assertTrue((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-15/2011-04-21"), (Object)"0"));
        Assert.assertFalse((boolean)this.timeline.isOvershadowed(Intervals.of((String)"2011-04-21/2011-04-22"), (Object)"0"));
    }

    private Pair<Interval, Pair<String, PartitionHolder<Integer>>> createExpected(String intervalString, String version, Integer value) {
        return this.createExpected(intervalString, version, Arrays.asList(this.makeSingle(value)));
    }

    private Pair<Interval, Pair<String, PartitionHolder<Integer>>> createExpected(String intervalString, String version, List<PartitionChunk<Integer>> values) {
        return Pair.of((Object)Intervals.of((String)intervalString), (Object)Pair.of((Object)version, (Object)new PartitionHolder(values)));
    }

    private SingleElementPartitionChunk<Integer> makeSingle(Integer value) {
        return new SingleElementPartitionChunk((Object)value);
    }

    private void add(String interval, String version, Integer value) {
        this.add(Intervals.of((String)interval), version, value);
    }

    private void add(Interval interval, String version, Integer value) {
        this.add(interval, version, (PartitionChunk<Integer>)this.makeSingle(value));
    }

    private void add(String interval, String version, PartitionChunk<Integer> value) {
        this.add(Intervals.of((String)interval), version, value);
    }

    private void add(Interval interval, String version, PartitionChunk<Integer> value) {
        this.timeline.add(interval, (Object)version, value);
    }

    private void assertValues(List<Pair<Interval, Pair<String, PartitionHolder<Integer>>>> expected, List<TimelineObjectHolder<String, Integer>> actual) {
        Assert.assertEquals((String)"Sizes did not match.", (long)expected.size(), (long)actual.size());
        Iterator<Pair<Interval, Pair<String, PartitionHolder<Integer>>>> expectedIter = expected.iterator();
        Iterator<TimelineObjectHolder<String, Integer>> actualIter = actual.iterator();
        while (expectedIter.hasNext()) {
            Pair<Interval, Pair<String, PartitionHolder<Integer>>> pair = expectedIter.next();
            TimelineObjectHolder<String, Integer> holder = actualIter.next();
            Assert.assertEquals((Object)pair.lhs, (Object)holder.getInterval());
            Assert.assertEquals((Object)((Pair)pair.rhs).lhs, (Object)holder.getVersion());
            Assert.assertEquals((Object)((Pair)pair.rhs).rhs, (Object)holder.getObject());
        }
    }

    private void assertValues(Set<Pair<Interval, Pair<String, PartitionHolder<Integer>>>> expected, Set<TimelineObjectHolder<String, Integer>> actual) {
        Assert.assertEquals((String)"Sizes did not match.", (long)expected.size(), (long)actual.size());
        HashSet actualSet = Sets.newHashSet((Iterable)Iterables.transform(actual, (Function)new Function<TimelineObjectHolder<String, Integer>, Pair<Interval, Pair<String, PartitionHolder<Integer>>>>(){

            public Pair<Interval, Pair<String, PartitionHolder<Integer>>> apply(TimelineObjectHolder<String, Integer> input) {
                return new Pair((Object)input.getInterval(), (Object)new Pair(input.getVersion(), (Object)input.getObject()));
            }
        }));
        Assert.assertEquals(expected, (Object)actualSet);
    }

    private VersionedIntervalTimeline<String, Integer> makeStringIntegerTimeline() {
        return new VersionedIntervalTimeline((Comparator)Ordering.natural());
    }
}

