/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.timeline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.SingleDimensionShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSegmentTest {
    final ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(DataSegment.PruneLoadSpecHolder.class, (Object)DataSegment.PruneLoadSpecHolder.DEFAULT);
        this.mapper.setInjectableValues((InjectableValues)injectableValues);
    }

    @Test
    public void testV1Serialization() throws Exception {
        Interval interval = Intervals.of((String)"2011-10-01/2011-10-02");
        ImmutableMap loadSpec = ImmutableMap.of((Object)"something", (Object)"or_other");
        DataSegment segment = new DataSegment("something", interval, "1", (Map)loadSpec, Arrays.asList("dim1", "dim2"), Arrays.asList("met1", "met2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1L);
        Map objectMap = (Map)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        Assert.assertEquals((long)10L, (long)objectMap.size());
        Assert.assertEquals((Object)"something", objectMap.get("dataSource"));
        Assert.assertEquals((Object)interval.toString(), objectMap.get("interval"));
        Assert.assertEquals((Object)"1", objectMap.get("version"));
        Assert.assertEquals((Object)loadSpec, objectMap.get("loadSpec"));
        Assert.assertEquals((Object)"dim1,dim2", objectMap.get("dimensions"));
        Assert.assertEquals((Object)"met1,met2", objectMap.get("metrics"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"type", (Object)"none"), objectMap.get("shardSpec"));
        Assert.assertEquals((Object)9, objectMap.get("binaryVersion"));
        Assert.assertEquals((Object)1, objectMap.get("size"));
        DataSegment deserializedSegment = (DataSegment)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((Object)segment.getDataSource(), (Object)deserializedSegment.getDataSource());
        Assert.assertEquals((Object)segment.getInterval(), (Object)deserializedSegment.getInterval());
        Assert.assertEquals((Object)segment.getVersion(), (Object)deserializedSegment.getVersion());
        Assert.assertEquals((Object)segment.getLoadSpec(), (Object)deserializedSegment.getLoadSpec());
        Assert.assertEquals((Object)segment.getDimensions(), (Object)deserializedSegment.getDimensions());
        Assert.assertEquals((Object)segment.getMetrics(), (Object)deserializedSegment.getMetrics());
        Assert.assertEquals((Object)segment.getShardSpec(), (Object)deserializedSegment.getShardSpec());
        Assert.assertEquals((long)segment.getSize(), (long)deserializedSegment.getSize());
        Assert.assertEquals((Object)segment.getIdentifier(), (Object)deserializedSegment.getIdentifier());
        deserializedSegment = (DataSegment)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)0L, (long)segment.compareTo(deserializedSegment));
        deserializedSegment = (DataSegment)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)0L, (long)deserializedSegment.compareTo(segment));
        deserializedSegment = (DataSegment)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((long)segment.hashCode(), (long)deserializedSegment.hashCode());
    }

    @Test
    public void testIdentifier() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)NoneShardSpec.instance()).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getIdentifier());
    }

    @Test
    public void testIdentifierWithZeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)new SingleDimensionShardSpec("bar", null, "abc", 0)).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z", (Object)segment.getIdentifier());
    }

    @Test
    public void testIdentifierWithNonzeroPartition() {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).shardSpec((ShardSpec)new SingleDimensionShardSpec("bar", "abc", "def", 1)).build();
        Assert.assertEquals((Object)"foo_2012-01-01T00:00:00.000Z_2012-01-02T00:00:00.000Z_2012-01-01T11:22:33.444Z_1", (Object)segment.getIdentifier());
    }

    @Test
    public void testV1SerializationNullMetrics() throws Exception {
        DataSegment segment = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2012-01-01/2012-01-02")).version(DateTimes.of((String)"2012-01-01T11:22:33.444Z").toString()).build();
        DataSegment segment2 = (DataSegment)this.mapper.readValue(this.mapper.writeValueAsString((Object)segment), DataSegment.class);
        Assert.assertEquals((String)"empty dimensions", (Object)ImmutableList.of(), (Object)segment2.getDimensions());
        Assert.assertEquals((String)"empty metrics", (Object)ImmutableList.of(), (Object)segment2.getMetrics());
    }

    @Test
    public void testBucketMonthComparator() throws Exception {
        Object[] sortedOrder = new DataSegment[]{this.makeDataSegment("test1", "2011-01-01/2011-01-02", "a"), this.makeDataSegment("test1", "2011-01-02/2011-01-03", "a"), this.makeDataSegment("test1", "2011-01-02/2011-01-03", "b"), this.makeDataSegment("test2", "2011-01-01/2011-01-02", "a"), this.makeDataSegment("test2", "2011-01-02/2011-01-03", "a"), this.makeDataSegment("test1", "2011-02-01/2011-02-02", "a"), this.makeDataSegment("test1", "2011-02-02/2011-02-03", "a"), this.makeDataSegment("test1", "2011-02-02/2011-02-03", "b"), this.makeDataSegment("test2", "2011-02-01/2011-02-02", "a"), this.makeDataSegment("test2", "2011-02-02/2011-02-03", "a")};
        ArrayList shuffled = Lists.newArrayList((Object[])sortedOrder);
        Collections.shuffle(shuffled);
        TreeSet theSet = Sets.newTreeSet((Comparator)DataSegment.bucketMonthComparator());
        theSet.addAll(shuffled);
        int index = 0;
        for (DataSegment dataSegment : theSet) {
            Assert.assertEquals((Object)sortedOrder[index], (Object)dataSegment);
            ++index;
        }
    }

    private DataSegment makeDataSegment(String dataSource, String interval, String version) {
        return DataSegment.builder().dataSource(dataSource).interval(Intervals.of((String)interval)).version(version).size(1L).build();
    }
}

