/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.shard;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.server.ServerTestHelper;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.apache.hive.druid.io.druid.timeline.partition.NumberedShardSpec;
import org.apache.hive.druid.io.druid.timeline.partition.PartitionChunk;
import org.apache.hive.druid.io.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class NumberedShardSpecTest {
    @Test
    public void testSerdeRoundTrip() throws Exception {
        ShardSpec spec = (ShardSpec)ServerTestHelper.MAPPER.readValue(ServerTestHelper.MAPPER.writeValueAsBytes((Object)new NumberedShardSpec(1, 2)), ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)((NumberedShardSpec)spec).getPartitions());
    }

    @Test
    public void testSerdeBackwardsCompat() throws Exception {
        ShardSpec spec = (ShardSpec)ServerTestHelper.MAPPER.readValue("{\"type\": \"numbered\", \"partitions\": 2, \"partitionNum\": 1}", ShardSpec.class);
        Assert.assertEquals((long)1L, (long)spec.getPartitionNum());
        Assert.assertEquals((long)2L, (long)((NumberedShardSpec)spec).getPartitions());
    }

    @Test
    public void testPartitionChunks() {
        ImmutableList specs = ImmutableList.of((Object)new NumberedShardSpec(0, 3), (Object)new NumberedShardSpec(1, 3), (Object)new NumberedShardSpec(2, 3));
        List chunks = Lists.transform((List)specs, (Function)new Function<ShardSpec, PartitionChunk<String>>(){

            public PartitionChunk<String> apply(ShardSpec shardSpec) {
                return shardSpec.createChunk((Object)"rofl");
            }
        });
        Assert.assertEquals((long)0L, (long)((PartitionChunk)chunks.get(0)).getChunkNumber());
        Assert.assertEquals((long)1L, (long)((PartitionChunk)chunks.get(1)).getChunkNumber());
        Assert.assertEquals((long)2L, (long)((PartitionChunk)chunks.get(2)).getChunkNumber());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).isStart());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).isEnd());
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(2)).isEnd());
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertTrue((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(0)).abuts((PartitionChunk)chunks.get(2)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(1)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(0)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(1)));
        Assert.assertFalse((boolean)((PartitionChunk)chunks.get(2)).abuts((PartitionChunk)chunks.get(2)));
    }

    @Test
    public void testVersionedIntervalTimelineBehaviorForNumberedShardSpec() {
        PartitionChunk chunk0 = new NumberedShardSpec(0, 2).createChunk((Object)"0");
        PartitionChunk chunk1 = new NumberedShardSpec(1, 2).createChunk((Object)"1");
        PartitionChunk chunk4 = new NumberedShardSpec(4, 2).createChunk((Object)"4");
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk0), Collections.EMPTY_SET);
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk1), Collections.EMPTY_SET);
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk4), Collections.EMPTY_SET);
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk0, (Object)chunk4), Collections.EMPTY_SET);
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk1, (Object)chunk4), Collections.EMPTY_SET);
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk1, (Object)chunk0), (Set<String>)ImmutableSet.of((Object)"0", (Object)"1"));
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk4, (Object)chunk1, (Object)chunk0), (Set<String>)ImmutableSet.of((Object)"0", (Object)"1", (Object)"4"));
        chunk0 = new NumberedShardSpec(0, 0).createChunk((Object)"0");
        chunk4 = new NumberedShardSpec(4, 0).createChunk((Object)"4");
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk0), (Set<String>)ImmutableSet.of((Object)"0"));
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk4), (Set<String>)ImmutableSet.of((Object)"4"));
        this.testVersionedIntervalTimelineBehaviorForNumberedShardSpec((List<PartitionChunk<String>>)ImmutableList.of((Object)chunk4, (Object)chunk0), (Set<String>)ImmutableSet.of((Object)"0", (Object)"4"));
    }

    private void testVersionedIntervalTimelineBehaviorForNumberedShardSpec(List<PartitionChunk<String>> chunks, Set<String> expectedObjects) {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural());
        Interval interval = Intervals.of((String)"2000/3000");
        String version = "v1";
        for (PartitionChunk<String> chunk : chunks) {
            timeline.add(interval, (Object)version, chunk);
        }
        HashSet<Object> actualObjects = new HashSet<Object>();
        List entries = timeline.lookup(interval);
        for (TimelineObjectHolder entry : entries) {
            for (PartitionChunk chunk : entry.getObject()) {
                actualObjects.add(chunk.getObject());
            }
        }
        Assert.assertEquals(expectedObjects, actualObjects);
    }
}

