/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import java.util.Arrays;
import org.apache.hive.druid.io.druid.client.selector.Server;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.Pair;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.hive.druid.io.druid.query.spec.QuerySegmentSpec;
import org.apache.hive.druid.io.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.hive.druid.io.druid.server.router.AvaticaConnectionBalancer;
import org.apache.hive.druid.io.druid.server.router.QueryHostFinder;
import org.apache.hive.druid.io.druid.server.router.RendezvousHashAvaticaConnectionBalancer;
import org.apache.hive.druid.io.druid.server.router.TieredBrokerHostSelector;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryHostFinderTest {
    private TieredBrokerHostSelector brokerSelector;
    private Server server;

    @Before
    public void setUp() throws Exception {
        this.brokerSelector = (TieredBrokerHostSelector)EasyMock.createMock(TieredBrokerHostSelector.class);
        this.server = new Server(){

            public String getScheme() {
                return null;
            }

            public String getHost() {
                return "foo";
            }

            public String getAddress() {
                return null;
            }

            public int getPort() {
                return 0;
            }
        };
        EasyMock.expect((Object)this.brokerSelector.select((Query)EasyMock.anyObject(Query.class))).andReturn((Object)Pair.of((Object)"service", (Object)this.server));
        EasyMock.replay((Object[])new Object[]{this.brokerSelector});
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.brokerSelector});
    }

    @Test
    public void testFindServer() throws Exception {
        QueryHostFinder queryRunner = new QueryHostFinder(this.brokerSelector, (AvaticaConnectionBalancer)new RendezvousHashAvaticaConnectionBalancer());
        Server server = queryRunner.findServer((Query)new TimeBoundaryQuery((DataSource)new TableDataSource("test"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec(Arrays.asList(Intervals.of((String)"2011-08-31/2011-09-01"))), null, null, null));
        Assert.assertEquals((Object)"foo", (Object)server.getHost());
    }
}

