/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http.security;

import com.google.inject.Injector;
import com.sun.jersey.spi.container.ResourceFilter;
import java.util.Collection;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.io.druid.server.BrokerQueryResource;
import org.apache.hive.druid.io.druid.server.ClientInfoResource;
import org.apache.hive.druid.io.druid.server.QueryResource;
import org.apache.hive.druid.io.druid.server.StatusResource;
import org.apache.hive.druid.io.druid.server.http.BrokerResource;
import org.apache.hive.druid.io.druid.server.http.CoordinatorDynamicConfigsResource;
import org.apache.hive.druid.io.druid.server.http.CoordinatorResource;
import org.apache.hive.druid.io.druid.server.http.DatasourcesResource;
import org.apache.hive.druid.io.druid.server.http.HistoricalResource;
import org.apache.hive.druid.io.druid.server.http.IntervalsResource;
import org.apache.hive.druid.io.druid.server.http.MetadataResource;
import org.apache.hive.druid.io.druid.server.http.RulesResource;
import org.apache.hive.druid.io.druid.server.http.ServersResource;
import org.apache.hive.druid.io.druid.server.http.TiersResource;
import org.apache.hive.druid.io.druid.server.http.security.AbstractResourceFilter;
import org.apache.hive.druid.io.druid.server.http.security.ResourceFilterTestHelper;
import org.apache.hive.druid.io.druid.server.security.ForbiddenException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SecurityResourceFilterTest
extends ResourceFilterTestHelper {
    private final String requestPath;
    private final String requestMethod;
    private final ResourceFilter resourceFilter;
    private final Injector injector;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable[])new Iterable[]{SecurityResourceFilterTest.getRequestPathsWithAuthorizer(CoordinatorResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(DatasourcesResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(BrokerResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(HistoricalResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(IntervalsResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(MetadataResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(RulesResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(ServersResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(TiersResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(ClientInfoResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(CoordinatorDynamicConfigsResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(QueryResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(StatusResource.class), SecurityResourceFilterTest.getRequestPathsWithAuthorizer(BrokerQueryResource.class)}));
    }

    public SecurityResourceFilterTest(String requestPath, String requestMethod, ResourceFilter resourceFilter, Injector injector) {
        this.requestPath = requestPath;
        this.requestMethod = requestMethod;
        this.resourceFilter = resourceFilter;
        this.injector = injector;
    }

    @Before
    public void setUp() throws Exception {
        this.setUp(this.resourceFilter);
    }

    @Test
    public void testResourcesFilteringAccess() {
        this.setUpMockExpectations(this.requestPath, true, this.requestMethod);
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        Assert.assertTrue((boolean)((AbstractResourceFilter)this.resourceFilter.getRequestFilter()).isApplicable(this.requestPath));
        this.resourceFilter.getRequestFilter().filter(this.request);
        EasyMock.verify((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
    }

    @Test(expected=ForbiddenException.class)
    public void testResourcesFilteringNoAccess() {
        this.setUpMockExpectations(this.requestPath, false, this.requestMethod);
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        Assert.assertTrue((boolean)((AbstractResourceFilter)this.resourceFilter.getRequestFilter()).isApplicable(this.requestPath));
        this.resourceFilter.getRequestFilter().filter(this.request);
        Assert.fail();
        EasyMock.verify((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
    }

    @Test
    public void testResourcesFilteringBadPath() {
        EasyMock.replay((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
        String badRequestPath = this.requestPath.replaceAll("\\w+", "droid");
        Assert.assertFalse((boolean)((AbstractResourceFilter)this.resourceFilter.getRequestFilter()).isApplicable(badRequestPath));
        EasyMock.verify((Object[])new Object[]{this.req, this.request, this.authorizerMapper});
    }
}

