/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.net.HostAndPort;
import org.apache.hive.druid.io.druid.audit.AuditInfo;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.query.lookup.LookupsState;
import org.apache.hive.druid.io.druid.server.http.LookupCoordinatorResource;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.hive.druid.io.druid.server.lookup.cache.LookupExtractorFactoryMapContainer;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class LookupCoordinatorResourceTest {
    private static final ObjectMapper mapper = new DefaultObjectMapper();
    private static final String LOOKUP_TIER = "lookupTier";
    private static final String LOOKUP_NAME = "lookupName";
    private static final LookupExtractorFactoryMapContainer SINGLE_LOOKUP = new LookupExtractorFactoryMapContainer("v0", (Map)ImmutableMap.of());
    private static final Map<String, LookupExtractorFactoryMapContainer> SINGLE_LOOKUP_MAP = ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP);
    private static final Map<String, Map<String, LookupExtractorFactoryMapContainer>> SINGLE_TIER_MAP = ImmutableMap.of((Object)"lookupTier", SINGLE_LOOKUP_MAP);
    private static final ByteSource SINGLE_TIER_MAP_SOURCE = new ByteSource(){

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(StringUtils.toUtf8((String)mapper.writeValueAsString((Object)SINGLE_TIER_MAP)));
        }
    };
    private static final ByteSource EMPTY_MAP_SOURCE = new ByteSource(){

        public InputStream openStream() throws IOException {
            return new ByteArrayInputStream(StringUtils.toUtf8((String)mapper.writeValueAsString((Object)SINGLE_LOOKUP)));
        }
    };
    private static final HostAndPort LOOKUP_NODE = HostAndPort.fromParts((String)"localhost", (int)1111);
    private static final LookupsState<LookupExtractorFactoryMapContainer> LOOKUP_STATE = new LookupsState((Map)ImmutableMap.of((Object)"lookupName", (Object)SINGLE_LOOKUP), null, null);
    private static final Map<HostAndPort, LookupsState<LookupExtractorFactoryMapContainer>> NODES_LOOKUP_STATE = ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE);

    @Test
    public void testSimpleGet() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        HashMap retVal = new HashMap();
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(retVal).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(retVal.keySet(), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGet() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGet() {
        String errMsg = "some error";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getTiers(false);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDiscoveryGet() {
        ImmutableSet tiers = ImmutableSet.of();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverTiers()).andReturn((Object)tiers).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getTiers(true);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)tiers, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDiscoveryExceptionalGet() {
        String errMsg = "some error";
        RuntimeException ex = new RuntimeException("some error");
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverTiers()).andThrow((Throwable)ex).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getTiers(true);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleGetLookup() {
        LookupExtractorFactoryMapContainer container = new LookupExtractorFactoryMapContainer("v0", new HashMap());
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn((Object)container).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)container, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testDetailedGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier(LOOKUP_TIER, true);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(SINGLE_TIER_MAP.get(LOOKUP_TIER), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testInvalidGetLookup() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("foo", null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("foo", "").getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup("", "foo").getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.getSpecificLookup(null, "foo").getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGetLookup() {
        String errMsg = "some message";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME))).andThrow((Throwable)new RuntimeException("some message")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificLookup(LOOKUP_TIER, LOOKUP_NAME);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some message"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleDelete() {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testMissingDelete() {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", request);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalDelete() {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        String errMsg = "some error";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.deleteLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.deleteLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testInvalidDelete() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("foo", null, null, null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup(null, null, null, null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup(null, "foo", null, null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("foo", "", null, null, null).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.deleteLookup("", "foo", null, null, null).getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testSimpleNew() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), "some author", "some comment", request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalNew() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        String errMsg = "some error";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), "some author", "some comment", request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testFailedNew() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookups((Map)EasyMock.eq(SINGLE_TIER_MAP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.updateAllLookups(SINGLE_TIER_MAP_SOURCE.openStream(), "some author", "some comment", request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Unknown error updating configuration"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testSimpleNewLookup() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)202L, (long)response.getStatus());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testDBErrNewLookup() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"Unknown error updating configuration"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testExceptionalNewLookup() throws Exception {
        String errMsg = "error message";
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        EasyMock.expect((Object)request.getContentType()).andReturn((Object)"application/json").once();
        EasyMock.expect((Object)request.getRemoteAddr()).andReturn((Object)"127.0.0.1").once();
        Capture auditInfoCapture = Capture.newInstance();
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.updateLookup((String)EasyMock.eq((Object)LOOKUP_TIER), (String)EasyMock.eq((Object)LOOKUP_NAME), (LookupExtractorFactoryMapContainer)EasyMock.eq((Object)SINGLE_LOOKUP), (AuditInfo)EasyMock.capture((Capture)auditInfoCapture))).andThrow((Throwable)new RuntimeException("error message")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, LOOKUP_NAME, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"error message"), (Object)response.getEntity());
        Assert.assertTrue((boolean)auditInfoCapture.hasCaptured());
        AuditInfo auditInfo = (AuditInfo)auditInfoCapture.getValue();
        Assert.assertEquals((Object)"some author", (Object)auditInfo.getAuthor());
        Assert.assertEquals((Object)"some comment", (Object)auditInfo.getComment());
        Assert.assertEquals((Object)"127.0.0.1", (Object)auditInfo.getIp());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testNullValsNewLookup() throws Exception {
        String author = "some author";
        String comment = "some comment";
        String ip = "127.0.0.1";
        HttpServletRequest request = (HttpServletRequest)EasyMock.createStrictMock(HttpServletRequest.class);
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager, request});
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(null, LOOKUP_NAME, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, null, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup(LOOKUP_TIER, "", "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        Assert.assertEquals((long)400L, (long)lookupCoordinatorResource.createOrUpdateLookup("", LOOKUP_NAME, "some author", "some comment", EMPTY_MAP_SOURCE.openStream(), request).getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager, request});
    }

    @Test
    public void testSimpleGetTier() {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier(LOOKUP_TIER, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(SINGLE_TIER_MAP.get(LOOKUP_TIER).keySet(), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testMissingGetTier() {
        String tier = "some tier";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        ImmutableMap retVal = ImmutableMap.of();
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testNullGetTier() {
        String tier = null;
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier(tier, false);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"`tier` required"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testNullLookupsGetTier() {
        String tier = "some tier";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"No lookups found"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testExceptionalGetTier() {
        String tier = "some tier";
        String errMsg = "some error";
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andThrow((Throwable)new RuntimeException("some error")).once();
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificTier("some tier", false);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"error", (Object)"some error"), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetAllLookupsStatus() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getAllLookupsStatus(false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)LOOKUP_NAME, (Object)new LookupCoordinatorResource.LookupStatus(true, null))), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetLookupStatusForTier() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getLookupStatusForTier(LOOKUP_TIER, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_NAME, (Object)new LookupCoordinatorResource.LookupStatus(true, null)), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetSpecificLookupStatus() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificLookupStatus(LOOKUP_TIER, LOOKUP_NAME, false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(true, null), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetLookupStatusDetailedTrue() {
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource((LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class), mapper, mapper);
        HostAndPort newNode = HostAndPort.fromParts((String)"localhost", (int)4352);
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(false, (List)ImmutableList.of((Object)newNode)), (Object)lookupCoordinatorResource.getLookupStatus(LOOKUP_NAME, SINGLE_LOOKUP, (Collection)ImmutableList.of((Object)LOOKUP_NODE, (Object)newNode), NODES_LOOKUP_STATE, true));
    }

    @Test
    public void testGetLookupStatusDetailedFalse() {
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource((LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class), mapper, mapper);
        HostAndPort newNode = HostAndPort.fromParts((String)"localhost", (int)4352);
        Assert.assertEquals((Object)new LookupCoordinatorResource.LookupStatus(false, null), (Object)lookupCoordinatorResource.getLookupStatus(LOOKUP_NAME, SINGLE_LOOKUP, (Collection)ImmutableList.of((Object)LOOKUP_NODE, (Object)newNode), NODES_LOOKUP_STATE, false));
    }

    @Test
    public void testGetAllNodesStatus() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getKnownLookups()).andReturn(SINGLE_TIER_MAP);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getAllNodesStatus(false);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_TIER, (Object)ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE)), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetNodesStatusInTier() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.expect((Object)lookupCoordinatorManager.discoverNodesInTier(LOOKUP_TIER)).andReturn((Object)ImmutableList.of((Object)LOOKUP_NODE));
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getNodesStatusInTier(LOOKUP_TIER);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)ImmutableMap.of((Object)LOOKUP_NODE, LOOKUP_STATE), (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }

    @Test
    public void testGetSpecificNodeStatus() throws Exception {
        LookupCoordinatorManager lookupCoordinatorManager = (LookupCoordinatorManager)EasyMock.createStrictMock(LookupCoordinatorManager.class);
        EasyMock.expect((Object)lookupCoordinatorManager.getLastKnownLookupsStateOnNodes()).andReturn(NODES_LOOKUP_STATE);
        EasyMock.replay((Object[])new Object[]{lookupCoordinatorManager});
        LookupCoordinatorResource lookupCoordinatorResource = new LookupCoordinatorResource(lookupCoordinatorManager, mapper, mapper);
        Response response = lookupCoordinatorResource.getSpecificNodeStatus(LOOKUP_TIER, LOOKUP_NODE);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals(LOOKUP_STATE, (Object)response.getEntity());
        EasyMock.verify((Object[])new Object[]{lookupCoordinatorManager});
    }
}

