/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.server.router.RendezvousHasher;
import org.junit.Assert;
import org.junit.Test;

public class RendezvousHasherTest {
    private static int NUM_ITERATIONS = 10000;
    private static final Logger log = new Logger(RendezvousHasherTest.class);

    @Test
    public void testBasic() throws Exception {
        int i;
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, String> uuidServerMap = new HashMap<String, String>();
        for (i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        for (i = 0; i < 2; ++i) {
            for (Map.Entry entry : uuidServerMap.entrySet()) {
                String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
                Assert.assertEquals(entry.getValue(), (Object)targetServer);
            }
        }
    }

    @Test
    public void testAddNode() throws Exception {
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.add("localhost:6");
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testAddNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.33 ? 1 : 0) != 0);
    }

    @Test
    public void testRemoveNode() throws Exception {
        RendezvousHasher hasher = new RendezvousHasher();
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        nodes.remove("localhost:3");
        int same = 0;
        int diff = 0;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)((String)entry.getKey())));
            if (((String)entry.getValue()).equals(targetServer)) {
                ++same;
                continue;
            }
            ++diff;
        }
        log.info(StringUtils.format((String)"testRemoveNode Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{NUM_ITERATIONS, same, diff}), new Object[0]);
        double diffRatio = (double)diff / (double)NUM_ITERATIONS;
        Assert.assertTrue((diffRatio < 0.33 ? 1 : 0) != 0);
    }

    @Test
    public void testInconsistentView1() throws Exception {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:2");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:3");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView1", nodes, nodes2, 0.33);
    }

    @Test
    public void testInconsistentView2() throws Exception {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:1");
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:2");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView2", nodes, nodes2, 0.55);
    }

    @Test
    public void testInconsistentView3() throws Exception {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:3");
        nodes.add("localhost:4");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView3", nodes, nodes2, 0.66);
    }

    @Test
    public void testInconsistentView4() throws Exception {
        HashSet<String> nodes = new HashSet<String>();
        nodes.add("localhost:2");
        nodes.add("localhost:5");
        HashSet<String> nodes2 = new HashSet<String>();
        nodes2.add("localhost:1");
        nodes2.add("localhost:4");
        nodes2.add("localhost:5");
        this.testInconsistentViewHelper("testInconsistentView4", nodes, nodes2, 0.95);
    }

    /*
     * WARNING - void declaration
     */
    public void testInconsistentViewHelper(String testName, Set<String> nodes, Set<String> nodes2, double expectedDiffRatio) throws Exception {
        void var11_14;
        RendezvousHasher hasher = new RendezvousHasher();
        HashMap<String, Object> uuidServerMap = new HashMap<String, Object>();
        for (int i = 0; i < NUM_ITERATIONS; ++i) {
            UUID objectId = UUID.randomUUID();
            String targetServer = hasher.chooseNode(nodes, StringUtils.toUtf8((String)objectId.toString()));
            uuidServerMap.put(objectId.toString(), targetServer);
        }
        RendezvousHasher hasher2 = new RendezvousHasher();
        HashMap uuidServerMap2 = new HashMap();
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String targetServer = hasher2.chooseNode(nodes2, StringUtils.toUtf8((String)((String)entry.getKey())));
            uuidServerMap2.put(entry.getKey(), targetServer);
        }
        int same = 0;
        boolean bl = false;
        for (Map.Entry entry : uuidServerMap.entrySet()) {
            String otherServer = (String)uuidServerMap2.get(entry.getKey());
            if (((String)entry.getValue()).equals(otherServer)) {
                ++same;
                continue;
            }
            ++var11_14;
        }
        double actualDiffRatio = (double)var11_14 / (double)NUM_ITERATIONS;
        log.info(StringUtils.format((String)"%s Total: %s, Same: %s, Diff: %s", (Object[])new Object[]{testName, NUM_ITERATIONS, same, (int)var11_14}), new Object[0]);
        log.info("Expected diff ratio: %s, Actual diff ratio: %s", new Object[]{expectedDiffRatio, actualDiffRatio});
        Assert.assertTrue((actualDiffRatio <= expectedDiffRatio ? 1 : 0) != 0);
    }
}

