/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.serde;

import java.io.File;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.Smoosh;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedFileMapper;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.io.druid.segment.column.Column;
import org.apache.hive.druid.io.druid.segment.column.ColumnBuilder;
import org.apache.hive.druid.io.druid.segment.column.ComplexColumn;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.ObjectStrategy;
import org.apache.hive.druid.io.druid.segment.serde.HyperUniquesSerdeForTest;
import org.apache.hive.druid.io.druid.segment.serde.LargeColumnSupportedComplexColumnSerializer;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.junit.Assert;
import org.junit.Test;

public class LargeColumnSupportedComplexColumnSerializerTest {
    private final HashFunction fn = Hashing.murmur3_128();

    @Test
    public void testSanity() throws IOException {
        int[] columnSizes;
        HyperUniquesSerdeForTest serde = new HyperUniquesSerdeForTest(Hashing.murmur3_128());
        int[] cases = new int[]{1000, 5000, 10000, 20000};
        for (int columnSize : columnSizes = new int[]{Integer.MAX_VALUE, 0x3FFFFFFF, 0x1FFFFFFF, 40000, 20000}) {
            for (int aCase : cases) {
                int i;
                File tmpFile = FileUtils.getTempDirectory();
                HyperLogLogCollector baseCollector = HyperLogLogCollector.makeLatestCollector();
                try (OffHeapMemorySegmentWriteOutMedium segmentWriteOutMedium = new OffHeapMemorySegmentWriteOutMedium();
                     FileSmoosher v9Smoosher = new FileSmoosher(tmpFile);){
                    LargeColumnSupportedComplexColumnSerializer serializer = LargeColumnSupportedComplexColumnSerializer.createWithColumnSize((SegmentWriteOutMedium)segmentWriteOutMedium, (String)"test", (ObjectStrategy)serde.getObjectStrategy(), (int)columnSize);
                    serializer.open();
                    for (i = 0; i < aCase; ++i) {
                        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                        byte[] hashBytes = this.fn.hashLong((long)i).asBytes();
                        collector.add(hashBytes);
                        baseCollector.fold(collector);
                        serializer.serialize((Object)collector);
                    }
                    try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter("test", serializer.getSerializedSize());){
                        serializer.writeTo((WritableByteChannel)channel, v9Smoosher);
                    }
                }
                SmooshedFileMapper mapper = Smoosh.map((File)tmpFile);
                ColumnBuilder builder = new ColumnBuilder().setType(ValueType.COMPLEX).setHasMultipleValues(false).setFileMapper(mapper);
                serde.deserializeColumn(mapper.mapFile("test"), builder);
                Column column = builder.build();
                ComplexColumn complexColumn = column.getComplexColumn();
                HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
                for (i = 0; i < aCase; ++i) {
                    collector.fold((HyperLogLogCollector)complexColumn.getRowValue(i));
                }
                Assert.assertEquals((double)baseCollector.estimateCardinality(), (double)collector.estimateCardinality(), (double)0.0);
            }
        }
    }
}

