/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.MapBasedInputRow;
import org.apache.hive.druid.io.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.io.druid.segment.IndexMergerTestBase;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.SegmentValidationException;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.data.BitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.ConciseBitmapSerdeFactory;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexSchema;
import org.apache.hive.druid.io.druid.segment.incremental.IndexSizeExceededException;
import org.apache.hive.druid.io.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexIOTest {
    private static Interval DEFAULT_INTERVAL = Intervals.of((String)"1970-01-01/2000-01-01");
    private static final IndexSpec INDEX_SPEC = IndexMergerTestBase.makeIndexSpec((BitmapSerdeFactory)new ConciseBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZ4, CompressionFactory.LongEncodingStrategy.LONGS);
    private final Collection<Map<String, Object>> events1;
    private final Collection<Map<String, Object>> events2;
    private final Class<? extends Exception> exception;
    final IncrementalIndex<Aggregator> incrementalIndex1 = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DEFAULT_INTERVAL.getStart().getMillis()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("dim0", "dim1")), null, null)).build()).setMaxRowCount(1000000).buildOnheap();
    final IncrementalIndex<Aggregator> incrementalIndex2 = new IncrementalIndex.Builder().setIndexSchema(new IncrementalIndexSchema.Builder().withMinTimestamp(DEFAULT_INTERVAL.getStart().getMillis()).withMetrics(new AggregatorFactory[]{new CountAggregatorFactory("count")}).withDimensionsSpec(new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("dim0", "dim1")), null, null)).build()).setMaxRowCount(1000000).buildOnheap();
    IndexableAdapter adapter1;
    IndexableAdapter adapter2;

    private static <T> List<T> filterByBitset(List<T> list, BitSet bitSet) {
        ArrayList<T> outList = new ArrayList<T>(bitSet.cardinality());
        for (int i = 0; i < list.size(); ++i) {
            if (!bitSet.get(i)) continue;
            outList.add(list.get(i));
        }
        return outList;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> constructionFeeder() {
        ImmutableMap map = ImmutableMap.of();
        ImmutableMap map00 = ImmutableMap.of((Object)"dim0", (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"));
        ImmutableMap map10 = ImmutableMap.of((Object)"dim1", (Object)"dim10");
        HashMap<String, Object> map0null = new HashMap<String, Object>();
        map0null.put("dim0", null);
        HashMap<String, Object> map1null = new HashMap<String, Object>();
        map1null.put("dim1", null);
        ImmutableMap mapAll = ImmutableMap.of((Object)"dim0", (Object)ImmutableList.of((Object)"dim00", (Object)"dim01"), (Object)"dim1", (Object)"dim10");
        ImmutableList maps = ImmutableList.of((Object)map, (Object)map00, (Object)map10, map0null, map1null, (Object)mapAll);
        return Iterables.concat((Iterable)Iterables.concat((Iterable)new Iterable<Iterable<Object[]>>((List)maps){
            final /* synthetic */ List val$maps;
            {
                this.val$maps = list;
            }

            @Override
            public Iterator<Iterable<Object[]>> iterator() {
                return new Iterator<Iterable<Object[]>>(){
                    long nextBitset = 1L;

                    @Override
                    public boolean hasNext() {
                        return this.nextBitset < 1L << val$maps.size();
                    }

                    @Override
                    public Iterable<Object[]> next() {
                        BitSet bitset = BitSet.valueOf(new long[]{this.nextBitset++});
                        List myMaps = IndexIOTest.filterByBitset(val$maps, bitset);
                        return Collections2.transform((Collection)Collections2.permutations((Collection)myMaps), (Function)new Function<List<Map<String, Object>>, Object[]>(){

                            @Nullable
                            public Object[] apply(List<Map<String, Object>> input) {
                                return new Object[]{input, input, null};
                            }
                        });
                    }

                    @Override
                    public void remove() {
                        throw new UOE("Remove not suported", new Object[0]);
                    }
                };
            }
        }), (Iterable)Iterables.concat((Iterable)new Iterable<Iterable<Object[]>>((List)maps){
            final /* synthetic */ List val$maps;
            {
                this.val$maps = list;
            }

            @Override
            public Iterator<Iterable<Object[]>> iterator() {
                return new Iterator<Iterable<Object[]>>(){
                    long nextMap1Bits = 1L;

                    @Override
                    public boolean hasNext() {
                        return this.nextMap1Bits < 1L << val$maps.size();
                    }

                    @Override
                    public Iterable<Object[]> next() {
                        BitSet bitset1 = BitSet.valueOf(new long[]{this.nextMap1Bits++});
                        final List maplist1 = IndexIOTest.filterByBitset(val$maps, bitset1);
                        return new Iterable<Object[]>(){

                            @Override
                            public Iterator<Object[]> iterator() {
                                return new Iterator<Object[]>(){
                                    long nextMap2Bits = 1L;

                                    @Override
                                    public boolean hasNext() {
                                        return this.nextMap2Bits < 1L << val$maps.size();
                                    }

                                    @Override
                                    public Object[] next() {
                                        List maplist2 = IndexIOTest.filterByBitset(val$maps, BitSet.valueOf(new long[]{this.nextMap2Bits++}));
                                        return new Object[]{maplist1, maplist2, IndexIOTest.filterNullValues(maplist1).equals(IndexIOTest.filterNullValues(maplist2)) ? null : SegmentValidationException.class};
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UOE("remove not supported", new Object[0]);
                                    }
                                };
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        throw new UOE("Remove not supported", new Object[0]);
                    }
                };
            }
        }));
    }

    public static List<Map> filterNullValues(List<Map<String, Object>> mapList) {
        return Lists.transform(mapList, (Function)new Function<Map, Map>(){

            @Nullable
            public Map apply(@Nullable Map input) {
                return Maps.filterValues((Map)input, (Predicate)Predicates.notNull());
            }
        });
    }

    public IndexIOTest(Collection<Map<String, Object>> events1, Collection<Map<String, Object>> events2, Class<? extends Exception> exception) {
        this.events1 = events1;
        this.events2 = events2;
        this.exception = exception;
    }

    @Before
    public void setUp() throws IndexSizeExceededException {
        long timestamp = 0L;
        for (Map<String, Object> event : this.events1) {
            this.incrementalIndex1.add((InputRow)new MapBasedInputRow(timestamp++, (List)Lists.newArrayList(event.keySet()), event));
        }
        timestamp = 0L;
        for (Map<String, Object> event : this.events2) {
            this.incrementalIndex2.add((InputRow)new MapBasedInputRow(timestamp++, (List)Lists.newArrayList(event.keySet()), event));
        }
        this.adapter2 = new IncrementalIndexAdapter(DEFAULT_INTERVAL, this.incrementalIndex2, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
        this.adapter1 = new IncrementalIndexAdapter(DEFAULT_INTERVAL, this.incrementalIndex1, INDEX_SPEC.getBitmapSerdeFactory().getBitmapFactory());
    }

    @Test
    public void testRowValidatorEquals() throws Exception {
        Exception ex = null;
        try {
            TestHelper.getTestIndexIO((SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance()).validateTwoSegments(this.adapter1, this.adapter2);
        }
        catch (Exception e) {
            ex = e;
        }
        if (this.exception != null) {
            Assert.assertNotNull((String)"Exception was not thrown", (Object)ex);
            if (!this.exception.isAssignableFrom(ex.getClass())) {
                throw ex;
            }
        } else if (ex != null) {
            throw ex;
        }
    }
}

