/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.realtime.firehose;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.data.input.Firehose;
import org.apache.hive.druid.io.druid.data.input.FirehoseFactory;
import org.apache.hive.druid.io.druid.data.input.InputRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.io.druid.segment.realtime.firehose.CombiningFirehoseFactory;
import org.apache.hive.druid.io.druid.utils.Runnables;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class CombiningFirehoseFactoryTest {
    @Test
    public void testCombiningfirehose() throws IOException {
        List<InputRow> list1 = Arrays.asList(this.makeRow(1L, 1.0f), this.makeRow(2L, 2.0f));
        List<InputRow> list2 = Arrays.asList(this.makeRow(3L, 3.0f), this.makeRow(4L, 4.0f), this.makeRow(5L, 5.0f));
        CombiningFirehoseFactory combiningFactory = new CombiningFirehoseFactory(Arrays.asList(new ListFirehoseFactory(list1), new ListFirehoseFactory(list2)));
        Firehose firehose = combiningFactory.connect(null, null);
        for (int i = 1; i < 6; ++i) {
            Assert.assertTrue((boolean)firehose.hasMore());
            InputRow inputRow = firehose.nextRow();
            Assert.assertEquals((long)i, (long)inputRow.getTimestampFromEpoch());
            Assert.assertEquals((float)i, (float)inputRow.getMetric("test").floatValue(), (float)0.0f);
        }
        Assert.assertFalse((boolean)firehose.hasMore());
    }

    private InputRow makeRow(final long timestamp, final float metricValue) {
        return new InputRow(){

            public List<String> getDimensions() {
                return Arrays.asList("testDim");
            }

            public long getTimestampFromEpoch() {
                return timestamp;
            }

            public DateTime getTimestamp() {
                return DateTimes.utc((long)timestamp);
            }

            public List<String> getDimension(String dimension) {
                return Lists.newArrayList();
            }

            public Number getMetric(String metric) {
                return Float.valueOf(metricValue);
            }

            public Object getRaw(String dimension) {
                return null;
            }

            public int compareTo(Row o) {
                return 0;
            }
        };
    }

    public static class ListFirehoseFactory
    implements FirehoseFactory<InputRowParser> {
        private final List<InputRow> rows;

        ListFirehoseFactory(List<InputRow> rows) {
            this.rows = rows;
        }

        public Firehose connect(InputRowParser inputRowParser, File temporaryDirectory) throws IOException, ParseException {
            final Iterator<InputRow> iterator = this.rows.iterator();
            return new Firehose(){

                public boolean hasMore() {
                    return iterator.hasNext();
                }

                @Nullable
                public InputRow nextRow() {
                    return (InputRow)iterator.next();
                }

                public Runnable commit() {
                    return Runnables.getNoopRunnable();
                }

                public void close() throws IOException {
                }
            };
        }
    }
}

