/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.metadata;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryQueryToolChest;
import org.apache.hive.druid.io.druid.query.metadata.SegmentMetadataQueryRunnerFactory;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.ListColumnIncluderator;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentAnalysis;
import org.apache.hive.druid.io.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.hive.druid.io.druid.segment.IncrementalIndexSegment;
import org.apache.hive.druid.io.druid.segment.QueryableIndexSegment;
import org.apache.hive.druid.io.druid.segment.Segment;
import org.apache.hive.druid.io.druid.segment.TestHelper;
import org.apache.hive.druid.io.druid.segment.TestIndex;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.joda.time.Interval;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SegmentMetadataUnionQueryTest {
    private static final QueryRunnerFactory FACTORY = new SegmentMetadataQueryRunnerFactory(new SegmentMetadataQueryQueryToolChest(new SegmentMetadataQueryConfig()), QueryRunnerTestHelper.NOOP_QUERYWATCHER);
    private final QueryRunner runner;
    private final boolean mmap;

    public SegmentMetadataUnionQueryTest(QueryRunner runner, boolean mmap) {
        this.runner = runner;
        this.mmap = mmap;
    }

    @Parameterized.Parameters
    public static Iterable<Object[]> constructorFeeder() throws IOException {
        return ImmutableList.of((Object)new Object[]{QueryRunnerTestHelper.makeUnionQueryRunner(FACTORY, (Segment)new QueryableIndexSegment("testSegment", TestIndex.getMMappedTestIndex()), null), true}, (Object)new Object[]{QueryRunnerTestHelper.makeUnionQueryRunner(FACTORY, (Segment)new IncrementalIndexSegment(TestIndex.getIncrementalTestIndex(), "testSegment"), null), false});
    }

    @Test
    public void testSegmentMetadataUnionQuery() {
        SegmentAnalysis expected = new SegmentAnalysis("testSegment", (List)Lists.newArrayList((Object[])new Interval[]{Intervals.of((String)"2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z")}), (Map)ImmutableMap.of((Object)"placement", (Object)new ColumnAnalysis(ValueType.STRING.toString(), false, this.mmap ? 43524L : 43056L, Integer.valueOf(1), (Comparable)((Object)"preferred"), (Comparable)((Object)"preferred"), null)), this.mmap ? 669972L : 672752L, 4836L, null, null, null, null);
        SegmentMetadataQuery query = new Druids.SegmentMetadataQueryBuilder().dataSource((DataSource)QueryRunnerTestHelper.unionDataSource).intervals(QueryRunnerTestHelper.fullOnInterval).toInclude((ColumnIncluderator)new ListColumnIncluderator((List)Lists.newArrayList((Object[])new String[]{"placement"}))).analysisTypes(new SegmentMetadataQuery.AnalysisType[]{SegmentMetadataQuery.AnalysisType.CARDINALITY, SegmentMetadataQuery.AnalysisType.SIZE, SegmentMetadataQuery.AnalysisType.INTERVAL, SegmentMetadataQuery.AnalysisType.MINMAX}).build();
        List result = Sequences.toList((Sequence)this.runner.run(QueryPlus.wrap((Query)query), (Map)Maps.newHashMap()), (List)Lists.newArrayList());
        TestHelper.assertExpectedObjects(ImmutableList.of((Object)expected), result, "failed SegmentMetadata union query");
    }
}

