/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.groupby.having;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.RegexDimExtractionFn;
import org.apache.hive.druid.io.druid.query.groupby.having.DimensionSelectorHavingSpec;
import org.junit.Assert;
import org.junit.Test;

public class DimensionSelectorHavingSpecTest {
    private Row getTestRow(Object dimensionValue) {
        return new MapBasedRow(0L, (Map)ImmutableMap.of((Object)"dimension", (Object)dimensionValue));
    }

    @Test
    public void testDimSelectorHavingClauseSerde() throws Exception {
        DimensionSelectorHavingSpec dimHavingSpec = new DimensionSelectorHavingSpec("dim", "v", null);
        ImmutableMap dimSelectMap = ImmutableMap.of((Object)"type", (Object)"dimSelector", (Object)"dimension", (Object)"dim", (Object)"value", (Object)"v");
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Assert.assertEquals((Object)dimHavingSpec, (Object)mapper.convertValue((Object)dimSelectMap, DimensionSelectorHavingSpec.class));
    }

    @Test
    public void testEquals() throws Exception {
        RegexDimExtractionFn extractionFn1 = new RegexDimExtractionFn("^([^,]*),", Boolean.valueOf(false), "");
        RegexDimExtractionFn extractionFn2 = new RegexDimExtractionFn(",(.*)", Boolean.valueOf(false), "");
        RegexDimExtractionFn extractionFn3 = new RegexDimExtractionFn("^([^,]*),", Boolean.valueOf(false), "");
        DimensionSelectorHavingSpec dimHavingSpec1 = new DimensionSelectorHavingSpec("dim", "v", (ExtractionFn)extractionFn1);
        DimensionSelectorHavingSpec dimHavingSpec2 = new DimensionSelectorHavingSpec("dim", "v", (ExtractionFn)extractionFn3);
        DimensionSelectorHavingSpec dimHavingSpec3 = new DimensionSelectorHavingSpec("dim1", "v", null);
        DimensionSelectorHavingSpec dimHavingSpec4 = new DimensionSelectorHavingSpec("dim2", "v", null);
        DimensionSelectorHavingSpec dimHavingSpec5 = new DimensionSelectorHavingSpec("dim", "v1", null);
        DimensionSelectorHavingSpec dimHavingSpec6 = new DimensionSelectorHavingSpec("dim", "v2", null);
        DimensionSelectorHavingSpec dimHavingSpec7 = new DimensionSelectorHavingSpec("dim", null, null);
        DimensionSelectorHavingSpec dimHavingSpec8 = new DimensionSelectorHavingSpec("dim", null, null);
        DimensionSelectorHavingSpec dimHavingSpec9 = new DimensionSelectorHavingSpec("dim1", null, null);
        DimensionSelectorHavingSpec dimHavingSpec10 = new DimensionSelectorHavingSpec("dim2", null, null);
        DimensionSelectorHavingSpec dimHavingSpec11 = new DimensionSelectorHavingSpec("dim1", "v", null);
        DimensionSelectorHavingSpec dimHavingSpec12 = new DimensionSelectorHavingSpec("dim2", null, null);
        DimensionSelectorHavingSpec dimHavingSpec13 = new DimensionSelectorHavingSpec("dim", "value", (ExtractionFn)extractionFn1);
        DimensionSelectorHavingSpec dimHavingSpec14 = new DimensionSelectorHavingSpec("dim", "value", (ExtractionFn)extractionFn2);
        Assert.assertEquals((Object)dimHavingSpec1, (Object)dimHavingSpec2);
        Assert.assertNotEquals((Object)dimHavingSpec3, (Object)dimHavingSpec4);
        Assert.assertNotEquals((Object)dimHavingSpec5, (Object)dimHavingSpec6);
        Assert.assertEquals((Object)dimHavingSpec7, (Object)dimHavingSpec8);
        Assert.assertNotEquals((Object)dimHavingSpec9, (Object)dimHavingSpec10);
        Assert.assertNotEquals((Object)dimHavingSpec11, (Object)dimHavingSpec12);
        Assert.assertNotEquals((Object)dimHavingSpec13, (Object)dimHavingSpec14);
    }

    @Test
    public void testToString() {
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn("^([^,]*),", Boolean.valueOf(false), "");
        String expected = "DimensionSelectorHavingSpec{dimension='gender', value='m', extractionFn=regex(/^([^,]*),/, 1)}";
        Assert.assertEquals((Object)expected, (Object)new DimensionSelectorHavingSpec("gender", "m", (ExtractionFn)extractionFn).toString());
        expected = "DimensionSelectorHavingSpec{dimension='gender', value='m', extractionFn=Identity}";
        Assert.assertEquals((Object)expected, (Object)new DimensionSelectorHavingSpec("gender", "m", null).toString());
    }

    @Test(expected=NullPointerException.class)
    public void testNullDimension() {
        new DimensionSelectorHavingSpec(null, "value", null);
    }

    @Test
    public void testDimensionFilterSpec() {
        DimensionSelectorHavingSpec spec = new DimensionSelectorHavingSpec("dimension", "v", null);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow("v")));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v", (Object)"v1"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of())));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow("v1")));
        spec = new DimensionSelectorHavingSpec("dimension", null, null);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of())));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)""))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v", (Object)"v1"))));
        spec = new DimensionSelectorHavingSpec("dimension", "", null);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of())));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)""))));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v", (Object)"v1", (Object)""))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v", (Object)"v1"))));
        RegexDimExtractionFn extractionFn = new RegexDimExtractionFn("^([^,]*),", Boolean.valueOf(true), "default");
        spec = new DimensionSelectorHavingSpec("dimension", "v", (ExtractionFn)extractionFn);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v,v1", (Object)"v2,v3"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v1,v4"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v"))));
        Assert.assertFalse((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v1", (Object)"default"))));
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v,default", (Object)"none"))));
        spec = new DimensionSelectorHavingSpec("dimension", "default", (ExtractionFn)extractionFn);
        Assert.assertTrue((boolean)spec.eval(this.getTestRow(ImmutableList.of((Object)"v1,v2", (Object)"none"))));
    }
}

