/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.filter;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.guice.GuiceInjectors;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.java.util.common.Intervals;
import org.apache.hive.druid.io.druid.query.extraction.ExtractionFn;
import org.apache.hive.druid.io.druid.query.extraction.RegexDimExtractionFn;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.filter.IntervalDimFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntervalDimFilterTest {
    private static ObjectMapper mapper;

    @Before
    public void setUp() {
        Injector defaultInjector = GuiceInjectors.makeStartupInjector();
        mapper = (ObjectMapper)defaultInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
    }

    @Test
    public void testSerde() throws IOException {
        IntervalDimFilter intervalFilter = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        String filterStr = mapper.writeValueAsString((Object)intervalFilter);
        IntervalDimFilter actualFilter = (IntervalDimFilter)mapper.reader(DimFilter.class).readValue(filterStr);
        Assert.assertEquals((Object)intervalFilter, (Object)actualFilter);
        intervalFilter = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), (ExtractionFn)new RegexDimExtractionFn(".*", Boolean.valueOf(false), null));
        filterStr = mapper.writeValueAsString((Object)intervalFilter);
        actualFilter = (IntervalDimFilter)mapper.reader(DimFilter.class).readValue(filterStr);
        Assert.assertEquals((Object)intervalFilter, (Object)actualFilter);
    }

    @Test
    public void testGetCacheKey() {
        IntervalDimFilter intervalFilter1 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        IntervalDimFilter intervalFilter2 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1976-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertNotEquals((Object)intervalFilter1.getCacheKey(), (Object)intervalFilter2.getCacheKey());
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        IntervalDimFilter intervalFilter3 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), (ExtractionFn)regexFn);
        IntervalDimFilter intervalFilter4 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1976-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), (ExtractionFn)regexFn);
        Assert.assertNotEquals((Object)intervalFilter3.getCacheKey(), (Object)intervalFilter4.getCacheKey());
    }

    @Test
    public void testHashCode() {
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        IntervalDimFilter intervalFilter1 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        IntervalDimFilter intervalFilter2 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), (ExtractionFn)regexFn);
        IntervalDimFilter intervalFilter3 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1977-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertNotEquals((long)intervalFilter1.hashCode(), (long)intervalFilter2.hashCode());
        Assert.assertNotEquals((long)intervalFilter1.hashCode(), (long)intervalFilter3.hashCode());
        IntervalDimFilter intervalFilter4 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1977-01-01T00:00:00.004Z"), Intervals.of((String)"1976-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertEquals((long)intervalFilter1.hashCode(), (long)intervalFilter4.hashCode());
        IntervalDimFilter intervalFilter5 = new IntervalDimFilter("__thyme", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertNotEquals((long)intervalFilter1.hashCode(), (long)intervalFilter5.hashCode());
    }

    @Test
    public void testEquals() {
        RegexDimExtractionFn regexFn = new RegexDimExtractionFn(".*", Boolean.valueOf(false), null);
        IntervalDimFilter intervalFilter1 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        IntervalDimFilter intervalFilter2 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), (ExtractionFn)regexFn);
        IntervalDimFilter intervalFilter3 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1977-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertNotEquals((Object)intervalFilter1, (Object)intervalFilter2);
        Assert.assertNotEquals((Object)intervalFilter1, (Object)intervalFilter3);
        IntervalDimFilter intervalFilter4 = new IntervalDimFilter("__time", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1977-01-01T00:00:00.004Z"), Intervals.of((String)"1976-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertEquals((Object)intervalFilter1, (Object)intervalFilter4);
        IntervalDimFilter intervalFilter5 = new IntervalDimFilter("__thyme", Arrays.asList(Intervals.of((String)"1970-01-01T00:00:00.001Z/1970-01-01T00:00:00.004Z"), Intervals.of((String)"1975-01-01T00:00:00.001Z/1980-01-01T00:00:00.004Z")), null);
        Assert.assertNotEquals((Object)intervalFilter1, (Object)intervalFilter5);
    }
}

