/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.hyperloglog;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;
import org.apache.hive.druid.io.druid.hll.HyperLogLogCollector;
import org.apache.hive.druid.io.druid.query.aggregation.cardinality.CardinalityAggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.hyperloglog.HyperUniqueFinalizingPostAggregator;
import org.apache.hive.druid.io.druid.query.dimension.DefaultDimensionSpec;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class HyperUniqueFinalizingPostAggregatorTest {
    private final HashFunction fn = Hashing.murmur3_128();

    @Test
    public void testCompute() throws Exception {
        Random random = new Random(0L);
        HyperUniqueFinalizingPostAggregator postAggregator = new HyperUniqueFinalizingPostAggregator("uniques", "uniques");
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < 100; ++i) {
            byte[] hashedVal = this.fn.hashLong(random.nextLong()).asBytes();
            collector.add(hashedVal);
        }
        double cardinality = (Double)postAggregator.compute((Map)ImmutableMap.of((Object)"uniques", (Object)collector));
        Assert.assertTrue((cardinality == 99.37233005831612 ? 1 : 0) != 0);
    }

    @Test
    public void testComputeRounded() throws Exception {
        Random random = new Random(0L);
        HyperUniqueFinalizingPostAggregator postAggregator = new HyperUniqueFinalizingPostAggregator("uniques", "uniques").decorate((Map)ImmutableMap.of((Object)"uniques", (Object)new CardinalityAggregatorFactory("uniques", null, Collections.singletonList(DefaultDimensionSpec.of((String)"dummy")), false, true)));
        HyperLogLogCollector collector = HyperLogLogCollector.makeLatestCollector();
        for (int i = 0; i < 100; ++i) {
            byte[] hashedVal = this.fn.hashLong(random.nextLong()).asBytes();
            collector.add(hashedVal);
        }
        Object cardinality = postAggregator.compute((Map)ImmutableMap.of((Object)"uniques", (Object)collector));
        Assert.assertThat((Object)cardinality, (Matcher)CoreMatchers.instanceOf(Long.class));
        Assert.assertEquals((Object)99L, (Object)cardinality);
    }
}

