/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.DataSource;
import org.apache.hive.druid.io.druid.query.Druids;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.io.druid.query.TableDataSource;
import org.apache.hive.druid.io.druid.query.UnionDataSource;
import org.apache.hive.druid.io.druid.query.UnionQueryRunner;
import org.apache.hive.druid.io.druid.query.timeseries.TimeseriesQuery;
import org.junit.Test;

public class UnionQueryRunnerTest {
    @Test
    public void testUnionQueryRunner() {
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, Map responseContext) {
                Assert.assertTrue((boolean)(queryPlus.getQuery().getDataSource() instanceof TableDataSource));
                String dsName = (String)Iterables.getOnlyElement((Iterable)queryPlus.getQuery().getDataSource().getNames());
                if (dsName.equals("ds1")) {
                    responseContext.put("ds1", "ds1");
                    return Sequences.simple(Arrays.asList(1, 2, 3));
                }
                if (dsName.equals("ds2")) {
                    responseContext.put("ds2", "ds2");
                    return Sequences.simple(Arrays.asList(4, 5, 6));
                }
                throw new AssertionError((Object)"Unexpected DataSource");
            }
        };
        UnionQueryRunner runner = new UnionQueryRunner(baseRunner);
        TimeseriesQuery q = Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new UnionDataSource(Arrays.asList(new TableDataSource("ds1"), new TableDataSource("ds2")))).intervals("2014-01-01T00:00:00Z/2015-01-01T00:00:00Z").aggregators(QueryRunnerTestHelper.commonDoubleAggregators).build();
        HashMap responseContext = Maps.newHashMap();
        Sequence result = runner.run(QueryPlus.wrap((Query)q), (Map)responseContext);
        List res = Sequences.toList((Sequence)result, (List)Lists.newArrayList());
        Assert.assertEquals(Arrays.asList(1, 2, 3, 4, 5, 6), (Object)res);
        Assert.assertEquals((int)2, (int)responseContext.size());
        Assert.assertEquals((Object)"ds1", responseContext.get("ds1"));
        Assert.assertEquals((Object)"ds2", responseContext.get("ds2"));
    }
}

